/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.titech.cs.se.fl.player;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ac.titech.cs.se.fl.player.Activator;
import jp.ac.titech.cs.se.fl.player.Method;
import jp.ac.titech.cs.se.fl.player.Problem;
import jp.ac.titech.cs.se.fl.player.TaskFormatException;
import jp.ac.titech.cs.se.fl.player.Util;
import jp.ac.titech.cs.se.fl.player.ViewerSorter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerViewPart
extends ViewPart
implements IDoubleClickListener {
    private static Logger log = LoggerFactory.getLogger(PlayerViewPart.class);
    private TableViewer viewer;
    private Label label;
    private Problem problem = new Problem();
    private String opened;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.label = new Label(parent, 64);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        this.label.setLayoutData((Object)fd);
        this.viewer = new TableViewer(parent, 66308);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.label, 2);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment(100, -1);
        this.viewer.getTable().setLayoutData((Object)fd);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tc = new TableViewerColumn(this.viewer, 131072);
        tc.setLabelProvider((CellLabelProvider)new IndexLabelProvider());
        TableColumn col = tc.getColumn();
        col.setText("ID");
        col.setWidth(50);
        col.setResizable(true);
        col.setMoveable(false);
        new ViewerSorter((ColumnViewer)this.viewer, tc){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return PlayerViewPart.this.problem.getMethods().indexOf(e1) - PlayerViewPart.this.problem.getMethods().indexOf(e2);
            }
        };
        tc = new TableViewerColumn(this.viewer, 16384);
        tc.setLabelProvider((CellLabelProvider)new RelevanceLabelProvider());
        tc.setEditingSupport((EditingSupport)new RelevanceEditingSupport());
        col = tc.getColumn();
        col.setText("Relevance");
        col.setWidth(80);
        col.setResizable(true);
        col.setMoveable(false);
        new ViewerSorter((ColumnViewer)this.viewer, tc){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return ((Method)e1).getRelevance() - ((Method)e2).getRelevance();
            }
        };
        tc = new TableViewerColumn(this.viewer, 16384);
        tc.getViewer().addDoubleClickListener((IDoubleClickListener)this);
        tc.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new NameLabelProvider()));
        col = tc.getColumn();
        col.setText("Name");
        col.setWidth(400);
        col.setResizable(true);
        col.setMoveable(false);
        new ViewerSorter((ColumnViewer)this.viewer, tc){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return ((Method)e1).getQualifiedName().compareTo(((Method)e2).getQualifiedName());
            }
        };
        tc = new TableViewerColumn(this.viewer, 16384);
        tc.setLabelProvider((CellLabelProvider)new ReasonLabelProvider());
        tc.setEditingSupport((EditingSupport)new ReasonEditingSupport());
        col = tc.getColumn();
        col.setText("Reason");
        col.setWidth(400);
        col.setResizable(true);
        col.setMoveable(false);
        new ViewerSorter((ColumnViewer)this.viewer, tc){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return ((Method)e1).getReason().compareTo(((Method)e2).getReason());
            }
        };
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)new LoadAction());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Method m = (Method)sel.getFirstElement();
        if (m.getJavaMethod() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)m.getJavaMethod());
                log.info("{} opened.", (Object)m);
            }
            catch (PartInitException e) {
                log.error("Error occured.", (Throwable)e);
            }
            catch (JavaModelException e) {
                log.error("Error occured.", (Throwable)e);
            }
        } else {
            log.error("IMethod is null: {}", (Object)m);
        }
    }

    public void addMethod(IMethod javaMethod) {
        Method m2;
        String fqn = Util.getFullQualifiedName(javaMethod);
        for (Method m2 : this.problem.getMethods()) {
            if (!m2.getQualifiedName().equals(fqn)) continue;
            m2.setRelevance(1);
            log.info("Made {} relevant via addition.", (Object)m2);
            this.backup();
            this.viewer.refresh((Object)m2);
            return;
        }
        m2 = new Method();
        m2.setQualifiedName(fqn);
        m2.cacheJavaMethod(javaMethod);
        m2.setInitial(false);
        m2.setRelevance(1);
        this.problem.getMethods().add(m2);
        log.info("{} added.", (Object)m2);
        this.backup();
        this.viewer.setInput((Object)this.problem);
    }

    public static PlayerViewPart findView() {
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            IViewPart view = page.showView(PlayerViewPart.class.getName());
            if (view != null) {
                return (PlayerViewPart)view;
            }
        }
        catch (PartInitException e) {
            log.error("Error occured.", (Throwable)e);
        }
        return null;
    }

    public void backup() {
        if (this.opened != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            String suffix = format.format(new Date());
            String file = String.valueOf(this.opened) + "." + suffix;
            Problem.save(this.problem, new File(file));
            log.debug("Backup file {} stored.", (Object)file);
        }
    }

    public static class ContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer viewer, Object obj, Object obj1) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            return ((Problem)input).getMethods().toArray();
        }
    }

    class IndexLabelProvider
    extends ColumnLabelProvider {
        IndexLabelProvider() {
        }

        public String getText(Object element) {
            return String.valueOf(PlayerViewPart.this.problem.getMethods().indexOf(element) + 1);
        }
    }

    class LoadAction
    extends Action {
        public LoadAction() {
            this.setText("Load");
            this.setToolTipText("Load a problem");
            this.setEnabled(true);
            Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
        }

        public void loadJavaMethod(Problem problem) {
            IJavaProject project = Util.getJavaProject(problem.getProject());
            if (project == null) {
                log.error("Project is null.");
                return;
            }
            for (Method m : problem.getMethods()) {
                IMethod javaMethod = Util.findMethod(project, m.getQualifiedName());
                if (javaMethod == null) {
                    log.error("{}: Associated IMethod not found.", (Object)m);
                    continue;
                }
                m.cacheJavaMethod(javaMethod);
            }
        }

        public void run() {
            FileDialog dialog = new FileDialog(PlayerViewPart.this.getSite().getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String file = dialog.open();
            if (file != null) {
                log.info("File selected: {}", (Object)file);
                try {
                    PlayerViewPart.this.problem = Problem.load(new File(file));
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)PlayerViewPart.this.getSite().getShell(), (String)"FL Player", (String)String.format("Loading %s:\n%s", file, e));
                    e.printStackTrace();
                    return;
                }
                catch (TaskFormatException e) {
                    MessageDialog.openError((Shell)PlayerViewPart.this.getSite().getShell(), (String)"FL Player", (String)String.format("Loading %s:\n%s", file, e));
                    e.printStackTrace();
                    return;
                }
                PlayerViewPart.this.opened = file;
                this.loadJavaMethod(PlayerViewPart.this.problem);
                PlayerViewPart.this.label.setText(PlayerViewPart.this.problem.getTitle());
                PlayerViewPart.this.label.setToolTipText(PlayerViewPart.this.problem.getLongDescription());
                PlayerViewPart.this.viewer.setInput((Object)PlayerViewPart.this.problem);
                PlayerViewPart.this.viewer.getTable().getColumn(0).pack();
                PlayerViewPart.this.viewer.getTable().getColumn(2).pack();
                PlayerViewPart.this.viewer.getTable().setSortColumn(null);
                PlayerViewPart.this.viewer.getTable().setSortDirection(0);
                PlayerViewPart.this.viewer.setComparator(null);
            }
        }
    }

    static class NameLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final JavaElementLabelProvider provider = new JavaElementLabelProvider();

        public NameLabelProvider() {
            this.provider.turnOn(1024);
            this.provider.turnOn(2);
        }

        private IMethod getElement(Object element) {
            return ((Method)element).getJavaMethod();
        }

        public Image getImage(Object element) {
            return this.provider.getImage((Object)this.getElement(element));
        }

        public String getText(Object element) {
            if (this.getElement(element) != null) {
                return this.provider.getText((Object)this.getElement(element));
            }
            return ((Method)element).getQualifiedName();
        }

        public StyledString getStyledText(Object element) {
            return this.provider.getStyledText((Object)this.getElement(element));
        }
    }

    class ReasonEditingSupport
    extends EditingSupport {
        public ReasonEditingSupport() {
            super((ColumnViewer)PlayerViewPart.this.viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)PlayerViewPart.this.viewer.getTable());
        }

        protected Object getValue(Object element) {
            String value = ((Method)element).getReason();
            return value == null ? "" : value;
        }

        protected void setValue(Object element, Object value) {
            Method m = (Method)element;
            String result = (String)value;
            if (result != null && result.isEmpty()) {
                result = null;
            }
            if (result == null && m.getReason() == null || result != null && result.equals(m.getReason())) {
                log.info("{}: reason edited, but not changed.", (Object)m);
            } else {
                m.setReason(result);
                log.info("{}: reason changed. '{}'", (Object)m, (Object)result);
                PlayerViewPart.this.backup();
                PlayerViewPart.this.viewer.refresh(element);
            }
        }
    }

    static class ReasonLabelProvider
    extends ColumnLabelProvider {
        ReasonLabelProvider() {
        }

        public String getText(Object element) {
            return ((Method)element).getReason();
        }
    }

    static class RelevanceCellEditor
    extends ComboBoxCellEditor {
        public RelevanceCellEditor(Composite parent) {
            super(parent, RelevanceLabelProvider.CAPTIONS, 8);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData layoutData = super.getLayoutData();
            if (layoutData.minimumWidth > 60) {
                layoutData.minimumWidth = 80;
            }
            return layoutData;
        }
    }

    class RelevanceEditingSupport
    extends EditingSupport {
        public RelevanceEditingSupport() {
            super((ColumnViewer)PlayerViewPart.this.viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new RelevanceCellEditor((Composite)PlayerViewPart.this.viewer.getTable());
        }

        protected Object getValue(Object element) {
            return ((Method)element).getRelevance();
        }

        protected void setValue(Object element, Object value) {
            Method m = (Method)element;
            Integer result = (Integer)value;
            if (result != null) {
                if (result.intValue() == m.getRelevance()) {
                    log.info("{}: relevance edited, but not changed.", (Object)m);
                } else {
                    m.setRelevance(result);
                    log.info("{}: relevance changed.", (Object)m);
                    PlayerViewPart.this.backup();
                    PlayerViewPart.this.viewer.refresh(element);
                }
            }
        }
    }

    static class RelevanceLabelProvider
    extends ColumnLabelProvider {
        public static final String[] CAPTIONS = new String[]{"-", "Relevant", "Irrelevant"};

        RelevanceLabelProvider() {
        }

        public Font getFont(Object element) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }

        public String getText(Object element) {
            return CAPTIONS[((Method)element).getRelevance()];
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class SaveAction
    extends Action {
        public SaveAction() {
            this.setText("Save");
            this.setToolTipText("Save the problem");
            this.setEnabled(true);
            Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT");
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
        }

        public void run() {
            if (PlayerViewPart.this.opened != null) {
                Problem.save(PlayerViewPart.this.problem, new File(PlayerViewPart.this.opened));
            } else {
                FileDialog dialog = new FileDialog(PlayerViewPart.this.getSite().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String file = dialog.open();
                if (file != null) {
                    PlayerViewPart.this.opened = file;
                    Problem.save(PlayerViewPart.this.problem, new File(PlayerViewPart.this.opened));
                }
            }
        }
    }
}

