/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.titech.cs.se.fl.player;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ac.titech.cs.se.fl.player.Method;
import jp.ac.titech.cs.se.fl.player.TaskFormatException;

public class Problem {
    private String project = null;
    private String issue = null;
    private String id = null;
    private String shortDescription = null;
    private String longDescription = null;
    private String featureDescription = null;
    private List<Method> methods = new ArrayList<Method>();

    public List<Method> getMethods() {
        return this.methods;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    public static Problem load(File file) throws IOException {
        Problem result = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(stream));
            result = (Problem)decoder.readObject();
            decoder.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TaskFormatException("Illegal format", e);
        }
        return result;
    }

    public static void save(Problem problem, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            XMLEncoder encoder = new XMLEncoder(out);
            encoder.writeObject(problem);
            encoder.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getTitle() {
        return String.format("%s %s (%s) - %s", this.project, this.issue, this.id, this.shortDescription);
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getFeatureDescription() {
        return this.featureDescription;
    }

    public void setFeatureDescription(String featureDescription) {
        this.featureDescription = featureDescription;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }
}

