/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.titech.cs.se.fl.player;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger log = LoggerFactory.getLogger(Util.class);

    public static IJavaProject getJavaProject(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(name);
        try {
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] splitQualifiedName(String qn) {
        Pattern p = Pattern.compile("(.+)\\.([^\\.]+\\(.*\\))");
        Matcher m = p.matcher(qn);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public static IMethod findMethod(IJavaProject project, String fqn) {
        IType type;
        String methodName;
        block3: {
            String[] classMethod = Util.splitQualifiedName(fqn);
            String className = classMethod[0];
            methodName = classMethod[1];
            try {
                type = project.findType(className);
                if (type != null) break block3;
                return null;
            }
            catch (JavaModelException e) {
                log.error("Error occured.", (Throwable)e);
                return null;
            }
        }
        return Util.findMethod(type, methodName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static IMethod findMethod(IType klass, String qn) {
        qn = qn.replace(" ", "");
        try {
            IMethod[] iMethodArray = klass.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Util.getQualifiedName(m).equals(qn)) {
                    List<IMethod> arrayRemoved = Util.findMethodNormalizedArray(klass, qn);
                    if (arrayRemoved.size() != 1) {
                        log.error("Found multiple ({}) methods associated with {}", (Object)arrayRemoved.size(), (Object)qn);
                        for (IMethod m0 : arrayRemoved) {
                            log.error(Util.getQualifiedName(m0));
                        }
                        return null;
                    }
                    return m;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            log.error("Error occured.", (Throwable)e);
        }
        return null;
    }

    public static List<IMethod> findMethodNormalizedArray(IType klass, String qn) {
        qn = qn.replace(" ", "").replace("[]", "");
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        try {
            IMethod[] iMethodArray = klass.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Util.getQualifiedName(m).replace("[]", "").equals(qn)) {
                    result.add(m);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            log.error("Error occured.", (Throwable)e);
        }
        return result;
    }

    public static String getQualifiedName(IMethod method) {
        StringBuilder result = new StringBuilder();
        result.append(method.getElementName());
        result.append("(");
        String comma = "";
        String[] stringArray = method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            result.append(comma);
            result.append(Signature.toString((String)param));
            comma = ",";
            ++n2;
        }
        result.append(")");
        return result.toString();
    }

    public static String getFullQualifiedName(IMethod method) {
        String c = method.getDeclaringType().getFullyQualifiedName().replace('$', '.');
        String m = Util.getQualifiedName(method);
        return String.valueOf(c) + "." + m;
    }
}

