/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.titech.cs.se.fl.player;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewerSorter
extends ViewerComparator
implements SelectionListener {
    private static Logger log = LoggerFactory.getLogger(ViewerSorter.class);
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private int direction = 0;
    private final TableViewerColumn column;
    private final ColumnViewer viewer;

    public ViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
        this.column = column;
        this.viewer = viewer;
        column.getColumn().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.viewer.getComparator() == this) {
            this.setSorter(this.direction == 1 ? -1 : 0);
        } else {
            this.setSorter(1);
        }
    }

    public void setSorter(int newDirection) {
        if (newDirection == 0) {
            log.info("Sorting canceled.");
            this.column.getColumn().getParent().setSortColumn(null);
            this.column.getColumn().getParent().setSortDirection(0);
            this.viewer.setComparator(null);
        } else {
            log.info("Sorting in order of {} {} selected.", (Object)this.column.getColumn().getText(), (Object)(newDirection == 1 ? "ASC" : "DESC"));
            this.column.getColumn().getParent().setSortColumn(this.column.getColumn());
            this.direction = newDirection;
            this.column.getColumn().getParent().setSortDirection(newDirection == 1 ? 1024 : 128);
            if (this.viewer.getComparator() == this) {
                this.viewer.refresh();
            } else {
                this.viewer.setComparator((ViewerComparator)this);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

