package org.apache.commons.javaflow.bytecode.transformation.asm;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.commons.javaflow.bytecode.transformation.AbstractTransformerTestCase;
import org.apache.commons.javaflow.bytecode.transformation.ClassTransformerClassLoader;


public final class InvokerTestCase extends TestCase {

    public static Test suite() throws Exception {

    	final ClassTransformerClassLoader classloader =
            new ClassTransformerClassLoader(new AsmClassTransformer());
        
        final Class clazz = classloader.loadClass(
        		AbstractTransformerTestCase.getTestCaseClassName(
        				InvokerTestCase.class));

        final TestSuite suite = new TestSuite(classloader.createImplementationOf(clazz));
        suite.setName("ASM " + clazz.getName());
        return suite;
    }
    
}

