package org.agilewiki.elementmodel.wholeness.roots.updatecommands;

import org.agilewiki.elementmodel.wholeness.descriptor.commands.CommandHelper;
import java.util.TreeMap;
import org.agilewiki.elementmodel.Capability;
import org.agilewiki.elementmodel.elements.Element;
import org.agilewiki.elementmodel.wholeness.descriptor.OperationRequest;
import org.agilewiki.elementmodel.elements.RootElement;
import org.agilewiki.elementmodel.wholeness.roots.AbstractCommandRoot;

public class LoadCommandRoot extends AbstractCommandRoot
{
    public LoadCommandRoot(Element element){
            super(element);
    }

@Override
  public Object processOperationRequest(
      Capability source, 
      OperationRequest operationRequest, 
      TreeMap<String, String> contextMap) 
{
    CommandHelper ch = new CommandHelper(this,contextMap,source,operationRequest);
    if (!ch.noArguments())
    {
      return ch.response();
    }
    if (!ch.hasValidWorkingContext())
    {
      return ch.response();
    }
    RootElement re = ch.targetElement.getRootElement();
    re.load();
    return ch.response();
  }
}
