package jp.ac.osaka_u.ist.sel.android.simn;

import jp.ac.osaka_u.ist.sel.android.simn.impl.Point;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import jp.ac.osaka_u.ist.sel.android.simn.R;

public class BlockData {
	private Point[][][] points = new Point[7][4][3];
	private Point[][] blocks = new Point[3][2];
	private Point[][] centers = new Point[3][4];
	private Bitmap cellImage[] = new Bitmap[7];
	private Paint normal;
	private Paint ghost;
	
	public BlockData(Context context){
		points[0][0][0] = new Point(-2 * GameSetting.CELL_SIZE,0);
		points[0][0][1] = new Point(-GameSetting.CELL_SIZE,0);
		points[0][0][2] = new Point(GameSetting.CELL_SIZE,0);
		points[0][1][0] = new Point(0,-GameSetting.CELL_SIZE);
		points[0][1][1] = new Point(0,GameSetting.CELL_SIZE);
		points[0][1][2] = new Point(0,2 * GameSetting.CELL_SIZE);
		points[0][2][0] = points[0][0][1];
		points[0][2][1] = points[0][0][2];
		points[0][2][2] = new Point(2 * GameSetting.CELL_SIZE,0);
		points[0][3][0] = new Point(0,-2 * GameSetting.CELL_SIZE);
		points[0][3][1] = points[0][1][0];
		points[0][3][2] = points[0][1][1];
		points[1][0][0] = points[0][0][1];
		points[1][0][1] = points[0][1][1];
		points[1][0][2] = new Point(-GameSetting.CELL_SIZE,GameSetting.CELL_SIZE);
		points[1][1][0] = points[0][0][2];
		points[1][1][1] = points[0][1][1];
		points[1][1][2] = new Point(GameSetting.CELL_SIZE,GameSetting.CELL_SIZE);
		points[1][2][0] = points[0][0][2];
		points[1][2][1] = points[0][1][0];
		points[1][2][2] = new Point(GameSetting.CELL_SIZE,-GameSetting.CELL_SIZE);
		points[1][3][0] = points[0][0][1];
		points[1][3][1] = points[0][1][0];
		points[1][3][2] = new Point(-GameSetting.CELL_SIZE,-GameSetting.CELL_SIZE);
		points[2][0][0] = points[0][0][1];
		points[2][0][1] = points[0][0][2];
		points[2][0][2] = points[1][0][2];
		points[2][1][0] = points[0][1][0];
		points[2][1][1] = points[0][1][1];
		points[2][1][2] = points[1][1][2];
		points[2][2][0] = points[0][0][1];
		points[2][2][1] = points[0][0][2];
		points[2][2][2] = points[1][2][2];
		points[2][3][0] = points[0][1][0];
		points[2][3][1] = points[0][1][1];
		points[2][3][2] = points[1][3][2];
		points[3][0][0] = points[0][0][1];
		points[3][0][1] = points[0][0][2];
		points[3][0][2] = points[1][1][2];
		points[3][1][0] = points[0][1][0];
		points[3][1][1] = points[0][1][1];
		points[3][1][2] = points[1][2][2];
		points[3][2][0] = points[0][0][1];
		points[3][2][1] = points[0][0][2];
		points[3][2][2] = points[1][3][2];
		points[3][3][0] = points[0][1][0];
		points[3][3][1] = points[0][1][1];
		points[3][3][2] = points[1][0][2];
		points[4][0][0] = points[0][0][1];
		points[4][0][1] = points[0][1][1];
		points[4][0][2] = points[1][1][2];
		points[4][1][0] = points[0][1][1];
		points[4][1][1] = points[0][0][2];
		points[4][1][2] = points[1][2][2];
		points[4][2][0] = points[0][0][2];
		points[4][2][1] = points[0][1][0];
		points[4][2][2] = points[1][3][2];
		points[4][3][0] = points[0][1][0];
		points[4][3][1] = points[0][0][1];
		points[4][3][2] = points[1][0][2];
		points[5][0][0] = points[0][0][2];
		points[5][0][1] = points[0][1][1];
		points[5][0][2] = points[1][0][2];
		points[5][1][0] = points[0][1][0];
		points[5][1][1] = points[0][0][2];
		points[5][1][2] = points[1][1][2];
		points[5][2][0] = points[0][0][1];
		points[5][2][1] = points[0][1][0];
		points[5][2][2] = points[1][2][2];
		points[5][3][0] = points[0][1][1];
		points[5][3][1] = points[0][0][1];
		points[5][3][2] = points[1][3][2];
		points[6][0][0] = points[0][1][1];
		points[6][0][1] = points[1][0][2];
		points[6][0][2] = points[1][1][2];
		points[6][1][0] = points[0][0][2];
		points[6][1][1] = points[1][2][2];
		points[6][1][2] = points[1][1][2];
		points[6][2][0] = points[0][1][0];
		points[6][2][1] = points[1][3][2];
		points[6][2][2] = points[1][2][2];
		points[6][3][0] = points[0][0][1];
		points[6][3][1] = points[1][3][2];
		points[6][3][2] = points[1][0][2];
		blocks[0][0] = new Point(4 * GameSetting.CELL_SIZE,GameSetting.CELL_SIZE);
		blocks[0][1] = new Point(GameSetting.CELL_SIZE,4 * GameSetting.CELL_SIZE);
		blocks[1][0] = new Point(2 * GameSetting.CELL_SIZE,2 * GameSetting.CELL_SIZE);
		blocks[1][1] = blocks[1][0];
		blocks[2][0] = new Point(3 * GameSetting.CELL_SIZE,2 * GameSetting.CELL_SIZE);
		blocks[2][1] = new Point(2 * GameSetting.CELL_SIZE,3 * GameSetting.CELL_SIZE);
		centers[0][0] = new Point(2 * GameSetting.CELL_SIZE,0);
		centers[0][1] = new Point(0,GameSetting.CELL_SIZE);
		centers[0][2] = new Point(GameSetting.CELL_SIZE,0);
		centers[0][3] = new Point(0,2 * GameSetting.CELL_SIZE);
		centers[1][0] = centers[0][2];
		centers[1][1] = new Point(0,0);
		centers[1][2] = centers[0][1];
		centers[1][3] = new Point(GameSetting.CELL_SIZE,GameSetting.CELL_SIZE);
		centers[2][0] = centers[0][2];
		centers[2][1] = centers[0][1];
		centers[2][2] = centers[1][3];
		centers[2][3] = centers[1][3];
		Resources resource = context.getResources();
		cellImage[0] = BitmapFactory.decodeResource(resource, R.drawable.icell);
		cellImage[1] = BitmapFactory.decodeResource(resource, R.drawable.ocell);
		cellImage[2] = BitmapFactory.decodeResource(resource, R.drawable.lcell);
		cellImage[3] = BitmapFactory.decodeResource(resource, R.drawable.jcell);
		cellImage[4] = BitmapFactory.decodeResource(resource, R.drawable.zcell);
		cellImage[5] = BitmapFactory.decodeResource(resource, R.drawable.scell);
		cellImage[6] = BitmapFactory.decodeResource(resource, R.drawable.tcell);
		normal = new Paint();
		ghost = new Paint();
		ghost.setAlpha(125);
	}
	
	public Bitmap getImage(BlockType type){
		switch(type){
		case I:
			return cellImage[0];
		case O:
			return cellImage[1];
		case L:
			return cellImage[2];
		case J:
			return cellImage[3];
		case Z:
			return cellImage[4];
		case S:
			return cellImage[5];
		default:
			return cellImage[6];
		}
	}
	
	public Paint getNormalPaint(){
		return normal;
	}
	
	public Paint getGhostPaint(){
		return ghost;
	}
	
	public Point[] getCellPosition(BlockType type, BlockDirection direction){
		switch(type){
		case I:
			switch(direction){
			case Front:
				return points[0][0];
			case Left:
				return points[0][1];
			case Back:
				return points[0][2];
			default:
				return points[0][3];
			}
		case O:
			switch(direction){
			case Front:
				return points[1][0];
			case Left:
				return points[1][1];
			case Back:
				return points[1][2];
			default:
				return points[1][3];
			}
		case L:
			switch(direction){
			case Front:
				return points[2][0];
			case Left:
				return points[2][1];
			case Back:
				return points[2][2];
			default:
				return points[2][3];
			}
		case J:
			switch(direction){
			case Front:
				return points[3][0];
			case Left:
				return points[3][1];
			case Back:
				return points[3][2];
			default:
				return points[3][3];
			}
		case Z:
			switch(direction){
			case Front:
				return points[4][0];
			case Left:
				return points[4][1];
			case Back:
				return points[4][2];
			default:
				return points[4][3];
			}
		case S:
			switch(direction){
			case Front:
				return points[5][0];
			case Left:
				return points[5][1];
			case Back:
				return points[5][2];
			default:
				return points[5][3];
			}
		default:
			switch(direction){
			case Front:
				return points[6][0];
			case Left:
				return points[6][1];
			case Back:
				return points[6][2];
			default:
				return points[6][3];
			}
		}
	}
	
	public Point getBlockSize(BlockType type, BlockDirection direction){
		switch(type){
		case I:
			if(direction == BlockDirection.Front || 
					direction == BlockDirection.Back){
				return blocks[0][0];
			}else{
				return blocks[0][1];
			}
		case O:
			if(direction == BlockDirection.Front || 
					direction == BlockDirection.Back){
				return blocks[1][0];
			}else{
				return blocks[1][1];
			}
		default:
			if(direction == BlockDirection.Front || 
					direction == BlockDirection.Back){
				return blocks[2][0];
			}else{
				return blocks[2][1];
			}
		}
	}
	
	public Point getCenterPosition(BlockType type, BlockDirection direction){
		switch(type){
		case I:
			switch(direction){
			case Front:
				return centers[0][0];
			case Left:
				return centers[0][1];
			case Back:
				return centers[0][2];
			default:
				return centers[0][3];
			}
		case O:
			switch(direction){
			case Front:
				return centers[1][0];
			case Left:
				return centers[1][1];
			case Back:
				return centers[1][2];
			default:
				return centers[1][3];
			}
		default:
			switch(direction){
			case Front:
				return centers[2][0];
			case Left:
				return centers[2][1];
			case Back:
				return centers[2][2];
			default:
				return centers[2][3];
			}
		}
	}
}
