package jp.ac.osaka_u.ist.sel.android.simn;

import jp.ac.osaka_u.ist.sel.android.simn.impl.Point;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class BlockField extends View{
	private BlockType type = null;
	private BlockDirection direction;
	private int width;
	private int height;
	private BlockData data;
	
	public BlockField(Context context) {
		super(context);
		setup();
	}

	public BlockField(Context context, AttributeSet attrs) {
		super(context, attrs);
		setup();
	}

	public BlockField(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		setup();
	}
	
	private void setup(){
		setLayoutParams(new FrameLayout.LayoutParams(
				FrameLayout.LayoutParams.FILL_PARENT,
				FrameLayout.LayoutParams.FILL_PARENT));
	}
	
	public void setType(BlockType type){
		this.type = type;
	}
	
	public void setSize(){
		width = getWidth();
		height = getHeight();
	}
	
	public void setDirction(BlockDirection direction){
		this.direction = direction;
	}
	
	public void setData(BlockData data){
		this.data = data;
	}
	
	public BlockType getType(){
		return type;
	}
	
	public BlockDirection getDirection(){
		return direction;
	}
	
	public void reset(){
		type = null;
	}
	
	protected void onDraw(Canvas canvas){
		if(type == null){
			return;
		}
		Point size = data.getBlockSize(type, direction);
		float pointX = (width - size.getX()) / 2;
		float pointY = (height - size.getY()) / 2;
		Point center = data.getCenterPosition(type, direction);
		float centerX = pointX + center.getX();
		float centerY = pointY + center.getY();
		Bitmap image = data.getImage(type);
		Paint normal = data.getNormalPaint();
		Point points[] = data.getCellPosition(type,direction);
		canvas.drawBitmap(image, centerX, centerY, normal);
		canvas.drawBitmap(image, centerX+points[0].getX(), centerY+points[0].getY(), normal);
		canvas.drawBitmap(image, centerX+points[1].getX(), centerY+points[1].getY(), normal);
		canvas.drawBitmap(image, centerX+points[2].getX(), centerY+points[2].getY(), normal);
		
	}
}
