package jp.ac.osaka_u.ist.sel.android.simn;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

import jp.ac.osaka_u.ist.sel.android.simn.impl.BlockOperator;
import jp.ac.osaka_u.ist.sel.android.simn.impl.Cell;
import jp.ac.osaka_u.ist.sel.android.simn.impl.Point;
import jp.ac.osaka_u.ist.sel.android.simn.impl.RealPoint;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class MainField extends View {
	private static final int CUT_COUNT = 40;
	private static final double PER_ALPHA = 255 / (CUT_COUNT / 5);
	private BlockOperator currentBlock = null;
	private LinkedList<HashSet<CellData>> rows = new LinkedList<HashSet<CellData>>();
	private BlockData data;
	private EventNotifier<CutCompleteListener> listeners;
	private Paint cut = new Paint();
	private TreeSet<Integer> cutNumbers = new TreeSet<Integer>();
	private boolean nowCut = false;
	private int cutCount;
	
	public MainField(Context context) {
		super(context);
		setup();
	}

	public MainField(Context context, AttributeSet attrs) {
		super(context, attrs);
		setup();
	}

	public MainField(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		setup();
	}
	
	private void setup(){
		setLayoutParams(new FrameLayout.LayoutParams(
				FrameLayout.LayoutParams.FILL_PARENT,
				FrameLayout.LayoutParams.FILL_PARENT));
		for(int i=0;i<GameSetting.FIELD_HEIGHT;i++){
			HashSet<CellData> row = new HashSet<CellData>();
			rows.addFirst(row);
		}
	}
	
	public void setCurrentBlock(BlockOperator block){
		this.currentBlock = block;
	}
	
	public void setData(BlockData data){
		this.data = data;
	}
	
	public void setListeners(EventNotifier<CutCompleteListener> listeners){
		this.listeners = listeners;
	}
	
	public BlockOperator getCurrentBlock(){
		return currentBlock;
	}
	
	public void reset(){
		clear();
		currentBlock = null;
	}
	
	private void clear(){
		for(HashSet<CellData> row : rows){
			row.clear();
		}
	}
	
	public void stack(Iterable<Cell> cellList){
		Iterator<Cell> cells = cellList.iterator();
		while(cells.hasNext()){
			Cell cell = cells.next();
			Point point = cell.getPosition();
			CellData data = new CellData(point.getX(),cell.getBlockType());
			HashSet<CellData> row = rows.get(point.getY());
			row.add(data);
		}
	}
	
	public void renewCells(Iterable<Cell> cellList){
		clear();
		Iterator<Cell> cells = cellList.iterator();
		while(cells.hasNext()){
			Cell cell = cells.next();
			Point point = cell.getPosition();
			CellData data = new CellData(point.getX(),cell.getBlockType());
			HashSet<CellData> row = rows.get(point.getY());
			row.add(data);
		}
	}
	
	public void setCutRow(Iterable<Integer> numbers){
		Iterator<Integer> cutNums = numbers.iterator();
		while(cutNums.hasNext()){
			cutNumbers.add(cutNums.next());
		}
		cutCount = CUT_COUNT;
		nowCut = true;
		cut.setAlpha(255);
	}
	
	private void checkCut(){
		cutCount--;
		if(cutCount > 0){
			int phase = cutCount % 16;
			if(phase > 8){
				phase = 16 - phase;
			}
			int alpha = (int)Math.floor(PER_ALPHA * phase);
			cut.setAlpha(alpha);
		}else{
			removeRow();
			nowCut = false;
			cutNumbers.clear();
			Iterable<CutCompleteListener> list = listeners.getListeners();
			for(CutCompleteListener listener : list){
				listener.cutComplete();
			}
		}
	}
	
	private void removeRow(){
		Iterator<Integer> numbers = cutNumbers.iterator();
		while(numbers.hasNext()){
			int cutNum = numbers.next().intValue();
			HashSet<CellData> row = rows.remove(cutNum);
			row.clear();
			rows.addFirst(row);
		}
	}
	
	protected void onDraw(Canvas canvas){
		Paint normal = data.getNormalPaint();
		int y = 0;
		if(nowCut){
			Iterator<Integer> numbers = cutNumbers.iterator();
			while(numbers.hasNext()){
				int cutNum = numbers.next().intValue();
				for(;y<cutNum;y++){
					Iterator<CellData> cells = rows.get(y).iterator();
					while(cells.hasNext()){
						CellData cell = cells.next();
						Bitmap image = data.getImage(cell.getType());
						float pointX = cell.getX() * GameSetting.CELL_SIZE;
						float pointY = y * GameSetting.CELL_SIZE;
						canvas.drawBitmap(image, pointX, pointY, normal);
					}
				}
				Iterator<CellData> cells = rows.get(y).iterator();
				while(cells.hasNext()){
					CellData cell = cells.next();
					Bitmap image = data.getImage(cell.getType());
					float pointX = cell.getX() * GameSetting.CELL_SIZE;
					float pointY = y * GameSetting.CELL_SIZE;
					canvas.drawBitmap(image, pointX, pointY, cut);
				}
				y++;
			}
		}
		for(;y<GameSetting.FIELD_HEIGHT;y++){
			Iterator<CellData> cells = rows.get(y).iterator();
			while(cells.hasNext()){
				CellData cell = cells.next();
				Bitmap image = data.getImage(cell.getType());
				float pointX = cell.getX() * GameSetting.CELL_SIZE;
				float pointY = y * GameSetting.CELL_SIZE;
				canvas.drawBitmap(image, pointX, pointY, normal);
			}
		}
		if(nowCut){
			checkCut();
		}
		if(currentBlock == null){
			return;
		}
		Bitmap currentImage = data.getImage(currentBlock.getBlockType());
		Paint ghost = data.getGhostPaint();
		Point ghostPoint = currentBlock.getFutureCenterPosition();
		Point points[] = data.getCellPosition(currentBlock.getBlockType(),currentBlock.getDirection());
		if(ghostPoint != null){
			float ghostPointX = (float)ghostPoint.getX() * GameSetting.CELL_SIZE;
			float ghostPointY = (float)ghostPoint.getY() * GameSetting.CELL_SIZE;
			canvas.drawBitmap(currentImage, ghostPointX, ghostPointY, ghost);
			canvas.drawBitmap(currentImage, ghostPointX+points[0].getX(), ghostPointY+points[0].getY(), ghost);
			canvas.drawBitmap(currentImage, ghostPointX+points[1].getX(), ghostPointY+points[1].getY(), ghost);
			canvas.drawBitmap(currentImage, ghostPointX+points[2].getX(), ghostPointY+points[2].getY(), ghost);
		}
		RealPoint currentPoint = currentBlock.getCenterPosition();
		float currentPointX = (float)currentPoint.getX() * GameSetting.CELL_SIZE;
		float currentPointY = (float)currentPoint.getY() * GameSetting.CELL_SIZE;
		canvas.drawBitmap(currentImage, currentPointX, currentPointY, normal);
		canvas.drawBitmap(currentImage, currentPointX+points[0].getX(), currentPointY+points[0].getY(), normal);
		canvas.drawBitmap(currentImage, currentPointX+points[1].getX(), currentPointY+points[1].getY(), normal);
		canvas.drawBitmap(currentImage, currentPointX+points[2].getX(), currentPointY+points[2].getY(), normal);
		
		
	}

}
