package jp.ac.osaka_u.ist.sel.android.simn;

import java.util.Iterator;
import java.util.List;

import jp.ac.osaka_u.ist.sel.android.simn.impl.BlockCreationListener;
import jp.ac.osaka_u.ist.sel.android.simn.impl.BlockOperator;
import jp.ac.osaka_u.ist.sel.android.simn.impl.Cell;
import jp.ac.osaka_u.ist.sel.android.simn.impl.CutListener;
import jp.ac.osaka_u.ist.sel.android.simn.impl.FieldOperator;
import jp.ac.osaka_u.ist.sel.android.simn.impl.Game;
import jp.ac.osaka_u.ist.sel.android.simn.impl.GameListener;
import jp.ac.osaka_u.ist.sel.android.simn.impl.HoldEventListener;
import jp.ac.osaka_u.ist.sel.android.simn.impl.StackListener;

import android.app.Activity;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import jp.ac.osaka_u.ist.sel.android.simn.R;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;


public class SIMNActivity extends Activity implements SensorEventListener,
	GestureDetector.OnGestureListener,   
	GestureDetector.OnDoubleTapListener {// _u^bṽCxg擾

	private final int MAXMARKS = 7;
	private ImageView marks[] = new ImageView[7];
	private Game game;
	private FrameLayout mainFrame;
	private MainField mainField;
	private BlockField nextField1;
	private BlockField nextField2;
	private BlockField holdField;
	private TextView gameOverText;
	private Button startButton;
	private boolean gameEnd = true;
	private boolean pause = false;
	private TouchPad mTouchPad;
	private EventNotifier<CutCompleteListener> cutCompleteRegister = new EventNotifier<CutCompleteListener>();
	private EventNotifier<RotateEventListener> enR = new EventNotifier<RotateEventListener>();
	private EventNotifier<MoveLineEventListener> enM = new EventNotifier<MoveLineEventListener>();
	private EventNotifier<PitchListener> enP = new EventNotifier<PitchListener>();
	private EventNotifier<ShakeListener> enS = new EventNotifier<ShakeListener>();
	private EventNotifier<HoldEventListener> holdCollector = new EventNotifier<HoldEventListener>();
	private EventNotifier<FallEventListener> fallCollector = new EventNotifier<FallEventListener>();
	private boolean mRegisteredSensor;
	private SensorManager mSensorManager;
	private BlockDirection direction;
	private Iterable<Cell> cells;
	private BlockOperator runBlock;
	private Iterable<Integer> rows;
	private Activity simn = this;
	private MediaPlayer bgm;
	private Handler handler = new Handler();
	// DoublePadc
	private GestureDetector mGestureDetector;
	// UԔc
	private boolean shaking = false;
	// tB^l
	private static final float FILTERING_VALUE = 0.1f;
	// [pXtB^l
	private float lowX = 0.0f;
	//
	
	private Thread thread;
	
	private Runnable callback = new Runnable(){
		public void run(){
			BlockDirection currentDirection = game.getCurrentBlock().getDirection();
			if(direction != currentDirection){
				direction = currentDirection;
				MediaPlayer effect = MediaPlayer.create(simn, R.raw.zasi);
				effect.setLooping(false);
				effect.start();
			}
			mainField.invalidate();
		}
	};
	
	private GameListener gameListener = new GameListener(){
		public void losed() {
			gameEnd = true;
			game.stop();
			thread.interrupt();
			runOnUiThread(new Runnable(){
				public void run(){
					if(bgm.isPlaying()){
						bgm.stop();
					}
					mainFrame.addView(gameOverText);
					startButton.setText(R.string.start);
				}
			});
		}
	};
	
	private BlockCreationListener startBlockListener = new BlockCreationListener(){
		public void NotifyBlockCreation(BlockOperator block) {
			Log.v("check", "create");
			runBlock = block;
			runOnUiThread(new Runnable(){
				public void run(){
					direction = BlockDirection.Front;
					mainField.setCurrentBlock(runBlock);
					Iterator<BlockType> nexts = game.getNextBlocks().iterator();
					if(nexts.hasNext()){
						nextField1.setType(nexts.next());
						nextField1.invalidate();
					}
					if(nexts.hasNext()){
						nextField2.setType(nexts.next());
						nextField2.invalidate();
					}
				}
			});
			Log.v("check", "createend");
		}
	};
	
	private StackListener stackListener = new StackListener(){
		public void notifyStack(BlockOperator block) {
			Log.v("check", "stack");
			cells = block.getCells();
			runOnUiThread(new Runnable(){
				public void run(){
					Log.v("check", "stackUI");
					mainField.stack(cells);
					mainField.setCurrentBlock(null);
					MediaPlayer effect = MediaPlayer.create(simn,R.raw.dageki1);
			        effect.setLooping(false);
					effect.start();
					Log.v("check", "stackendUI");
				}
			});
			Log.v("check", "stackend");
		}
	};
	
	private CutListener cutLineListener = new CutListener(){
		public void cutLines(Iterable<Integer> iter) {
			Log.v("check", "cut");
			rows = iter;
			runOnUiThread(new Runnable(){
				public void run(){
					Log.v("check", "cutUI");
					mainField.setCutRow(rows);
					setMarks(game.getShakeCount());
					TextView scoreBox =(TextView)findViewById(R.id.score);
			    	scoreBox.setText(new Long(game.getScore()).toString());
					MediaPlayer effect = MediaPlayer.create(simn,R.raw.kin);
			        effect.setLooping(false);
					effect.start();
				}
			});
			Log.v("check", "cutend");
		}
	};
	
	private HoldEventListener holdListener = new HoldEventListener(){
		public void hold(){
			BlockOperator holdBlock = game.getHoldBlock();
			holdField.setDirction(holdBlock.getDirection());
			holdField.setType(holdBlock.getBlockType());
			holdField.invalidate();
		}
	};
	
	private ShakeListener sliderListener = new ShakeListener(){
		public void beginShake() {
		}

		public void endShake() {
			mainField.renewCells(game.getField().getCells());
			setMarks(game.getShakeCount());
		}

		public void shaking(Horizon direction) {
		}
	};
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        mRegisteredSensor = false;
        // gpłZT[̎ނ擾
        mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
        // XML̃CAEg^b`plp̃nho
        mTouchPad = new TouchPad(this);
        // ܂Ȃ
        mTouchPad.setClickable(true);
        
        // DoublePadc
        mGestureDetector = new GestureDetector(this);
        
        BlockData data = new BlockData(this);
        mainFrame = (FrameLayout)findViewById(R.id.main);
        mainField = new MainField(this);
        mainField.setData(data);
        mainFrame.addView(mainField);
        FrameLayout nextFrame1 = (FrameLayout)findViewById(R.id.next1);
        nextField1 = new BlockField(this);
        nextField1.setData(data);
        nextField1.setDirction(BlockDirection.Front);
        nextFrame1.addView(nextField1);
        FrameLayout nextFrame2 = (FrameLayout)findViewById(R.id.next2);
        nextField2 = new BlockField(this);
        nextField2.setData(data);
        nextField2.setDirction(BlockDirection.Front);
        nextFrame2.addView(nextField2);
        FrameLayout holdFrame = (FrameLayout)findViewById(R.id.hold);
        holdField = new BlockField(this);
        holdField.setData(data);
        holdFrame.addView(holdField);
        gameOverText = (TextView)findViewById(R.id.gameover);
        marks[0] = (ImageView)findViewById(R.id.mark1);
        marks[1] = (ImageView)findViewById(R.id.mark2);
        marks[2] = (ImageView)findViewById(R.id.mark3);
        marks[3] = (ImageView)findViewById(R.id.mark4);
        marks[4] = (ImageView)findViewById(R.id.mark5);
        marks[5] = (ImageView)findViewById(R.id.mark6);
        marks[6] = (ImageView)findViewById(R.id.mark7);
        mainFrame.removeView(gameOverText);
        startButton = (Button)findViewById(R.id.start);
        startButton.setOnClickListener(new OnClickListener(){
        	public void onClick(View view) {
        		if(gameEnd){
        			startButton.setText(R.string.stop);
        			startGame();
        		}else if(pause){
        			startButton.setText(R.string.stop);
        			restartGame();
        		}else{
        			startButton.setText(R.string.restart);
        			stopGame();
        		}
        	}
        });
    }
    
    @Override
    // ZT[̓o^
    public void onResume(){
        super.onResume();
        /*{
            List<Sensor> sensors = mSensorManager.getSensorList(Sensor.TYPE_ORIENTATION);
            
            if (sensors.size() > 0) { // @ɌXZT[݂邩
                // gpZT[̎ނ擾
                Sensor sensor = sensors.get(0);

                
                // registerListener(val1,val2,val3)
                // val1:ZT[CX^X
                // val2:MZT[^CṽXg
                // val3:ZT[Mpx
                mRegisteredSensor = mSensorManager.registerListener(this,
                    sensor,SensorManager.SENSOR_DELAY_GAME);
            }
        }*/
        // ̏s\bh
        registerSensor();
        
        if(bgm != null){
        	if(!gameEnd){
        		bgm.start();
        	}
        }
        
        if(pause){
        	pause = false;
        	makeThread();
        	thread.start();
        	game.restart();
        }
    	
    }
    
    @Override
    protected void onPause() {
        if (mRegisteredSensor) {
            mSensorManager.unregisterListener(this);
            mRegisteredSensor = false;
        }
        
        if(bgm != null){
        	if(bgm.isPlaying()){
        		bgm.pause();
        	}
        }
        
        if(!gameEnd){
        	pause = true;
        	game.stop();
        	thread.interrupt();
        }
        
        super.onPause();
    }
    
    @Override
    protected void onDestroy(){
    	if(!gameEnd){
    		game.stop();
    		thread.interrupt();
    	}
    	super.onDestroy();
    }
   
    // ^b`pl
    @Override
    public boolean onTouchEvent(MotionEvent event){
    	if(pause){
    		return super.onTouchEvent(event);
    	}
    	if(mGestureDetector.onTouchEvent(event)) return true;
    	super.onTouchEvent(event);
    	return (mTouchPad.onTouchEvent(event,holdCollector.list,enM.list,fallCollector.list));
    }
    
    // ZT[o^
    public void registerSensor(){
        List<Sensor> sensors = mSensorManager.getSensorList(Sensor.TYPE_ALL);
        
        for(Sensor s : sensors){
        	mSensorManager.registerListener(this,s,SensorManager.SENSOR_DELAY_GAME);
        }
        
        mRegisteredSensor = true;
    }
    
    private void setMarks(int count){
    	int i = 0;
    	while(i < count){
    		if(i >= MAXMARKS){
    			break;
    		}
    		marks[i].setVisibility(View.VISIBLE);
    		i++;
    	}
    	while(i < MAXMARKS){
    		marks[i].setVisibility(View.INVISIBLE);
    		i++;
    	}
    }
    
    private void resetListener(){
    	cutCompleteRegister = new EventNotifier<CutCompleteListener>();
    	enR = new EventNotifier<RotateEventListener>();
    	enM = new EventNotifier<MoveLineEventListener>();
    	enP = new EventNotifier<PitchListener>();
    	enS = new EventNotifier<ShakeListener>();
    	holdCollector = new EventNotifier<HoldEventListener>();
    	fallCollector = new EventNotifier<FallEventListener>();
    }
    
    private void makeThread(){
    	thread = new Thread(){
    		public void run(){
    			while(true){
    				try {
    					sleep(10);
    				} catch (InterruptedException e) {
    				}
    				handler.post(callback);
    			}
    		}
    	};
    }
    
    private void startGame(){
    	gameEnd = false;
    	mainFrame.removeView(gameOverText);
    	mainField.reset();
    	nextField1.reset();
    	nextField1.setSize();
    	nextField2.reset();
    	nextField2.setSize();
    	holdField.reset();
    	holdField.setSize();
    	TextView scoreBox =(TextView)findViewById(R.id.score);
    	scoreBox.setText("0");
    	setMarks(0);
    	
    	resetListener();
    	mainField.setListeners(cutCompleteRegister);
    	game = new Game();
    	FieldOperator field = game.getField();
    	game.addGameListener(gameListener);
    	game.addBlockCreationListener(startBlockListener);
    	field.addStackListener(stackListener);
    	field.addCutListener(cutLineListener);
    	holdCollector.addListener(holdListener);
    	enS.addListener(sliderListener);
    	
    	bgm = MediaPlayer.create(this,R.raw.offenbach_tengo_k);
        bgm.setLooping(true);
		bgm.start();
		makeThread();
		thread.start();
    	game.start(enM, enR, enP, cutCompleteRegister, holdCollector, enS, fallCollector);
    }
    
    private void restartGame(){
    	pause = false;
    	
    	/*{
            List<Sensor> sensors = mSensorManager.getSensorList(Sensor.TYPE_ORIENTATION);
            
            if (sensors.size() > 0) { // @ɌXZT[݂邩
                // gpZT[̎ނ擾
                Sensor sensor = sensors.get(0);

                // registerListener(val1,val2,val3)
                // val1:ZT[CX^X
                // val2:MZT[^CṽXg
                // val3:ZT[Mpx
                mRegisteredSensor = mSensorManager.registerListener(this,
                    sensor,SensorManager.SENSOR_DELAY_GAME);
            }
        }*/
    	// ̏s\bh
    	registerSensor();
    	
    	bgm.start();
    	makeThread();
    	thread.start();
    	game.restart();
    }
    
    private void stopGame(){
    	pause = true; 
    	if (mRegisteredSensor) {
            mSensorManager.unregisterListener(this);
            mRegisteredSensor = false;
        }
    	bgm.pause();
    	game.stop();
    	thread.interrupt();
    }
    
    // EventNotifier's
    public EventNotifier<RotateEventListener> getENR(){
    	return enR;
    }
    
    public EventNotifier<MoveLineEventListener> getENM(){
    	return enM;
    }
    
    public EventNotifier<PitchListener> getENP(){
    	return enP;
    }
    
    public EventNotifier<ShakeListener> getENS(){
    	return enS;
    }
    
    public void onAccuracyChanged(Sensor sensor,int accuracy){    	
    }
    
    // ZT[̏
    public void onSensorChanged(SensorEvent event){
    	// ݂̉x(x)
    	float accelX;
    	// nCpXtB^l
    	float highX;
    	// X(%)
        int pitch;
        
        // ZT[̎ނŏꍇ
        switch(event.sensor.getType()){
        case Sensor.TYPE_ACCELEROMETER:
        	// ݂̂̉x擾
        	accelX = event.values[0];
        	// [pXtB^lXV
        	lowX = accelX * FILTERING_VALUE + lowX * (1.0f - FILTERING_VALUE);
        	// nCpXtB^lvZ
        	highX = accelX -lowX;
        	
        	// ݂̏󋵂ɍ킹ď
        	// ̉xŐUǂ𔻒f
        	if(Math.abs(highX) > 7.0f){
        		// UJnłɐUĂ邩
        		if(!shaking){
        			// UԁFU
        			shaking = true;
        			
        			// UJn
        			for(ShakeListener i : enS.list){
        				i.beginShake();
        			}
        		}
        		
        		// U̕`
        		if(highX > 0.0f){
        			for(ShakeListener i : enS.list){
        				i.shaking(Horizon.Right);
        			}
        		}else{
        			for(ShakeListener i : enS.list){
        				i.shaking(Horizon.Left);
        			}
        		}
        	}else{
        		// UIŏUĂȂ
        		if(shaking){
        			for(ShakeListener i : enS.list){
        				i.endShake();
        			}
        			// UԁFU
        			shaking = false;
        		}
        	}        	
        	break;
        	
        case Sensor.TYPE_ORIENTATION:
        	/** X̒l擾
             * E@F-90
             * E@F0
             * E@Nƕ̒lAQƐ̒lƂȂ
             */

            // ̋t]C
            pitch = -1 * (int)event.values[1];

            if(pitch >= 90){
                // @NĂȂ90xɏC
                pitch = 90;
            }else if(pitch <= -90){
                // @t(?)QĂȂ-90xɏC
                pitch = -90;
            }
            
            // pxX(%)ɒ
            pitch = (int) (pitch / 0.9);
            
            Log.d("PITCH","pitch: " + pitch + "%");

            // X΂𓊂
    		for (PitchListener i : enP.list) {
    		  i.ChangePitch(pitch);
    		}	
        	break;
        default:
        }
    }
    /**
     * Cxg
     */
    @Override
    public void onLongPress(MotionEvent e) {
        Log.w("INFO", "onLongPress");
    }

    /**
     * _u^bvCxg
     */
    @Override
    public boolean onDoubleTap(MotionEvent e) {
    	int evX;
    	
    	evX = (int)e.getX();
        Log.w("INFO", "onDoubleTap");
        if(evX >= 160){
        	for (RotateEventListener i : enR.list) {
        		i.rotate(Horizon.Right);
        	}
        }else{
        	for (RotateEventListener i : enR.list) {
        		i.rotate(Horizon.Left);    
        	}
        }
        return true;
    }

    @Override
    public boolean onDoubleTapEvent(MotionEvent e) {
    	switch(e.getAction()){
    	case MotionEvent.ACTION_DOWN:
            Log.w("INFO", "onDoubleTapEvent DOWN");
            break;
    	case MotionEvent.ACTION_MOVE:
            Log.w("INFO", "onDoubleTapEvent MOVE");
            break;
    	case MotionEvent.ACTION_UP:
            Log.w("INFO", "onDoubleTapEvent UP");
            break;
        default:
    	}
        return true;
    }

    @Override
    public boolean onDown(MotionEvent arg0) {
        Log.w("INFO", "onDown");
        return false;
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        Log.w("INFO", "onFling");
        return false;
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        Log.w("INFO", "onScroll " + distanceX);
        return false;
    }

    @Override
    public void onShowPress(MotionEvent e) {
        Log.w("INFO", "onShowPress");
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        Log.w("INFO", "onSingleTapUp");
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e) {
        Log.w("INFO", "onSingleTapConfirmed");
        return false;
    }


}