package jp.ac.osaka_u.ist.sel.android.simn;

import java.util.List;

import jp.ac.osaka_u.ist.sel.android.simn.impl.HoldEventListener;

import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.content.Context;

public class TouchPad extends View{

	// WLϐ(x,y)
	int offsetX,offsetY;
	// O̍WLϐ(x,y)
	int preX,preY;
	// ʂ̉Lϐ
	int disWidth = getWidth();
	
	public TouchPad(Context c){
		super(c);
		setFocusable();
	}
	public TouchPad(Context c,AttributeSet a){
		super(c,a);
		setFocusable();
	}
	
	public void setFocusable(){
		// ܂Ȃ
		setFocusable(true);
	}
	
	public void setUnfocusable(){
		setFocusable(false);
	}
	
	public boolean onTouchEvent(MotionEvent event,
			List<HoldEventListener> listH,
			List<MoveLineEventListener> listM,
			List<FallEventListener> listF){
	    // ݂̍WLϐ(xy)
	    int curX,curY;
	    // _Ԃ̋Lϐ(xy)
	    int disX,disY;
		/**
		 * ^b`pbh̉ړ̐ΒlL
		 */
		int absX;
		
	    int action = event.getAction();

	    // ݂̍W擾
	    curX = (int)event.getX();
	    curY = (int)event.getY();

	    switch(action){
	    case MotionEvent.ACTION_DOWN:
	    	// W(݂̍W)擾AL
	    	offsetX = curX;
	    	offsetY = curY;
	    	preX = offsetX;
	    	preY = offsetY;
	    	Log.d("EVENT","x:" + offsetX + ", y:" + offsetY);
	    	break;
	    case MotionEvent.ACTION_MOVE:
	    	// O̍WƂ̍vZ
	    	disX = curX - preX;
	    	disY = curY - preY;
	    	absX = Math.abs(disX);
	    	
	    	absX = (int)Math.floor(absX/15);
	    	// absX = (int) Math.floor(Math.log(absX));
	    	
	    	// x̍Wωy̍WωȂΉړ
	    	if(Math.abs(disX) >= Math.abs(disY)){
	    		// x̕ωʂȂEړAȂ獶ړ
	    		if(disX >= 0){
	    			for (MoveLineEventListener i : listM) {
	    				  i.MoveLine(Horizon.Right,Math.abs(absX));
	    			}
	    			Log.w("EVENT","Right:" + Math.abs(absX));
	    		}else{
	    			for (MoveLineEventListener i : listM) {
	    				  i.MoveLine(Horizon.Left,Math.abs(absX));
	    			}
	    			Log.w("EVENT","Left:" + Math.abs(absX));
	    		}
	    	}

	    	break;
	    case MotionEvent.ACTION_UP:
	    	
	    	// WƂ̍vZ
	    	disX = curX - offsetX;
	    	disY = curY - offsetY;
	    	
	    	// yWωx̍Wω
	    	// yWω臒lȏȂHold or@
	    	if(Math.abs(disY) >= Math.abs(disX) &&
	    			Math.abs(disY) >= 30){
	    		// y̕ωʂȂ瑦AȂHold
	    		if(disY >= 0){	    			
	    			for (FallEventListener i : listF) {
	    				  i.fall();
	    			}
	    			Log.w("EVENT","Fall");	    			
	    		}else{
	    			for (HoldEventListener i : listH) {
	    				  i.hold();
	    			}
	    			Log.w("EVENT","hold");
	    		}
	    	}
	    	break;
	    }


	    // preX,preYXV
	    preX = curX;
	    preY = curY;

	    return true;
	}
}
