package jp.ac.osaka_u.ist.sel.android.simn.impl;

public class AutomaticProcessThread extends Thread
{
  private ThreadTaskManager manager_;
  private Iterable<IntervalEventListener> listeners_;
  
  public void start(ThreadTask task, PitchHolder receiver,
                    DelayedHolder totalDelay,
                    DelayedHolder remainingDelay,
                    Iterable<IntervalEventListener> listeners)
  {
    manager_ = new ThreadTaskManager(task, receiver, totalDelay);
    remainingDelay.setDelayedObject(manager_);
    listeners_ = listeners;
    super.start();
  }
  
  @Override
  public void run()
  {
    try {
      while (true) {
        manager_.PerformNextTask();
        Thread.sleep(10);
        for (IntervalEventListener l : listeners_)
          l.action();
      }
    } catch (InterruptedException e) {
      System.out.println("interrupt thread.");
      //Log.d("impl", "stop thread");
    }
    // TODO:
    /*
    catch (Exception e) {
    	Log.e("err", "AutomaticProcessThread", e);
    }
    */
  }

  public ThreadTask getNextTask()
  {
    return manager_.getTask();
  }

  public Delayed getDelayedObject()
  {
    return manager_;
  }
}
