package jp.ac.osaka_u.ist.sel.android.simn.impl;

import jp.ac.osaka_u.ist.sel.android.simn.BlockType;

public class Block extends CellBox
{
  /* constant */
  private final static int BLOCK_WIDTH = 5;
  private final static int BLOCK_HEIGHT = 5;

  /* static methods */
  static public Point toPositionWithinBlockFromRelativePosition(Point p)
  {
    return Point.add(p, BLOCK_WIDTH/2, BLOCK_HEIGHT/2);
  }

  static public Point changeCenterPosition(Point fromCenterPos, Point cellPos, Point toCenterPos)
  {
    return Point.add(toRelativePosition(fromCenterPos, cellPos), toCenterPos);
  }

  static public Point toRelativePosition(Point centerPos, Point p)
  {
    return Point.sub(p, centerPos);
  }
  
  /* constructor */
  public Block(BlockType t, Point centerPos)
  {
    super(BLOCK_HEIGHT, BLOCK_WIDTH);
    initializeBlock(t, centerPos);
    //block_ = CreateBlock(t, centerPos);
  }

  public Block()
  {
    super(BLOCK_HEIGHT, BLOCK_WIDTH);
    //block_ = new Cell[BLOCK_HEIGHT][BLOCK_WIDTH];
  }
  
  /* private methods */
  //private Cell[][] CreateBlock(BlockType t, Point centerPos)
  private void initializeBlock(BlockType t, Point centerPos)
  {
    //Cell[][] block = new Cell[BLOCK_HEIGHT][BLOCK_WIDTH];
    //block[block.length/2][block[0].length/2] = new Cell(centerPos);
    Cell base = new Cell(0,0,t);
    this.setCell(base.changePosition(centerPos), this.sizeLine()/2, this.sizeColumn()/2);
    
    switch (t) {
    case Z:
      /*
      block[2][1] = new Cell(Point.addX(centerPos, -1));
      block[3][2] = new Cell(Point.addY(centerPos, 1));
      block[3][3] = new Cell(Point.add(centerPos, 1, 1));
      */
      /*
      this.setCell(new Cell(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(new Cell(Point.addY(centerPos,  1)),   3, 2);
      this.setCell(new Cell(Point.add(centerPos, 1, 1)),  3, 3);
      */
      this.setCell(base.changePosition(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(base.changePosition(Point.addY(centerPos,  1)),   3, 2);
      this.setCell(base.changePosition(Point.add(centerPos, 1, 1)),  3, 3);
      break;
    case I:
      this.setCell(base.changePosition(Point.addX(centerPos, -2)),   2, 0);
      this.setCell(base.changePosition(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(base.changePosition(Point.addX(centerPos, 1)),    2, 3);
      break;
    case T:
      this.setCell(base.changePosition(Point.add(centerPos, -1, 1)), 3, 1);
      this.setCell(base.changePosition(Point.addY(centerPos, 1)),    3, 2);
      this.setCell(base.changePosition(Point.add(centerPos, 1, 1)),  3, 3);
      break;
    case S:
      this.setCell(base.changePosition(Point.addX(centerPos, 1)),    2, 3);
      this.setCell(base.changePosition(Point.add(centerPos, -1, 1)), 3, 1);
      this.setCell(base.changePosition(Point.addY(centerPos, 1)),    3, 2);
      break;
    case L:
      this.setCell(base.changePosition(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(base.changePosition(Point.addX(centerPos, 1)),    2, 3);
      this.setCell(base.changePosition(Point.add(centerPos, -1, 1)), 3, 1);
      break;
    case J:
      this.setCell(base.changePosition(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(base.changePosition(Point.addX(centerPos, 1)),    2, 3);
      this.setCell(base.changePosition(Point.add(centerPos, 1, 1)),  3, 3);
      break;
    case O:
      this.setCell(base.changePosition(Point.addX(centerPos, -1)),   2, 1);
      this.setCell(base.changePosition(Point.add(centerPos, -1, 1)), 3, 1);
      this.setCell(base.changePosition(Point.addY(centerPos, 1)),    3, 2);
      break;
    }
    //return block;
  }

  /* default methods */
  
  /* public methods */
  /*
  public void setCell(Cell c, Point p)
  {
    this.setCell(c, p.getY(), p.getX());
  }

  public void setCell(Cell c, int height_index, int width_index)
  {
    block_[height_index][width_index] = c;
  }

  public Cell getCell(int height_index, int width_index)
  {
    return block_[height_index][width_index];
  }

  public Cell getCenterCell()
  {
    return block_[block_.length/2][block_[0].length/2];
  }

  public Iterable<Cell> getCells()
  {
    ArrayList<Cell> l = new ArrayList<Cell>();
    for (int i = 0; i < BLOCK_HEIGHT; ++i)
      for (int j = 0; j < BLOCK_WIDTH; ++j) {
        Cell c = this.getCell(i, j);
        if ((c != null) && (c.withinField()))
          l.add(c);
      }
    return l;
  }

  public Iterable<Cell> getLineCells(int rowIndex)
  {
    assert (0 <= rowIndex && rowIndex < BLOCK_HEIGHT) : "invalid access to block row";
    return Arrays.asList(block_[rowIndex]);
  }

  public int sizeRow()
  {
    return BLOCK_HEIGHT;
  }

  public int getTopLineIndex()
  {
    for (int i = 0; i < BLOCK_HEIGHT; ++i) {
      try {
        for (Cell c : getLineCells(i))
          if (c != null)
            throw new Exception();
      } catch (Exception e) {
        return i;
      }
    }
    Log.e("err", "getTopLineIndex");
    return -1; // dummy value
  }

  public int getLastLineIndex()
  {
    for (int i = BLOCK_HEIGHT-1; i >= 0; --i) {
      try {
        for (Cell c : getLineCells(i))
          if (c != null)
            throw new Exception();
      } catch (Exception e) {
        return i;
      }
    }
    Log.e("err", "getLastLineIndex");
    return -1; // dummy value
  }
  */
}
