package jp.ac.osaka_u.ist.sel.android.simn.impl;

import java.util.LinkedList;

import jp.ac.osaka_u.ist.sel.android.simn.BlockType;


public class BlockGenerator
{
  private static final int BUCKET_SIZE = 5;
  private static final int ACCEPTABLE_SIZE = 3;

  private LinkedList<BlockType> past_blocks_;

  public BlockGenerator()
  {
    past_blocks_ = new LinkedList<BlockType>();
    for (int i = 0; i < BUCKET_SIZE; ++i)
      past_blocks_.add(BlockType.randomBlock());
  }
  
  public BlockType getNext()
  {
    int count;
    BlockType t;
    do {
      t = BlockType.randomBlock();
      count = 0;
      for (BlockType past : past_blocks_)
        if (past == t)
          ++count;
    } while (count > ACCEPTABLE_SIZE);
    past_blocks_.remove();
    past_blocks_.add(t);
    return t;
  }
}
