package jp.ac.osaka_u.ist.sel.android.simn.impl;

import jp.ac.osaka_u.ist.sel.android.simn.BlockType;
import jp.ac.osaka_u.ist.sel.android.simn.GameSetting;

public class Cell 
{
  private Point pos_;
  private BlockType BlockType_;
  
  Cell(Point p, BlockType blockType)
  {
    pos_ = new Point(p);
    BlockType_ = blockType;
  }
  
  Cell(int x, int y, BlockType blockType)
  {
    this(new Point(x, y), blockType);
  }
  
  public Point getPosition()
  {
    return pos_;
  }
  
  public Cell changePosition(int x, int y)
  {
    return this.changePosition(new Point(x, y));
  }
  
  public Cell changePosition(Point p)
  {
    return new Cell(p, this.getBlockType());
  }
  
  public boolean withinField()
  {
	  int x = pos_.getX();
	  int y = pos_.getY();	  
	  return ((0 <= y) && (y < GameSetting.FIELD_HEIGHT) && (0 <= x) && (x < GameSetting.FIELD_WIDTH));
  }

  public BlockType getBlockType()
  {
    return BlockType_;
  }
}
