package jp.ac.osaka_u.ist.sel.android.simn.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;

public class CellBox
{
  private Cell[][] block_;
  private TreeSet<Cell> cells_;

  /*
  CellBox(Cell[][] init)
  {
    block_ = init;
    cells_ = new TreeSet<Cell>();
  }
  */
  
  CellBox(int height, int width)
  {
    block_ = new Cell[height][width];
    cells_ = new TreeSet<Cell>(new Comparator<Cell>() {
        public int compare(Cell c1, Cell c2) {
          if (c1 == null) return -1;
          if (c2 == null) return 1;
          int h1 = c1.hashCode();
          int h2 = c2.hashCode();
          if (h1 == h2) return 0;
          if (h1 > h2) return 1;
          return -1;
        }
      });
  }

  /* default methods */
  void setCell(Cell c, Point p)
  {
    this.setCell(c, p.getY(), p.getX());
  }

  void setCell(Cell c, int height_index, int width_index)
  {
    if (c == null)
      throw new NullPointerException();
    cells_.remove(block_[height_index][width_index]);
    block_[height_index][width_index] = c;
    cells_.add(c);
  }

  void clearCell(Point p)
  {
    this.clearCell(p.getY(), p.getX());
  }

  void clearCell(int height_index, int width_index)
  {
    cells_.remove(block_[height_index][width_index]);
    block_[height_index][width_index] = null;
  }

  Cell getCell(int height_index, int width_index)
  {
    return block_[height_index][width_index];
  }

  Cell getCenterCell()
  {
    return block_[this.sizeLine()/2][this.sizeColumn()/2];
  }

  int sizeLine()
  {
    return block_.length;
  }

  int sizeColumn()
  {
    return block_[0].length;
  }
  
  Iterable<Cell> getCells()
  {
    return cells_;
    /*
    ArrayList<Cell> l = new ArrayList<Cell>();
    for (int i = 0; i < this.sizeLine(); ++i)
      for (int j = 0; j < this.sizeColumn(); ++j) {
        Cell c = this.getCell(i, j);
        if ((c != null) && (c.withinField()))
          l.add(c);
      }
    return l;
    */
  }

  Iterable<Cell> getLineCells(int rowIndex)
  {
    assert (0 <= rowIndex && rowIndex < this.sizeLine()) : "invalid access to block row";
    return Arrays.asList(block_[rowIndex]);
  }

  public int getTopLineIndex()
  {
    for (int i = 0; i < this.sizeLine(); ++i) {
      try {
        for (Cell c : this.getLineCells(i))
          if (c != null)
            throw new DummyThrowable();
      } catch (DummyThrowable e) {
        return i;
      }
    }
    //Log.e("err", "getTopLineIndex");
    return -1; 
  }

  public int getLastLineIndex()
  {
    for (int i = this.sizeLine()-1; i >= 0; --i) {
      try {
        for (Cell c : getLineCells(i))
          if (c != null)
            throw new DummyThrowable();
      } catch (DummyThrowable e) {
        return i;
      }
    }
    //Log.e("err", "getLastLineIndex");
    return -1; // dummy value
  }
}
