package jp.ac.osaka_u.ist.sel.android.simn.impl;

class CreateBlockAction implements ThreadAction {

  private Iterable<GameListener> gameListeners_;
  private BlockCreator creator_;

  public CreateBlockAction(Iterable<GameListener> gameListeners, BlockCreator creator)
  {
    gameListeners_ = gameListeners;
    creator_ = creator;
  }

  public CreateBlockAction(CreateBlockAction src)
  {
    gameListeners_ = src.gameListeners_;
    creator_ = src.creator_;
  }
  
	public ThreadTask action() {
		try {
      return creator_.createNewBlock();
    } catch (NotCreateBlock e) {
      for (GameListener listener : gameListeners_)
        listener.losed();
      return new ThreadTask(new DummyTask(), Long.MAX_VALUE);
    }
	}

}
