package jp.ac.osaka_u.ist.sel.android.simn.impl;

import java.util.List;
import java.util.Collections;
import java.util.TreeSet;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.android.simn.GameSetting;
import jp.ac.osaka_u.ist.sel.android.simn.Horizon;


public class FieldOperator implements StackListener, LineCuter
{
  /* private variables */
  Field field_;
  private ArrayList<CutListener> cutListeners_;
  private ArrayList<StackListener> stackListeners_;
  
  /* constructor */
  FieldOperator()
  {
    field_ = new Field();
    cutListeners_ = new ArrayList<CutListener>();
    stackListeners_ = new ArrayList<StackListener>();
  }

  /* private methods */
  private void rightShake(List<List<Cell>> blocks, Field field, BlockOperator block)
  {
    int fromIndex = field_.getTopLineIndex();
    int toIndex = fromIndex + 1;
    
    for (List<Cell> lineBlock : blocks) {
      Cell first = lineBlock.get(0);
      for (int i = first.getPosition().getX() + 1;
           i + lineBlock.size() <= field.sizeLine();
           ++i)
        try {
          for (int j = 0; j < lineBlock.size(); ++j)
            if (!this.isEmpty(toIndex, i+j) ||
                block.withinBlock(fromIndex, i+j) ||
                block.withinBlock(toIndex, i+j))
              throw new DummyThrowable();
          // find empty cells.
          for (int j = 0; j < lineBlock.size(); ++j) {
            Cell c = field.getCell(fromIndex, first.getPosition().getX()+j);
            //field.setCell(null, fromIndex, first.getPosition().getX()+j);
            field.clearCell(fromIndex, first.getPosition().getX()+j);
            //field.setCell(c, toIndex, i+j);
            //field.setCell(new Cell(i+j, toIndex), toIndex, i+j);
            field.setCell(c.changePosition(i+j, toIndex), toIndex, i+j);
          }
          break;
        }
        catch (DummyThrowable e) {
          //i += j + 1;
        }
    }
  }

  private void leftShake(List<List<Cell>> blocks, Field field, BlockOperator block)
  {
    int fromIndex = field_.getTopLineIndex();
    int toIndex = fromIndex + 1;

    for (List<Cell> lineBlock : blocks) {
      Cell first = lineBlock.get(0);
      for (int i = first.getPosition().getX() - 1;
           i - lineBlock.size() >= -1;
           --i)
        try {
          for (int j = 0; j < lineBlock.size(); ++j) {
            if (!this.isEmpty(toIndex, i-j) ||
                block.withinBlock(fromIndex, i-j) ||
                block.withinBlock(toIndex, i-j))
              throw new DummyThrowable();
          }
          // find empty cells
          for (int j = 0; j < lineBlock.size(); ++j) {
            Cell c = field.getCell(fromIndex, first.getPosition().getX()-j);
            //field.setCell(null, fromIndex, first.getPosition().getX()-j);
            field.clearCell(fromIndex, first.getPosition().getX()-j);
            //field.setCell(c, toIndex, i-j);
            //field.setCell(new Cell(i-j, toIndex), toIndex, i-j);
            field.setCell(c.changePosition(i-j, toIndex), toIndex, i-j);
          }
          break;
        } catch (DummyThrowable e) {}
    }
  }  
  
  /* default methods */
  int getTopLineIndex()
  {
    return field_.getTopLineIndex();
  }
  
  Iterable<Cell> getLineCells(int height_index)
  {
    return field_.getLineCells(height_index);
  }

  int sizeLine()
  {
    return field_.sizeLine();
  }

  int sizeColumn()
  {
    return field_.sizeColumn();
  }
  
  /* public methods */
  public Iterable<Cell> getCells()
  {
    return field_.getCells();
  }
  
  public boolean isEmpty(Point p)
  {
    return this.isEmpty(p.getY(), p.getX());
  }

  public boolean isEmpty(int y, int x)
  {
    if (!(0 <= x && x < GameSetting.FIELD_WIDTH))
      return false;
    if (!(0 <= y && y < GameSetting.FIELD_HEIGHT))
      return false;    
    if (field_.getCell(y, x) != null)
      return false;
    return true;
  }
  
  public void addCutListener(CutListener listener)
  {
    cutListeners_.add(listener);
  }
  
  public void addStackListener(StackListener listener)
  {
	  stackListeners_.add(listener);
  }
  
  public void notifyStack(BlockOperator block)
  {
    /* fix each cell in block. */
    for (Cell c : block.getCells()) {
      Point pos = c.getPosition();
      assert field_.getCell(pos.getY(), pos.getX()) == null : "stackBlock error.";
      field_.setCell(c, pos.getY(), pos.getX());
    }
    
    for (StackListener listener : stackListeners_) {
    	listener.notifyStack(block);
    }
  }

  public boolean processCutLines(BlockOperator block)
  { 
    TreeSet<Integer> lines = new TreeSet<Integer>();
    for (Cell c : block.getCells())
      lines.add(c.getPosition().getY());
    
    /* check cut line */
    ArrayList<Integer> l = new ArrayList<Integer>(lines.size());
    for (Integer i : lines)
      try {
        for (Cell c : field_.getLineCells(i))
          if (c == null)
            throw new DummyThrowable();        
        l.add(i);
      }
      catch (DummyThrowable ex) {}

    /* cut lines */
    for (Integer lineNumber : l) {
      int i = lineNumber.intValue();
      for (int j = 0; j < GameSetting.FIELD_WIDTH; ++j)
        //field_.setCell(null, i, j);
        field_.clearCell(i, j);
    }
    
    /* move remaining cells */
    for (int i = GameSetting.FIELD_HEIGHT -1; i >= 0; --i) {
      int downNum = 0;
      for (Integer index : l)
        if (i < index.intValue())
          ++downNum;
      if (downNum == 0) continue;
      for (int j = 0; j < GameSetting.FIELD_WIDTH; ++j) {
        Cell c = field_.getCell(i, j);
        if (c != null) {
          field_.setCell(c.changePosition(j, i+downNum), i+downNum, j);
          //field_.setCell(null, i, j);
          field_.clearCell(i, j);
        }
      }
    }
      
    /* notify listeners */
    if (l.size() != 0)
      for (CutListener client : cutListeners_)
        client.cutLines(l);
    
    return l.size() != 0;
  }

  private List<List<Cell>> getBlocksOnTop()
  {
    ArrayList<List<Cell>> l = new ArrayList<List<Cell>>();
    List<Cell> subList = new ArrayList<Cell>();
    for (Cell c : getLineCells(getTopLineIndex()))
      if (c != null)
        subList.add(c);
      else if (subList.size() != 0) {
        l.add(subList);
        subList = new ArrayList<Cell>();
      }
    return l;
  }

  public boolean canShake()
  {
    if (field_.getTopLineIndex() <= 0)
      return false;
    return true;
  }
  
  public void shake(BlockOperator block, Horizon direction)
  {
    assert canShake();

    List<List<Cell>> blocks = getBlocksOnTop();

    /*
    if (direction == Horizon.Left)
      Collections.reverse(blocks);
    */
    /*
    int fromIndex = field_.getTopLineIndex();
    int toIndex fromIndex - 1;
    */
    if (direction == Horizon.Right)
      rightShake(blocks, field_, block);
      /*
      for (List<Cell> lineBlock : blocks) {
        Cell first = lineBlock.get(0);
        for (int i = first.getPosition().getX() + 1;
             i + lineBlock.size() <= field_.lineSize();
             ++i)
          try {
            for (int j = 0; j < lineBlock.size(); ++j) {
              if (!field_.isEmpty(toIndex, i+j) ||
                  block.withinBlock(fromIndex, i+j) ||
                  block.withinBlock(toIndex, i+j))
                throw new Exception();
            }
            // discovery empty cells.
            for (int j = 0; j < lineBlock.size(); ++j) {
              Cell c = field_.getCell(fromIndex, first.getPosition().getX()+j);
              field_.setCell(null, fromIndexn, first.getPosition().getX()+j);
              field_.setCell(c, toIndexn, i+j);
            }
            break;
          }
          catch (Exception e) {
            i += j + 1;
          }
      }
      */
    else {
      Collections.reverse(blocks);
      for (List<Cell> lineBlock : blocks)
        Collections.reverse(lineBlock);
      leftShake(blocks, field_, block);
    }
  }
}
