package jp.ac.osaka_u.ist.sel.android.simn.impl;

import java.util.Comparator;
import java.util.TreeSet;

import jp.ac.osaka_u.ist.sel.android.simn.Vertical;

import android.util.Log;

class FuturePosition
{
  /* private variables */
  private Point upperPoint_;
  private Point lowerPoint_;

  /* constructor */
  public FuturePosition()
  {
    upperPoint_ = new Point();
    lowerPoint_ = new Point();
  }

  /* private methods */
  /*
  private int getPositionY(Iterable<Cell> iter)
  {
    for (Cell c : iter)
      if (c != null)
        return c.getPosition().getY();
    assert false;
    return -1; // dummy value
  }
  */
  private Point getUpperPosition(Block block, FieldOperator field)
  {
    final Point centerPos = block.getCenterCell().getPosition();
    final int centerY = centerPos.getY();
    final int centerX = centerPos.getX();
    final TreeSet<Point> centers = new TreeSet<Point>(new Comparator<Point>() {
        public int compare(Point p1, Point p2) {
          int y1 = p1.getY();
          int y2 = p2.getY();
          if (y1 == y2) return 0;
          else if (y1 < y2) return 1;
          else return -1;
        }});

    
    for (int i = centerY-1;  i >= -1; --i) {
      if (!field.isEmpty(new Point(centerX, i))) {
        centers.add(new Point(centerX, i+1));
      }
    }
    
    for (Cell c : block.getCells()) {
      Point topCenter = centers.first();
      Point futurePos = Block.changeCenterPosition(centerPos, c.getPosition(), topCenter);
      if (field.isEmpty(futurePos)) continue;
      for (int i = topCenter.getY()+1; i <= centerY; ++i) {
        futurePos = Block.changeCenterPosition(centerPos, c.getPosition(), new Point(centerX, i));
        if (field.isEmpty(futurePos)) {
          centers.add(new Point(centerX, i));
          break;
        }
      }
    }

    return centers.first();
    /*
    final Point centerPos = block.getCenterCell().getPosition();
    final int centerY = centerPos.getY();
    final int centerX = centerPos.getX();

    for (int i = centerY-1; i >= 0; --i)
      for (int j = block.getTopLineIndex(); j <= block.getLastLineIndex(); ++j)
        for (Cell c : block.getLineCells(j))
          if (c != null &&
              !field.isEmpty(Block.changeCenterPosition(centerPos, c.getPosition(), new Point(centerX, i)).getY(),
                             c.getPosition().getX()))
            return new Point(centerX, i+1);
    int relativeY = Block.toRelativePosition(centerPos,
                                             new Point(0, getPositionY(block.getLineCells(block.getTopLineIndex())))).getY();
    return new Point(centerX, -relativeY);
    */
    
    /*
    int topIndex = block.getTopLineIndex();
    int posY = getPositionY(block.getLineCells(topIndex));
    return getPosition(block, field, 0, posY, 1, posY);
    */
    //return getPosition(block, field, topIndex, 0, posY, 1, posY);
    
    /*
    int topIndex = block.getTopRowIndex();
    Point highCellPosY = getPositionY(block.getRowCells(topIndex));
    for (int i = 0; i <= highCellPosY; ++i)
      try {
        for (Cell c : block.getRowCells(topIndex))
          if (c != null && !field.isEmpty(i, c.getPosition().getX()))
            throw new Exception();
        Cell centerPos = block.getCenterCell().getPosition();
        return new Point(centerPos().getX(), i-(highCellPosY-centerPos.getY()));
    */
    
    /*
     int topIndex = block.getTopRowIndex();
     return getPosition(block, field, topIndex, 0, getPositionY(block.getRowCells(topIndex)), 1);
    */
    /*
   
   int topPosY = block.getRowCells(topIndex).next().getPosition().getY();
    for (int i = 0; i < topPosY; ++i) {
      try {
        for (Cell c : block.getRowCells(topIndex))
          if (!field.isEmpty(i, c.getPosition().getX()))
            throw new Exception();
        return new Point(block.getCenterCell().getPosition().getX(),
                         i);
      } catch (Exception e) {}
    }
    return null;  // dummy value
    */
    /*
    TreeSet<Integer> lines = new TreeSet<Integer>();
            Iterator<Cell> iter = block.getRowCells(block.getTopRowIndex());
    Cell first = iter.next();
    for (int i = 0; i <= first.getPosition().getY(); ++i) {
      if (!field.isEmpty(i, first.getPosition().getX()))
        lines.add(i);
    }

    for (; iter.hasNext();) {
      Cell c = iter.next();
      
    }
    
    for (Cell c : block.getRowCells(block.getTopRowIndex())) {
      for (int i = 0; i < block.getCenterCell().getPosition().getY()+1; ++i) {
        if (!field.isEmpty(c.getPosition()))
          break;
      }
    }
      
    for (int i = 0; i < field.sizeRow(); ++i) {
      for (Cell c : block.getRowCells(topIndex))
        if (field.isEmpty(c.getPosition()))
    }
    */
  }

  private Point getLowerPosition(Block block, FieldOperator field)
  {
    final Point centerPos = block.getCenterCell().getPosition();
    final int centerY = centerPos.getY();
    final int centerX = centerPos.getX();
    final TreeSet<Point> centers = new TreeSet<Point>(new Comparator<Point>() {
        public int compare(Point p1, Point p2) {
          int y1 = p1.getY();
          int y2 = p2.getY();
          if (y1 == y2) return 0;
          else if (y1 > y2) return 1;
          else return -1;
        }});

    for (int i = centerY+1;  i <= field.sizeLine(); ++i) {
      if (!field.isEmpty(new Point(centerX, i))) {
        centers.add(new Point(centerX, i-1));
      }
    }
    
    for (Cell c : block.getCells()) {
      Point topCenter = centers.first();
      /*
       Point futurePos = Block.changeCenterPosition(centerPos, c.getPosition(), topCenter);
      if (field.isEmpty(futurePos)) continue;
      for (int i = topCenter.getY()-1; i >= centerY; --i) {
        futurePos = Block.changeCenterPosition(centerPos, c.getPosition(), new Point(centerX, i));
        if (field.isEmpty(futurePos)) {
          centers.add(new Point(centerX, i));
          break;
        }
      }
      */
      for (int i = centerY+1; i <= topCenter.getY(); ++i) {
        Point futurePos = Block.changeCenterPosition(centerPos, c.getPosition(), new Point(centerX, i));
        if (!field.isEmpty(futurePos)) {
          centers.add(new Point(centerX, i-1));
          break;
        }
      }
    }

    return centers.first();
    
    /*
    final Point centerPos = block.getCenterCell().getPosition();
    final int centerY = centerPos.getY();
    final int centerX = centerPos.getX();

    
    for (int i = centerY+1; i < field.sizeLine(); ++i)
      for (int j = block.getTopLineIndex(); j <= block.getLastLineIndex(); ++j)
        for (Cell c : block.getLineCells(j))
          if (c != null &&
              !field.isEmpty(Block.changeCenterPosition(centerPos, c.getPosition(), new Point(centerX, i)).getY(),
                             c.getPosition().getX()))
            //return new Point(centerX, Block.changeCenterPosition(centerPos, centerPos, new Point(centerX, i-1)).getY());
            return new Point(centerX, i-1);

    int relativeY = Block.toRelativePosition(centerPos,
                                             new Point(0, getPositionY(block.getLineCells(block.getLastLineIndex())))).getY();
                                                             
    return new Point(centerX, field.sizeLine() - relativeY - 1);
    */
    /*
    int lastCellPosY = getPositionY(block.getLineCells(block.getLastLineIndex()));
    Point centerPos = block.getCenterCell().getPosition();
    
    for (int i = lastCellPosY+1; i < field.sizeLine(); ++i)
      for (int j = block.getTopLineIndex(); j <= block.getLastLineIndex(); ++j)
        for (Cell c : block.getLineCells(j))
          if (c != null && !field.isEmpty(i + c.getPosition().getY() - centerPos.getY(), c.getPosition().getX()))
            return new Point(centerPos.getX(), (i-1) - (lastCellPosY - centerPos.getY()));

    return new Point(centerPos.getX(), (field.sizeLine()-1) - (lastCellPosY - centerPos.getY()));
    */
    
    /*
    int lastIndex = block.getLastLineIndex();
    int posY = getPositionY(block.getLineCells(lastIndex));
    return getPosition(block, field, field.sizeLine()-1, posY, -1, posY);
    */
    //return getPosition(block, field, field.sizeLine()-1, posY, -1, posY);
    //return getPosition(block, field, lastIndex, field.sizeLine()-1, posY, -1, posY);
    
    /*
     int lastIndex = block.getLastRowIndex();
     return getPosition(block, field, lastIndex, field.rowSize()-1, getPositionY(block.getRowCells(lastIndex)), -1);
    */
    /*
    int lastIndex = block.getLastRowIndex();
    Point lowCellPosY = getPositionY(block.getRowCells(lastIndex));
    for (int i = field.rowSize() - 1; i >= lowCellPosY; --i)
      try {
        for (Cell c : block.getRowCells(lastIndex))
          if (c != null && !field.isEmpty(i, c.getPosition().getX()))
            throw new Exception();
        Cell centerPos = block.getCenterCell().getPosition();
        return new Point(centerPos.getX(), i-(lowCellPosY-centerPos.getY())); //
      } catch (Exception e) {}
    
    return null; // dummy value
    */
  }

  /*
  private Point getPosition(Block block, FieldOperator field, int first, int last, int diff, int posY)
  {
    for (int i = first; i >= last; i += diff) {
      try {
        for (int j = block.getTopLineIndex(); j <= block.getLastLineIndex(); ++j)
          for (Cell c : block.getLineCells(j))
            if (c != null && !field.isEmpty(i, c.getPosition().getX()))
              throw new Exception();
        Point centerPos = block.getCenterCell().getPosition();
        return new Point(centerPos.getX(), i-(posY-centerPos.getY()));
      } catch (Exception e) {}
    }
    return null; // dummy value
  }
  */
  /*
  private Point getPosition(Block block, FieldOperator field, int blokIndex, int first, int last, int diff, int posY)
  {
    for (int i = first; i >= last; i += diff) {
      try {
        for (Cell c : block.getLineCells(blokIndex))
          if (c != null && !field.isEmpty(i, c.getPosition().getX()))
            throw new Exception();
        Point centerPos = block.getCenterCell().getPosition();
        return new Point(centerPos.getX(), i-(posY-centerPos.getY()));
      } catch (Exception e) {}
    }
    return null; // dummy value
  }
  */
  
  /* public methods */
  public Point getCenterPosition(Vertical dir)
  {
    switch (dir) {
    case Up:   return upperPoint_;
    case Down: return lowerPoint_;
    default:
    	Log.e("err", "FuturePosition.getCenterPosition");
    	return new Point(); // dummy value    	
    }
  }

  public void updatePosition(Block block, FieldOperator field)
  {
    upperPoint_ = getUpperPosition(block, field);
    lowerPoint_ = getLowerPosition(block, field);
  }
}
