package jp.ac.osaka_u.ist.sel.android.simn.impl;

import android.util.Log;

class HoldBlock implements HoldEventListener
{
  private BlockOperator hold_;
  private BlockOperator current_block_;
  private BlockCreator creator_;

  /* constructor */
  public HoldBlock(BlockCreator creator)
  {
    hold_ = null;
    current_block_ = null;
    creator_ = creator;
  }

  /* default methods */
  void setCurrentBlock(BlockOperator block)
  {
    current_block_ = block;
  }
  
  /* public methods */
  public boolean isHeld()
  {
    return hold_ != null;
  }

  public BlockOperator getHoldBlock()
  {
    return hold_;
  }

  public void hold()
  {
    if (!this.isHeld())
      try {
        hold_ = current_block_;
        creator_.createNewBlock();
      } catch (NotCreateBlock e) { Log.e("err", "hold", e); }
    else {
      Point centerPos = current_block_.getCenterCellPosition();
      if (hold_.canChangeCenterPosition(centerPos)) {
        /* need to exchange variables such that rightTurnNum, etc. */
        hold_.setCenterPosition(centerPos);
        BlockOperator.exchange(current_block_, hold_);
        /*
        BlockOperator tmp = current_block_;
        current_block_ = hold_;
        hold_ = tmp;
        current_block_.update();
        */
        current_block_.update();
      }
    }
  }
}
