package jp.ac.osaka_u.ist.sel.android.simn.impl;

public class MoveAction implements ThreadAction
{
  private BlockOperator block_;
  private long interval_;
  private long waitTime_;
  private Iterable<StackListener> stackListeners_;
  private Iterable<BlockDownEventListener> downListeners_;
  private Iterable<GameListener> gameListeners_;
  private LineCuter lineCuter_;
  private BlockCreator creator_;
  private CutCompleteReceiver cutReceiver_;
  private PitchHolder pitch_;
  
  MoveAction(Iterable<StackListener> stackListeners, Iterable<GameListener> gameListeners,
             Iterable<BlockDownEventListener> downListeners, CutCompleteReceiver cutReceiver, LineCuter lineCuter,
             BlockOperator block, BlockCreator creator, long interval, long waitTime, PitchHolder pitch)
  {
    stackListeners_ = stackListeners;
    downListeners_ = downListeners;
    gameListeners_ = gameListeners;
    cutReceiver_ = cutReceiver;
    lineCuter_ = lineCuter;
    block_ = block;
    interval_ = interval;
    waitTime_ = waitTime;
    creator_ = creator;
    pitch_ = pitch;
  }

  public ThreadTask action()
  {
    if (block_.move(pitch_.getMoveDirection())) {
      long now = System.currentTimeMillis();
      for (BlockDownEventListener listener : downListeners_)
    	  listener.Downed(block_);
      return new ThreadTask(this, interval_ - (System.currentTimeMillis() - now));
    }
    else
      return new ThreadTask(new StackAction(this, stackListeners_, gameListeners_, cutReceiver_,
                                            lineCuter_, block_, creator_, interval_, pitch_),
                            waitTime_);
  }
  
  public void setInterval(long interval)
  {
    interval_ = interval;
  }
}
