package jp.ac.osaka_u.ist.sel.android.simn.impl;

import jp.ac.osaka_u.ist.sel.android.simn.PitchListener;
import jp.ac.osaka_u.ist.sel.android.simn.Vertical;

public class PitchHolder implements PitchListener
{
  /* const */
  static final int BLOCK_MAX_LENGTH = 4;
  static final double BASE_RATE = 0.1;
  static final double INIT_MAX_RATE = 5.0;
  static final double INIT_MIN_RATE = 1.0;
  static final double MAX_PITCH = 100.0;
  
  /* private variables */
  private int rate_ = 0;
  private double max_rate_ = INIT_MAX_RATE;
  private double min_rate_ = INIT_MIN_RATE;

  /* public methods */
  public void ChangePitch(int rate) {
	  rate_ = rate;
  }

  public double getRate()
  {
    if (rate_ == 0)
      return 0.0;
    else if (rate_ < 0) {
      return - min_rate_ + max_rate_ * (rate_/MAX_PITCH);
    }
    else
      return min_rate_ + max_rate_ * (rate_/MAX_PITCH);
  }

  public void updateRate(int lineNum)
  {
    double rate = (lineNum == BLOCK_MAX_LENGTH) ?
      lineNum * 2 * BASE_RATE : lineNum * BASE_RATE;
      
    max_rate_ += rate;
    min_rate_ += rate;
  }
  
  public Vertical getMoveDirection()
  {
    if (rate_ > 0)
      return Vertical.Down;
    else
      return Vertical.Up;
  }
}
