package jp.ac.osaka_u.ist.sel.android.simn.impl;

import java.util.concurrent.Callable;

import jp.ac.osaka_u.ist.sel.android.simn.Horizon;
import jp.ac.osaka_u.ist.sel.android.simn.ShakeListener;

import android.util.Log;

public class ShakeReceiver implements ShakeListener
{
  /* private variables */
  private FieldOperator field_;
  private BlockOperator current_block_;
  private Runnable stoper_;
  private Runnable restarter_;
  private Callable<Boolean> canShake_;
  private Runnable shaked_;
  private int shakeNum_;
  
  /* constructor */
  ShakeReceiver(FieldOperator field, Runnable stoper, Runnable restarter, Callable<Boolean> canShake, Runnable shaked)
  {
    field_ = field;
    stoper_ = stoper;
    restarter_ = restarter;
    canShake_ = canShake;
    shaked_ = shaked;
  }
  
  /* public methods */
  public void setBlock(BlockOperator block)
  {
    current_block_ = block;
  }

  /* methods for ShakeListener */
  public void beginShake() {
    stoper_.run();
    shakeNum_ = 0;
  }

  public void endShake() {
    if (shakeNum_ != 0)
      shaked_.run();
    current_block_.update();
    restarter_.run();
  }

  public void shaking(Horizon direction) {
    try {
      if (canShake_.call()) {
        field_.shake(current_block_, direction);
        if (++shakeNum_ % 2 == 0) {
          shaked_.run();
          shakeNum_ = 0;
        }
      }
    } catch (Exception e) {
      Log.d("err", "shaking", e);
    }
  }
}
