package jp.ac.osaka_u.ist.sel.android.simn.impl;

public class StackAction extends CreateBlockAction
{
  private Iterable<StackListener> stackListeners_;
  private BlockOperator block_;
  private LineCuter lineCuter_;
  private ThreadAction action_;
  private long interval_;
  private CutCompleteReceiver cutReceiver_;
  private PitchHolder pitch_;
  
  StackAction(ThreadAction action, Iterable<StackListener> stackListeners, Iterable<GameListener> gameListeners,
              CutCompleteReceiver cutReceiver, LineCuter lineCuter, BlockOperator block, BlockCreator creator, long interval,
              PitchHolder pitch)
  {
    super(gameListeners, creator);
    stackListeners_ = stackListeners;
    cutReceiver_ = cutReceiver;
    lineCuter_ = lineCuter;
    block_ = block;
    action_ = action;
    interval_ = interval;
    pitch_ = pitch;
  }
  
  public ThreadTask action()
  {
    if (block_.move(pitch_.getMoveDirection()))
      return new ThreadTask(action_, interval_);
    else {
      for (StackListener listener : stackListeners_)
        listener.notifyStack(block_);
      boolean cuted = lineCuter_.processCutLines(block_);
      if (cuted)
        return new ThreadTask(new WaitCutAction(cutReceiver_, this), 1);
      else
        return super.action();      
    }
  }
}
