package jp.ac.osaka_u.ist.sel.android.simn.impl;

public class ThreadTaskManager implements Delayed
{
  private ThreadTask task_;
  private long startTime_;
  private long remainingDelay_;
  private DelayedHolder totalDelay_;
  private PitchHolder pitch_;
  
  public ThreadTaskManager(ThreadTask task, PitchHolder pitch, DelayedHolder totalDelay)
  {
    task_ = task;
    startTime_ = System.currentTimeMillis();
    pitch_ = pitch;
    totalDelay_ = totalDelay;
    totalDelay_.setDelayedObject(task_);
    remainingDelay_ = task_.getDelay();
  }

  private void updateRemainigDelay()
  {
    remainingDelay_ -= (System.currentTimeMillis() - startTime_) * pitch_.getRate();
    startTime_ = System.currentTimeMillis();
  }
  
  public ThreadTask getTask()
  {
    synchronized (this) {
      return new ThreadTask(task_.getAction(), remainingDelay_);
    }
  }
  
  public boolean PerformNextTask()
  { 
    updateRemainigDelay();
    synchronized (this) {
      if (remainingDelay_ < 0 || task_.getDelay() < remainingDelay_) {
        startTime_ = System.currentTimeMillis();
        task_ = task_.getAction().action();
        if (remainingDelay_ < 0)
          remainingDelay_ = task_.getDelay();
        else
          remainingDelay_ = 0;
        totalDelay_.setDelayedObject(task_);
        return true;
      }
      /*
      if (remainingDelay_ < 0) {
        startTime_ = System.currentTimeMillis();
        task_ = task_.getAction().action();
        remainingDelay_ = task_.getDelay();
        totalDelay_.setDelayedObject(task_);
        return true;
      }
      */
      else
        return false;
    }
  }

  public long getDelay()
  {
    return remainingDelay_;
  }
}
