package jp.DrawPath;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import java.lang.Math;

;
public class DrawPathView extends View {
	private int startPointX;
	private int startPointY;
	private int newPointY;
	private int newPointX;
	private int power;
	private int slideX;
	private int slideY;
	private int distance = 0;
	private int deadDot = 0;
	private int backLine=0;
	private int frontLine=0;
	private int ENEMYSTOP=2000;
	private long starttime;
	private long endtime;
	boolean deadLine = false;
	boolean stopflag=false;
	CarState state = CarState.IDOL;

	public DrawPathView(Context context) {
		// TODO ꂽRXgN^[EX^u
		super(context);
		//setFocusable(true);
	}

	public void setstartPoint(float x, float y) {
		startPointX = (int) x;
		startPointY = (int) y;
	}

	public void setNewPoint(float x, float y) {
		newPointX = (int) x;
		newPointY = (int) y;
		slideX = Math.abs(startPointX - newPointX);
		slideY = Math.abs(startPointY - newPointY);
		power = (int) Math.sqrt(Math.pow(slideX, 2) + Math.pow(slideY, 2));
		state = CarState.RUN;
	}

	protected void onDraw(Canvas canvas) {
		int moveLine=0;
		canvas.drawColor(Color.DKGRAY);

		Paint rectPaint = new Paint();
		rectPaint.setStyle(Paint.Style.FILL);
		rectPaint.setColor(Color.WHITE);
		/* `` */
		Paint stonePaint = new Paint();
		stonePaint.setStyle(Paint.Style.FILL);
		stonePaint.setColor(Color.YELLOW);
		
		
		Paint seaPaint = new Paint();
		seaPaint.setStyle(Paint.Style.FILL);
		seaPaint.setAlpha(128);
		seaPaint.setColor(Color.BLUE);

		// distance= distance+power;
		if (power >= 300)
			moveLine += 20;
		else if (power >= 200)
			moveLine += 18;
		else if (power >= 175)
			moveLine += 17;
		else if (power >= 150)
			moveLine += 15;
		else if (power >= 125)
			moveLine += 13;		
		else if (power > 100)
			moveLine += 12;
		else if (power > 60){
			moveLine += 5;
			if(stopflag==false)
				frontLine+=5;
		}
		else if (power >= 30){
			moveLine += 3;
		if(stopflag==false)
			frontLine+=7;
		}
		else if (power >= 10){
			moveLine += 1;
		if(stopflag==false)
			frontLine+=9;
		}
		distance+=moveLine;
		if (distance>=ENEMYSTOP)
			stopflag =true;
		power -= 1;
		for (int r = -100; r < 15; r++) {
			canvas.drawRect(80, distance + r * 40, 100, distance + 20 + r * 40,
					rectPaint);
			canvas.drawRect(220, distance + r * 40, 240,
					distance + 20 + r * 40, rectPaint);
		}
		for (int t = -30; t < 7; t++) {
			canvas.drawCircle(20, distance + 20 + t * 100, 10, stonePaint);
			canvas.drawCircle(290, distance + 20 + t * 100, 10, stonePaint);
		}

		canvas.drawRect(0, distance - 5000, 319, distance - 2300, seaPaint);
		canvas.drawRect(120 + (deadDot / 8), 300 + (deadDot / 4),
				140 - (deadDot / 8), 340 - (deadDot / 16), rectPaint);
		//G@
		if (stopflag){
			
			backLine+=moveLine;
		}
		canvas.drawRect(180 , 300+backLine-frontLine ,
				200, 340+backLine-frontLine, rectPaint);
		// moji
		Paint mPaint = new Paint();
		mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
		mPaint.setARGB(255, 255, 255, 100);
		canvas.drawText(Double.toString(2640-distance), 20, 60, mPaint);
		//int tes =  (int) ((int) endtime - starttime);
		//canvas.drawText(Integer.toString(tes), 120, 60, mPaint);
		if(state ==CarState.IDOL){
			canvas.drawText("YOU", 120, 360, mPaint);
			canvas.drawText("ENEMY", 172, 360, mPaint);
			canvas.drawText("EC߂ăXChI",100 , 160, mPaint);
		}
		if (distance >= 2640)
			state = CarState.DYING;

		if (this.deadDot == 80)
			state = CarState.DEATH;

		if ((state == CarState.RUN) && power <= 0)
			state = CarState.STOP;
		switch (state) {
		case RUN:canvas.drawText("START", 20, 100, mPaint);
			this.invalidate();
			break;
		case DYING:canvas.drawText("START", 20, 100, mPaint);
			this.deadLine = true;
			this.deadDot++;
			this.invalidate();
			break;
		case DEATH:canvas.drawText("LOSE", 20, 100, mPaint);
			this.Death(canvas, mPaint);
			break;
		case IDOL:canvas.drawText("READY", 20, 100, mPaint);
			break;
		case STOP: 
			if((distance>=ENEMYSTOP) &&((backLine-frontLine)>0))this.win(canvas,mPaint);
			else if ((distance>=2300) &&((backLine-frontLine)<0))this.mutya(canvas,mPaint);
			else this.chicken(canvas, mPaint);
			break;
		case WAIT:
			break;
		}

	}

	private void Death(Canvas canvas, Paint mPaint) {
		canvas.drawText("悤Ȃ", 130, 60, mPaint);
		restart();

	}
	
	private void mutya(Canvas canvas,Paint mPaint){
		canvas.drawText("₪...", 130, 60, mPaint);
		canvas.drawText("Oׂ!!", 130, 260, mPaint);
		
		restart();
	}
	
	private void chicken(Canvas canvas, Paint mPaint) {
		canvas.drawText("LOSE", 20, 100, mPaint);
		canvas.drawText("a҂߁I", 130, 60, mPaint);
		restart();
	}
	private void win(Canvas canvas,Paint mPaint){
		canvas.drawText("N͗E҂", 130, 60, mPaint);
		canvas.drawText("WIN!", 20, 100, mPaint);
		if (ENEMYSTOP<2500)
		ENEMYSTOP+=100;
		restart();
		
	}
	private void restart() {
		state = CarState.WAIT;
		// this.init();
	}

	private void init() {
		this.power = 0;
		this.setstartPoint(0, 0);
		newPointX = 0;
		newPointY = 0;
		slideX = 0;
		slideY = 0;
		deadDot = 0;
		deadLine = false;
		distance = 0;
		backLine=0;
		stopflag=false;
		frontLine =0;
		this.invalidate();
		state = CarState.IDOL;
		//System.out.print(state);

	}

	public boolean onTouchEvent(MotionEvent event) {
		System.out.println(state);
		if (state == CarState.IDOL) {
			if (event.getAction() == MotionEvent.ACTION_DOWN) {
				this.setstartPoint(event.getX(), event.getY());
				starttime=event.getEventTime();
				// drawPathView.invalidate();
				return true;
			} else if (event.getAction() == MotionEvent.ACTION_UP) {
				
				endtime =event.getEventTime();
				if ((endtime-starttime)<300){
					this.setNewPoint(event.getX(), event.getY());
					this.invalidate();
				}
				return true;
			}
		}
		if (state == CarState.WAIT) {
			if (event.getAction() == MotionEvent.ACTION_DOWN) {
				this.init();
				
			}
		}
		return super.onTouchEvent(event);
	}

}
