package com.tank;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

public class TankBattle extends Activity {
	protected final static int BATTLE_MODE_CPU = 1;
	protected final static int BATTLE_MODE_VS = 2;
	
	TankView view;
	Button vsCpuButton;
	Button vsHumanButton;
	TextView titleText;
	TextView introductionText;
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d("TankBattle", "onCreate");
		super.onCreate(savedInstanceState);
		
		LinearLayout layout = new LinearLayout(this);
		layout.setOrientation(LinearLayout.VERTICAL);
		setContentView(layout);
		
		this.titleText = new TextView(this);
		this.titleText.setTextSize(20);
		this.titleText.setText("ȒPȐ");
		layout.addView(this.titleText);
		
		this.introductionText = new TextView(this);
		String text = "11Őԓmΐ킷Q[łB\n"
			+ "^[Œe̔˂݂ɍs܂B\n"
			+ "̃^[ɂȂwXChe𔭎ˁIII\n"
			+ "̂ƂAXCȟAɉĒe̋Oω܂B\n"
			+ "eԂɓƃ_[W^邱Ƃł܂B\n܂Aeꏊ̎ӂ̒nʂ܂B\n"
			+ "HP0ɂẢ̒nʂȂΏłI\n";
		this.introductionText.setText(text);
		layout.addView(this.introductionText);
		
		LinearLayout innerLayout = new LinearLayout(this); 
		this.vsCpuButton = new Button(this);
		this.vsCpuButton.setText("1Player");
		this.vsCpuButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(TankBattle.this, TankBattleMain.class);
				intent.putExtra("MODE", BATTLE_MODE_CPU);
				startActivity(intent);
			}
		});
		innerLayout.addView(this.vsCpuButton);
		
		this.vsHumanButton = new Button(this);
		this.vsHumanButton.setText("2Players");
		this.vsHumanButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(TankBattle.this, TankBattleMain.class);
				intent.putExtra("MODE", BATTLE_MODE_VS);
				startActivity(intent);
			}
		});
		innerLayout.addView(this.vsHumanButton);
		layout.addView(innerLayout);
	}
}