package com.tank;

import java.util.Random;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;

public class TankView extends TileView implements Runnable {
	private Tank tank1;
	private Tank tank2;
	
	private TankBattleMain main_activity;
	
	private int battle_mode;
	
	private int x_start = -1;
	private int y_start = -1;
	private long time_start = -1;
	public boolean fire_flag = false;
	private boolean wait_flag = false;
	
	private double v_x = -1;
	private double v_y = -1;
	private int bullet_base_x = -1;
	private int bullet_base_y = -1;
	
	private static int FIRE_INTERVAL = 100;
	private static double MIN_SLIDE = 20;
	
	private static double G = 0.02;
	
	private double wind_power;
	
	/**
	 * player1 or player2
	 */
	private int turn = 1;
	
	public TankView(Context context, AttributeSet attrs, int mode) {
		super(context, attrs);
		
		this.main_activity = (TankBattleMain) context;
		
		this.battle_mode = mode;
		
		this.tank1 = new Tank(Color.YELLOW, -1, 1);
		this.tank2 = new Tank(Color.GREEN, -1, 2);
		this.setTank1Only(this.tank1);
		this.setTank2Only(this.tank2);
		this.setTurn(1);
		
		Random rnd = new Random();
		this.wind_power = (double)(10-rnd.nextInt(20)); //-10 - 10
		this.setWindow((int)this.wind_power);
	}
	
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent e) {
		return super.onKeyDown(keyCode, e);
	}
	
	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		super.onSizeChanged(w, h, oldw, oldh);
		
		if(this.tank1.getLeftBottomX() < 0) {
			this.tank1.setLeftBottomX(20);
			this.tank1.setLeftTopX(20);
			this.tank1.setRightBottomX(20+Tank.TANK_WIDTH);
			this.tank1.setRightTopX(20+Tank.TANK_WIDTH);
		}
		if(this.tank1.getLeftTopY() < 0) {
			this.tank1.setLeftBottomY(TileView.Y_TILE_COUNT-TileView.FIELD_HEIGHT);
			this.tank1.setRightBottomY(this.tank1.getLeftBottomY());
			this.tank1.setLeftTopY(this.tank1.getLeftBottomY()-Tank.TANK_HEIGHT);
			this.tank1.setRightTopY(this.tank1.getLeftTopY());
		}
		if(this.tank2.getLeftBottomX() < 0) {
			this.tank2.setLeftBottomX(X_TILE_COUNT-Tank.TANK_WIDTH-20);
			this.tank2.setLeftTopX(this.tank2.getLeftBottomX());
			this.tank2.setRightBottomX(this.tank2.getLeftBottomX()+Tank.TANK_WIDTH);
			this.tank2.setRightTopX(this.tank2.getRightBottomX());
		}
		if(this.tank2.getLeftTopY() < 0) {
			this.tank2.setLeftBottomY(TileView.Y_TILE_COUNT-TileView.FIELD_HEIGHT);
			this.tank2.setRightBottomY(this.tank2.getLeftBottomY());
			this.tank2.setLeftTopY(this.tank2.getLeftBottomY()-Tank.TANK_HEIGHT);
			this.tank2.setRightTopY(this.tank2.getLeftTopY());
		}
		
		this.setTank(this.tank1);
		this.setTank(this.tank2);
	}
	
	/**
	 * ẽZbg
	 * bullet_threads
	 */
	public void drawBullet() {
		int bullet_x = this.bullet_base_x;
		int bullet_y = this.bullet_base_y;
		long old_bullet_time = 0;
		
		int old_bullet_x;
		int old_bullet_y;
		do {
			long bullet_time;
			while((bullet_time=this.getTime())==old_bullet_time);
			old_bullet_time = bullet_time;
			
			old_bullet_x = bullet_x;
			old_bullet_y = bullet_y;
			
			this.clearBullet(bullet_x, bullet_y);
			
			bullet_x = (int)((this.v_x+this.wind_power/4000.0*bullet_time)*bullet_time) + this.bullet_base_x;
			bullet_y = (int)(G*bullet_time*bullet_time/2.0+this.v_y*bullet_time) + this.bullet_base_y;
			
			//ZԂȂ̂ŒɋߎďՓ˔
			boolean hitFlag = false;
			if(old_bullet_x == bullet_x) {
				if(old_bullet_y < bullet_y) {
					//ォ牺
					for(int y = old_bullet_y; y < bullet_y; y++) {
						int data = this.getTile(bullet_x, y);
						if(data != BACKGROUND_COLOR && data != Color.BLACK) {
							this.afterHitBullet(bullet_x, y);
							hitFlag = true;
							break;
						}
					}
				} else {
					//
					for(int y = old_bullet_y-1; y >= bullet_y; y--) {
						int data = this.getTile(bullet_x, y);
						if(data != BACKGROUND_COLOR && data != Color.BLACK) {
							this.afterHitBullet(bullet_x, y);
							hitFlag = true;
							break;
						}
					}
				}
			} else {
				float m = (bullet_y-old_bullet_y)/(bullet_x-old_bullet_x);
				int y0 = (int) (bullet_y - m*bullet_x);
				//isŃ`FbNׂ
				if(old_bullet_x < bullet_x) {
					//E
					for(int x = old_bullet_x; x < bullet_x; x++) {
						int y = (int) (m*x + y0);
						int data = this.getTile(x, y);
						if(data != BACKGROUND_COLOR && data != Color.BLACK) {
							this.afterHitBullet(x, y);
							hitFlag = true;
							break;
						}
					}
				} else {
					//E獶
					for(int x = old_bullet_x-1; x >= bullet_x; x--) {
						int y = (int) (m*x + y0);
						int data = this.getTile(x, y);
						if(data != BACKGROUND_COLOR && data != Color.BLACK) {
							this.afterHitBullet(x, y);
							hitFlag = true;
							break;
						}
					}
				}
			}
			
			if(hitFlag || bullet_y > TileView.Y_TILE_COUNT
				|| bullet_x < 0 || bullet_x > TileView.X_TILE_COUNT) {
				this.setBullet(-1, -1);
				break;
			}
		} while(this.setBullet(bullet_x, bullet_y));
		
		System.out.println("bullet_x: "+bullet_x+", bullet_y: "+bullet_y);

		//_[WKp
		this.tank1 = this.getTank1();
		this.tank2 = this.getTank2();
		
		System.out.println("move1");
		this.tank1 = this.moveTank(this.tank1);
		System.out.println("move2");
		this.tank2 = this.moveTank(this.tank2);
		
		//s`FbN
		boolean alive1 = this.tank1.isAlive();
		boolean alive2 = this.tank2.isAlive();
		if(!alive1 && !alive2) {
			//draw
			this.setResult(DRAW);
			this.wait_flag = true;
		} else {
			if(!alive1) {
				//player2 win
				this.setResult(PLAYER2_WIN);
				this.wait_flag = true;
			} else if(!alive2) {
				//player1 win
				this.setResult(PLAYER1_WIN);
				this.wait_flag = true;
			}
		}
		
		this.turnEnd();
	}
	
	private void turnEnd() {
		//^[肩
		this.turn = (this.turn==1)? 2: 1;
		this.fire_flag =false;
		
		this.setTurn(this.turn);
		
		System.out.println("turn end");

		this.nextTurn();
	}
	
	private void nextTurn() {
		if(this.getResult() == 0 && this.turn == 2 && this.battle_mode == TankBattle.BATTLE_MODE_CPU) {
			this.cpuTurn();
		}
	}
	
	/**
	 * CPȔ
	 */
	private void cpuTurn() {
		//CPU = 2P
		
		//TODO ̉el
		Random rnd = new Random();
		double temp = (double)rnd.nextInt(100)/100.0; //-10 - 10
		
		this.fireCpu(-1.05-temp, -1.3);
		
	}
	
	/**
	 * e
	 */
	private void fireHuman(double x2, double y2, double interval) {
		//ˏ
		this.v_x = x2 / interval;
		this.v_y = y2 / interval;
		
		this._fire();
	}
	
	private void fireCpu(double vx, double vy) {
		this.v_x = vx;
		this.v_y = vy;
		this._fire();
	}
	
	private void _fire() {
		this.fire_flag = true;
		Tank tank = (this.turn==1)? this.tank1: this.tank2;
		//TODO XꍇɏC
		this.bullet_base_x = tank.getLeftBottomX() + Tank.TANK_WIDTH/2;
		this.bullet_base_y = tank.getLeftTopY()-1;
		
		this.setTime(0);
		
		//Xbhŏ
		Runnable bullet_task = new Runnable() {
			@Override
			public void run() {
				System.out.println("start thread");
				TankView.this.drawBullet();
			}
		};
		Thread bullet_thread = new Thread(bullet_task);
		bullet_thread.start();
	}
	
	
	@Override
	public boolean onTouchEvent(MotionEvent e) {
		//e𔭎˒͑s
		if(this.wait_flag) {
			//X^[gʂ֑J
			Intent intent = new Intent(this.main_activity, TankBattle.class);
			this.main_activity.startActivity(intent);
			return true;
		}
		if(this.fire_flag) return true;
		
		if(this.battle_mode == TankBattle.BATTLE_MODE_CPU && this.turn == 2) {
			//CPUCPŨ^[
			return true;
		}
		
		int x = (int)e.getX();
		int y = (int)e.getY();
		long time = e.getEventTime();
		int action = e.getAction();
		if(this.time_start == -1) {
			if(action == MotionEvent.ACTION_MOVE) {
				//
				this.x_start = x;
				this.y_start = y;
				this.time_start = time;
			}
		} else {
			long interval = time-this.time_start;
			if(action == MotionEvent.ACTION_UP || interval > FIRE_INTERVAL) {
				//l
				this.time_start = -1;
				
				//˔
				int y2 = y - this.y_start;
				//TODO ԑ̂̌X
				if(y2 > 0) return true; //Ԃ̏㕔ɂe𔭎˂łȂ
				
				int x2 = x - this.x_start;
				double slide_len = Math.sqrt(x2*x2 + y2*y2);
				if(slide_len >= MIN_SLIDE) {
					this.fireHuman((double)x2, (double)y2, (double)interval);
				}
			}
		}
		
		return true;
	}
}
