package com.tank;

public class Tank {
	protected final static int TANK_WIDTH = 12;
	protected final static int TANK_HEIGHT = 6;
	protected final static int TANK_MAX_HP = 100;
	
	private int color;

	private int left_bottom_x;
	private int left_bottom_y;
	private int left_top_x;
	private int left_top_y;
	private int right_bottom_x;
	private int right_bottom_y;
	private int right_top_x;
	private int right_top_y;
	private int center_bottom_x;
	private int center_bottom_y;
	
	
	private int hp;
	
	/** Ԕԍ */
	private int number;
	
	public Tank(int color, int offset_x, int num) {
		this.color = color;
		this.left_bottom_x = offset_x;
		this.number = num;
		this.setHp(TANK_MAX_HP);
		
		this.setLeftTopX(offset_x);
		this.setLeftTopY(TileView.Y_TILE_COUNT-TileView.FIELD_HEIGHT-TANK_HEIGHT);
		
		this.setRightTopX(offset_x+TANK_WIDTH);
		this.setRightTopY(this.getLeftTopY());
		
		this.setLeftBottomX(offset_x);
		this.setLeftBottomY(TileView.Y_TILE_COUNT-TileView.FIELD_HEIGHT);
		
		this.setRightBottomX(offset_x+TANK_WIDTH);
		this.setRightBottomY(this.getLeftBottomY());
		
		System.out.println("Tank top: "+this.getLeftTopX()+", bottom: "+this.getLeftBottomX());
	}
	
	public int getNumber() {
		return this.number;
	}
	
	public int getColor() {
		return this.color;
	}
	
	public int getLeftBottomX() {
		return this.left_bottom_x;
	}
	public void setLeftBottomX(int x) {
		this.left_bottom_x = x;
	}
	public int getLeftBottomY() {
		return this.left_bottom_y;
	}
	public void setLeftBottomY(int y) {
		this.left_bottom_y = y;
	}
	
	
	public int getHp() {
		return this.hp;
	}
	
	public void setHp(int hp) {
		this.hp = hp;
	}
	
	public void damageTank(int damage) {
		this.setHp(this.getHp()-damage);
	}
	
	public void moveLeft() {
		if(this.left_bottom_x > 0) this.left_bottom_x--;
	}
	
	public void moveRight() {
		if(this.left_bottom_x+TANK_WIDTH < TileView.X_TILE_COUNT) this.left_bottom_x++;
	}

	public void setLeftTopX(int left_top_x) {
		this.left_top_x = left_top_x;
	}

	public int getLeftTopX() {
		return left_top_x;
	}

	public void setLeftTopY(int left_top_y) {
		this.left_top_y = left_top_y;
	}

	public int getLeftTopY() {
		return left_top_y;
	}

	public void setRightBottomX(int right_bottom_x) {
		this.right_bottom_x = right_bottom_x;
	}

	public int getRightBottomX() {
		return right_bottom_x;
	}

	public void setRightBottomY(int right_bottom_y) {
		this.right_bottom_y = right_bottom_y;
	}

	public int getRightBottomY() {
		return right_bottom_y;
	}

	public void setRightTopX(int right_top_x) {
		this.right_top_x = right_top_x;
	}

	public int getRightTopX() {
		return right_top_x;
	}

	public void setRightTopY(int right_top_y) {
		this.right_top_y = right_top_y;
	}

	public int getRightTopY() {
		return right_top_y;
	}

	public void setCenterBottomX(int center_bottom_x) {
		this.center_bottom_x = center_bottom_x;
	}

	public int getCenterBottomX() {
		return center_bottom_x;
	}

	public void setCenterBottomY(int center_bottom_y) {
		this.center_bottom_y = center_bottom_y;
	}

	public int getCenterBottomY() {
		return center_bottom_y;
	}
	
	public boolean isAlive() {
		if(this.getHp() <= 0
			|| (this.getLeftTopY() > TileView.Y_TILE_COUNT && this.getRightTopY() > TileView.Y_TILE_COUNT)) {
			return false;
		}
		
		return true;
	}
}
