package com.tank;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class TileView extends SurfaceView implements SurfaceHolder.Callback, Runnable {
	protected static int TILE_SIZE = 2;
	protected static int X_TILE_COUNT;
	protected static int Y_TILE_COUNT;
	protected static int FIELD_HEIGHT;
	
	protected static int MARKER_COLOR = Color.RED;
	protected static int BACKGROUND_COLOR = Color.WHITE;
	protected static int FIELD_COLOR = Color.rgb(51, 0, 0);
	
	protected static int BULLET_EFFECT_R = Tank.TANK_WIDTH;
	
	protected static final int DRAW = -1;
	protected static final int PLAYING = 0;
	protected static final int PLAYER1_WIN = 1;
	protected static final int PLAYER2_WIN = 2;
	
	private int[][] tile_data;
	private int[] hit_x_data;
	private int[] hit_y_data;
	private int hit_index;
	
	private final Paint paint = new Paint();
	
	private Thread thred;
	
	private long time;
	private static int TIME_INCREMENT = 2;
	
	private Tank tank1;
	private Tank tank2;
		
	private int bullet_x = -1; //-1ȂO
	private int bullet_y = -1; //-1ȂO
	
	private int turn;
	
	private int result = 0;
	
	private String wind_arrow;
	private int wind_power;
	
	
	public TileView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		this._tileView(context, attrs);
	}
	
	public TileView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this._tileView(context, attrs);
	}
	
	public TileView(Context context) {
		super(context);
		this._tileView(context, null);
	}
	
	private void _tileView(Context context, AttributeSet attrs) {
		this.hit_x_data = new int[1024];
		this.hit_y_data = new int[1024];
		this.hit_index = 0;
		
		SurfaceHolder holder = this.getHolder();
		holder.addCallback(this);
		holder.setFixedSize(this.getWidth(), this.getHeight());
		
		this.setFocusable(true);
	}
	
	/**
	 * ^C̐F擾
	 * @param x
	 * @param y
	 * @return
	 */
	public int getTile(int x, int y) {
		if(x < 0 || x >= X_TILE_COUNT || y < 0 || y >= Y_TILE_COUNT) return BACKGROUND_COLOR; //͈͊O͔wiF
		return this.tile_data[x][y];
	}
	
	/**
	 * ^C̐FZbg
	 * @param color
	 * @param x
	 * @param y
	 */
	public void setTile(int color, int x, int y) {
		if(x < 0 || x >= X_TILE_COUNT || y < 0 || y >= Y_TILE_COUNT) return;
		this.tile_data[x][y] = color;
	}
	
	/**
	 * ^C̏
	 */
	public void initTiles() {
		System.out.println("TileView: initTiles");
		
		for(int x = 0; x < X_TILE_COUNT; x++) {
			for(int y = 0; y < Y_TILE_COUNT-FIELD_HEIGHT; y++) {
				this.setTile(BACKGROUND_COLOR, x, y);
			}
			for(int y = Y_TILE_COUNT-FIELD_HEIGHT; y < Y_TILE_COUNT; y++) {
				this.setTile(FIELD_COLOR, x, y);
			}
		}
	}
	
	/**
	 * ^CɐԂZbg
	 * @param tank
	 */
	public void setTank(Tank tank) {
		System.out.println("TileView: setTank");
		
		if(tank.getNumber() == 1) {
			this._clearTank(this.tank1);
			this.tank1 = tank;
			System.out.println("tank1");
		} else {
			this._clearTank(this.tank2);
			this.tank2 = tank;
			System.out.println("tank2");
		}
		
		System.out.println("top: "+tank.getLeftTopX()+", bottom: "+tank.getLeftBottomX());
		
		if(tank.getLeftTopX() == tank.getLeftBottomX()) {
			System.out.println("true!!!!!!");
			//nʂɐ
			for(int y = tank.getLeftBottomY()-1; y >= tank.getLeftTopY(); y--) {
				for(int x = tank.getLeftBottomX(); x < tank.getRightBottomX(); x++) {
					this.setTile(tank.getColor(), x, y);
				}
			}
		} else {
			//ɂق+
			int top = (tank.getLeftTopY()<tank.getRightTopY())? tank.getLeftTopY(): tank.getRightTopY();
			int bottom = (tank.getLeftBottomY()<tank.getRightBottomY())? tank.getRightBottomY(): tank.getRightBottomY();
			int left = (tank.getLeftBottomX()<tank.getLeftTopX())? tank.getLeftBottomX(): tank.getLeftTopX();
			int right = (tank.getRightBottomX()<tank.getRightTopX())? tank.getRightTopX(): tank.getRightBottomX();
			
			float m0 = (float)(tank.getRightTopY()-tank.getLeftTopY())/(float)(tank.getRightTopX()-tank.getLeftTopX());
			float m1 = (float)(tank.getRightTopY()-tank.getRightBottomY())/(float)(tank.getRightTopX()-tank.getRightBottomX());
			
			int y0 = (int) (tank.getLeftTopY() - m0*tank.getLeftTopX());
			int y1 = (int) (tank.getLeftBottomY() - m0*tank.getLeftBottomX());
			int y2 = (int) (tank.getLeftTopY() - m1*tank.getLeftTopX());
			int y3 = (int) (tank.getRightTopY() - m1*tank.getRightTopX());
	
	System.out.println("m0: "+m0+", m1: "+m1);
	System.out.println("y0: "+y0+", y1: "+y1+", y2: "+y2+", y3: "+y3);
			
			for(int y = bottom-1; y >= top; y--) {
				for(int x = left; x < right; x++) {
					if(y >= m0*x+y0 && y <= m0*x+y1 && y <= m1*x+y2 && y >= m1*x+y3) {
						this.setTile(tank.getColor(), x, y);
						System.out.println("set: (x, y) = ("+x+", "+y+")");
					}
				}
			}
		}
	}
	
	private void _clearTank(Tank tank) {
		int top = (tank.getLeftTopY()<tank.getRightTopY())? tank.getLeftTopY(): tank.getRightTopY();
		int bottom = (tank.getLeftBottomY()<tank.getRightBottomY())? tank.getRightBottomY(): tank.getRightBottomY();
		int left = (tank.getLeftBottomX()<tank.getLeftTopX())? tank.getLeftBottomX(): tank.getLeftTopX();
		int right = (tank.getRightBottomX()<tank.getRightTopX())? tank.getRightTopX(): tank.getRightBottomX();
		for(int y = bottom-1; y >= top; y--) {
			for(int x = left; x < right; x++) {
				if(this.getTile(x, y) == tank.getColor()) this.setTile(BACKGROUND_COLOR, x, y);
			}
		}
	}
	
	/**
	 * eۂ^CɃZbg
	 * @return eȊÔ̂false
	 */
	public boolean setBullet(int x, int y) {
		this.bullet_x = x;
		
		//Ȍꍇ}[J[ݒ
		if(y < 0) {
			this.bullet_y = -1;
			return true;
		}
		
		this.bullet_y = y;
		
		int data = this.getTile(x, y);
		if(data != BACKGROUND_COLOR && data != Color.BLACK) {
			this.bullet_x = -1;
			this.bullet_y = -1;

			this.afterHitBullet(x, y);

			return false;
		}
		
		return true;
	}
	
	public void afterHitBullet(int x, int y) {
		//ȅՓˏۑ
		this.hit_x_data[this.hit_index] = x;
		this.hit_y_data[this.hit_index] = y;
		this.hit_index++;
		
		//S~ɒě
		int min1 = BULLET_EFFECT_R + 1;
		int min2 = min1;
		for(int r_y = y-BULLET_EFFECT_R; r_y<y+BULLET_EFFECT_R; r_y++) {
			for(int r_x = x-BULLET_EFFECT_R; r_x<x+BULLET_EFFECT_R; r_x++) {
				int r_x2 = r_x - x;
				int r_y2 = r_y - y;
				double len;
				if((len=Math.sqrt(r_x2*r_x2 + r_y2*r_y2)) < BULLET_EFFECT_R) {
					//L͈͓
					if(this.getTile(r_x, r_y) == FIELD_COLOR) {
						this.setTile(BACKGROUND_COLOR, r_x, r_y);
					} else if(this.getTile(r_x, r_y) == this.tank1.getColor()) {
						if(len < min1) min1 = (int) len;
					} else if(this.getTile(r_x, r_y) == this.tank2.getColor()) {
						if(len < min2) min2 = (int) len;
					}
				}
			}
		}

		if(min1 < BULLET_EFFECT_R + 1) {
			int damage = (min1==0)? 20: 20/min1;
			this.tank1.damageTank(damage);
			System.out.println("damage1: "+damage);
		}
		if(min2 < BULLET_EFFECT_R + 1) {
			int damage = (min2==0)? 20: 20/min2;
			this.tank2.damageTank(damage);
			System.out.println("damage2: "+damage);
		}
	}
	
	public Tank moveTank(Tank tank) {
		if(this.getTile(tank.getCenterBottomX(), tank.getCenterBottomY()) != BACKGROUND_COLOR) return tank;
		//Ԃ̒S̉Ȃ
		boolean moveLeftFlag = false;
		boolean moveRightFlag = false;

		if(this.getTile(tank.getLeftBottomX(), tank.getLeftBottomY()) == BACKGROUND_COLOR) {
			moveLeftFlag = true;
		}
		if(this.getTile(tank.getRightBottomX(), tank.getRightBottomY()) == BACKGROUND_COLOR) {
			moveRightFlag = true;
		}

		System.out.println("leftFlag: "+ moveLeftFlag+ ", rightFlag: "+moveRightFlag);
		
		if(moveLeftFlag && moveRightFlag) {
			//^Ɉړ
			//y: ɍsق+
			int top = (tank.getLeftTopY()<tank.getRightTopY())? tank.getLeftTopY(): tank.getRightTopY();
			int bottom = (tank.getLeftBottomY()>tank.getRightBottomY())? tank.getLeftBottomY(): tank.getRightBottomY();
			int left = (tank.getLeftBottomX()<tank.getLeftTopX())? tank.getLeftBottomX(): tank.getLeftTopX();
			int right = (tank.getRightBottomX()>tank.getRightTopX())? tank.getRightBottomX(): tank.getRightTopX();
			for(int y = bottom; y >= top; y--) {
				for(int x = left; x < right; x++) {
					if(this.getTile(x, y) == tank.getColor()) {
						this.setTile(BACKGROUND_COLOR, x, y);
						this.setTile(tank.getColor(), x, y+1);
					}
				}
			}
			tank.setCenterBottomY(tank.getCenterBottomY()+1);
			tank.setLeftTopY(tank.getLeftTopY()+1);
			tank.setLeftBottomY(tank.getLeftBottomY()+1);
			tank.setRightTopY(tank.getRightTopY()+1);
			tank.setRightBottomY(tank.getRightBottomY()+1);
			
			tank = this.moveTank(tank);
		} else if(moveLeftFlag) {
			//E[ɍ]
			tank = this._turnLeft(tank);
		} else if(moveRightFlag) {
			//[ɉE]
			tank = this._turnRight(tank);
		}
		
		return tank;
	}
	
	private Tank _turnLeft(Tank tank) {
		return tank;
	}
	
	private Tank _turnRight(Tank tank) {
		return tank;
	}
	
	public void clearBullet(int x, int y) {
		if(y < 0) y = 0; //}[J[폜
		this.setTile(BACKGROUND_COLOR, x, y);
	}
	
	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		System.out.println("TIleView: onSizeChanged");
		
		X_TILE_COUNT = (int)Math.floor(w/TILE_SIZE);
		Y_TILE_COUNT = (int)Math.floor(h/TILE_SIZE);
		
		FIELD_HEIGHT = Y_TILE_COUNT / 3;
		
		System.out.println("TILE_SIZE: "+TILE_SIZE);
		System.out.println("X_TILE_COUNT: "+X_TILE_COUNT);
		System.out.println("Y_TILE_COUNT: "+Y_TILE_COUNT);
		System.out.println("FIELD_HEIGHT: "+FIELD_HEIGHT);


		
		this.tile_data  = new int[X_TILE_COUNT][Y_TILE_COUNT];
		this.initTiles();
	}

	@Override
	public void surfaceChanged(SurfaceHolder arg0, int arg1, int arg2, int arg3) {
		
	}

	@Override
	public void surfaceCreated(SurfaceHolder arg0) {
		this.thred = new Thread(this);
		this.thred.start();
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder arg0) {
		this.thred = null;
	}

	@Override
	public void run() {
		while(this.thred != null) {
			Canvas canvas = this.getHolder().lockCanvas();
			this.draw(canvas);
			this.getHolder().unlockCanvasAndPost(canvas);
		}
	}
	
	private void _drawTank(Tank tank, Canvas canvas) {
		if(!tank.isAlive()) return;
		//ԕ`
		this.paint.setColor(tank.getColor());
		Path path = new Path();
		path.moveTo(tank.getLeftTopX()*TILE_SIZE, tank.getLeftTopY()*TILE_SIZE);
		path.lineTo(tank.getRightTopX()*TILE_SIZE, tank.getRightTopY()*TILE_SIZE);
		path.lineTo(tank.getRightBottomX()*TILE_SIZE, tank.getRightBottomY()*TILE_SIZE);
		path.lineTo(tank.getLeftBottomX()*TILE_SIZE, tank.getLeftBottomY()*TILE_SIZE);
		canvas.drawPath(path, this.paint);
		
		//HP`
		this.paint.setColor(Color.BLACK);
		canvas.drawRect(
			tank.getLeftBottomX()*TILE_SIZE,
			(tank.getLeftTopY()-7)*TILE_SIZE,
			tank.getRightBottomX()*TILE_SIZE,
			(tank.getLeftTopY()-3)*TILE_SIZE,
			this.paint
		);
		this.paint.setColor(Color.MAGENTA);
		canvas.drawRect(
			(float)(tank.getLeftBottomX()*TILE_SIZE+1.0),
			(float)((tank.getLeftTopY()-7.0)*TILE_SIZE+1.0),
			(float)((float)(tank.getLeftBottomX()+(float)Tank.TANK_WIDTH*((float)tank.getHp()/(float)Tank.TANK_MAX_HP))*(float)TILE_SIZE-1.0),
			(float)((tank.getLeftTopY()-3.0)*TILE_SIZE-1.0),
			this.paint
		);
	}
	
	public void draw(Canvas canvas) {
		canvas.save();
		
		//wi
		canvas.drawColor(BACKGROUND_COLOR);

		//`
		this.paint.setAntiAlias(true);
		this.paint.setColor(Color.BLACK);
		this.paint.setStyle(Paint.Style.STROKE);
		canvas.drawCircle(15*TILE_SIZE, 10*TILE_SIZE, 8*TILE_SIZE, this.paint);
		canvas.drawText(this.wind_arrow, 12*TILE_SIZE, 12*TILE_SIZE, this.paint);
		canvas.drawText(this.wind_power+"m", 10*TILE_SIZE, 25*TILE_SIZE, this.paint);
		this.paint.setAntiAlias(false);
		
		this.paint.setStyle(Paint.Style.FILL);
		//tB[h`
		this.paint.setColor(FIELD_COLOR);
		for(int y = Y_TILE_COUNT-FIELD_HEIGHT; y < Y_TILE_COUNT; y++) {
			int x_start = 0;
			int x;
			for(x = 0; x < X_TILE_COUNT; x++) {
				if(this.tile_data[x][y] != FIELD_COLOR) {
					canvas.drawRect(x_start*TILE_SIZE, y*TILE_SIZE, x*TILE_SIZE, (y+1)*TILE_SIZE, this.paint);
					while(true) {
						if(++x == X_TILE_COUNT || this.tile_data[x][y] == FIELD_COLOR) break;
					}
					x_start = x;
				}
			}
			if(x_start != x) {
				canvas.drawRect(x_start*TILE_SIZE, y*TILE_SIZE, x*TILE_SIZE, (y+1)*TILE_SIZE, this.paint);
			}
		}
//		canvas.drawRect(0, (Y_TILE_COUNT-FIELD_HEIGHT)*TILE_SIZE, X_TILE_COUNT*TILE_SIZE, Y_TILE_COUNT*TILE_SIZE, this.paint);
//		this.paint.setColor(BACKGROUND_COLOR);
//		for(int i = 0; i < this.hit_index; i++) {
//			System.out.println("hit_x: "+this.hit_x_data[i]+", hit_y: "+this.hit_y_data[i]+", r: "+BULLET_EFFECT_R);
//			canvas.drawCircle(this.hit_x_data[i]*TILE_SIZE, this.hit_y_data[i]*TILE_SIZE, BULLET_EFFECT_R*TILE_SIZE, this.paint);
//		}

		//e`
		if(this.bullet_x != -1) {
			if(this.bullet_y != -1) {
				//e͈͓
				this.paint.setColor(Color.BLACK);
				canvas.drawCircle(this.bullet_x*TILE_SIZE, this.bullet_y*TILE_SIZE, TILE_SIZE, this.paint);
			} else {
				//}[J[
				this.paint.setColor(MARKER_COLOR);
				canvas.drawRect(this.bullet_x*TILE_SIZE, 0, (this.bullet_x+1)*TILE_SIZE, TILE_SIZE, this.paint);
			}
		}
		
//		this.paint.setColor(Color.BLACK);
//		for(int y = 0; y < Y_TILE_COUNT; y++) {
//			for(int x = 0; x < X_TILE_COUNT; x++) {
//				if(this.tile_data[x][y] == this.tank1.getColor() || this.tile_data[x][y] == this.tank2.getColor()) {
//					canvas.drawRect(x*TILE_SIZE, y*TILE_SIZE, (x+1)*TILE_SIZE, (y+1)*TILE_SIZE, this.paint);
//				}
//			}
//		}		
		
		this._drawTank(this.tank1, canvas);
		this._drawTank(this.tank2, canvas);
		
//		this.paint.setColor(Color.BLACK);
//		for(int y = 0; y < Y_TILE_COUNT; y++) {
//			for(int x = 0; x < X_TILE_COUNT; x++) {
//				if(this.tile_data[x][y] == this.tank1.getColor() || this.tile_data[x][y] == this.tank2.getColor()) {
//					canvas.drawRect(x*TILE_SIZE, y*TILE_SIZE, (x+1)*TILE_SIZE, (y+1)*TILE_SIZE, this.paint);
//				}
//			}
//		}
		
		if(this.result != PLAYING) {
			this.paint.setColor(Color.BLACK);
			this.paint.setAntiAlias(true);
			switch(this.result) {
			case DRAW: //draw
				canvas.drawText("DRAW", X_TILE_COUNT/4*TILE_SIZE, Y_TILE_COUNT/2*TILE_SIZE, this.paint);
				break;
			case PLAYER1_WIN: //player1 win
				canvas.drawText("Winner: Player1", X_TILE_COUNT/4*TILE_SIZE, Y_TILE_COUNT/2*TILE_SIZE, this.paint);
				break;
			case PLAYER2_WIN: //player2 win
				canvas.drawText("Winner: Player2", X_TILE_COUNT/4*TILE_SIZE, Y_TILE_COUNT/2*TILE_SIZE, this.paint);
				break;
			}
			canvas.drawText("Touch and move to main menu.", X_TILE_COUNT/4*TILE_SIZE, (Y_TILE_COUNT/2+10)*TILE_SIZE, this.paint);
			this.paint.setAntiAlias(false);	
		} else {
			//Player` Ԃ̏ɖ
			this.paint.setColor(Color.RED);
			Tank tank = (this.turn==1)? this.tank1: this.tank2;
			canvas.drawText("", (tank.getLeftBottomX()+Tank.TANK_WIDTH/2-1)*TILE_SIZE, (tank.getLeftTopY()-10)*TILE_SIZE, this.paint);
		}

		this.incrementTime();
		canvas.restore();
	}
	
	public void incrementTime() {
		this.setTime(this.getTime()+TIME_INCREMENT);
	}
	
	public long getTime() {
		return this.time;
	}
	
	public void setTime(long time) {
		this.time = time;
	}
	
	public Tank getTank1() {
		return this.tank1;
	}
	
	public Tank getTank2() {
		return this.tank2;
	}
	
	public void setTank1Only(Tank tank) {
		this.tank1 = tank;
	}
	
	public void setTank2Only(Tank tank) {
		this.tank2 = tank;
	}
	
	public void setTurn(int turn) {
		this.turn = turn;
	}
	
	public int getResult() {
		return this.result;
	}
	
	public void setResult(int result) {
		this.result = result;
	}
	
	/**
	 * vXEA}CiX
	 * @param power
	 */
	public void setWindow(int power) {
		this.wind_power = Math.abs(power);
		if(power < 0) {
			this.wind_arrow = "";
		} else if(power > 0) {
			this.wind_arrow = "";
		} else {
			this.wind_arrow = " ";
		}
	}
}
