package jp.ac.osaka_u.ist.sel.tetra;

import java.math.BigInteger;

import android.app.Activity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.*;
import android.view.View.OnKeyListener;
import android.widget.*;

public class fibonacciEdit extends Activity implements View.OnClickListener, OnKeyListener{
	String number1="0",number2="1";
	int n = 1;
	Editor e;
	StopWatch sw;
	int miss=0;
	long lap;
	boolean start=false;
    SharedPreferences fibo;
	//
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fibo);

        ((Button)findViewById(R.id.Button01)).setOnClickListener(this);
		((EditText)findViewById(R.id.EditText01)).setOnKeyListener(this);
		fibo = getSharedPreferences("fibo",MODE_PRIVATE);
		e=fibo.edit();
    }

	@Override
	public void onClick(View v) {
		EditText input=(EditText)findViewById(R.id.EditText01);
		if (input != null) {
			if(start && input.length() != 0){
				calc();
			}
			if(!start){
				startGame();
			}
		}
	}


	@Override
	public boolean onKey(View v, int keyCode, KeyEvent event) {
		EditText input=(EditText)findViewById(R.id.EditText01);
         if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_ENTER) {
     		if (input != null) {
    			if(start && input.length() != 0){
    				calc();
    			}else if(!start){
    				startGame();
    			}
    		}
            return true;
        }
		return false;
	}
	
	public void calc(){
		BigInteger a=new BigInteger(number1);
		BigInteger b=new BigInteger(number2);
		BigInteger c=new BigInteger(((EditText)findViewById(R.id.EditText01)).getText().toString());
		if (a.add(b).equals(c)) {
			number1=number2.toString();
			number2=a.add(b).toString();
			n++;
			lap=sw.lap();
			((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 1) + ")=");;
			((TextView)findViewById(R.id.TextView03)).setText("F(" + n + ")=");
			((TextView)findViewById(R.id.TextView02)).setText(number1);
			((TextView)findViewById(R.id.TextView04)).setText(number2);
			((TextView)findViewById(R.id.TextView05)).setText("Collect! lap: "+lap/1000+"."+lap%1000+" sec");
			sw.restart();
			((EditText)findViewById(R.id.EditText01)).setText("");
			((HorizontalScrollView)findViewById(R.id.HorizontalScrollView01)).fullScroll(HorizontalScrollView.FOCUS_RIGHT);
			logger();
			((EditText)findViewById(R.id.EditText01)).requestFocus();
			miss=0;
		} else {
			((TextView)findViewById(R.id.TextView05)).setText("Wrong");
			miss++;
		}
	}
	
	public void startGame(){
		((EditText)findViewById(R.id.EditText01)).setText("");
        number1=fibo.getString("number1", "0");
       	((TextView)findViewById(R.id.TextView02)).setText(number1);
        number2=fibo.getString("number2", "1");
       	((TextView)findViewById(R.id.TextView04)).setText(number2);
       	n=fibo.getInt("fn",1);
		((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 1) + ")=");;
		((TextView)findViewById(R.id.TextView03)).setText("F(" + n + ")=");
		if (fibo.getLong("lap", 0)==0){
			sw=new StopWatch();
		} else {
			sw=new StopWatch(fibo.getLong("lap", 0));
		}
		((Button)findViewById(R.id.Button01)).setText("check");
		((TextView)findViewById(R.id.TextView05)).setText("PRESS BACK to take a break");
		start=true;
	}
	
	protected void logger(){
		e.putInt("fn", n);
		e.putString("number1", number1);
		e.putString("number2", number2);
		e.putString("fn"+(Integer.toString(n)),number2 );
		e.putLong("lap"+(Integer.toString(n)), lap);
		e.putInt("miss"+(Integer.toString(n)), miss);
		e.commit();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		if(start)
			resumeLogger();
	}
	
	protected void resumeLogger(){
		e.putLong("lap", sw.lap());
		e.commit();
	}
	
	
}