package jp.ac.osaka_u.ist.sel.tetra;

import java.math.BigInteger;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnKeyListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.TextView;

public class fibonacciTime extends Activity implements View.OnClickListener, OnKeyListener{
	String number1="0",number2="1";
	int time=0;
	int number=0;
	int n = 1;
	Editor e;
	StopWatch sw;
	int miss=0;
	long lap;
	boolean start=false;
    SharedPreferences fibo;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fibo);

        ((Button)findViewById(R.id.Button01)).setOnClickListener(this);
		((EditText)findViewById(R.id.EditText01)).setOnKeyListener(this);
		
		Intent intent=getIntent();
		number=intent.getIntExtra("number", 0);
		
        fibo = getSharedPreferences("tt"+number,MODE_PRIVATE);
        e=this.fibo.edit();

    }
    
	@Override
	public void onClick(View v) {
		EditText input=(EditText)findViewById(R.id.EditText01);
		if (input != null) {
			if(start && input.length() != 0){
				calc();
			}
			if(!start){
				startGame();
			}
		}
	}


	@Override
	public boolean onKey(View v, int keyCode, KeyEvent event) {
		EditText input=(EditText)findViewById(R.id.EditText01);
         if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_ENTER) {
     		if (input != null) {
    			if(start && input.length() != 0){
    				calc();
    			}else if(!start){
    				startGame();
    			}
    		}
            return true;
        }
		return false;
	}

	
	public void calc(){
		BigInteger a=new BigInteger(number1);
		BigInteger b=new BigInteger(number2);
		BigInteger c=new BigInteger(((EditText)findViewById(R.id.EditText01)).getText().toString());
		if (a.add(b).equals(c)) {
			time += sw.lap();
			number1=number2.toString();
			number2=a.add(b).toString();
			n++;
			((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 1) + ")=");;
			((TextView)findViewById(R.id.TextView03)).setText("F(" + n + ")=");
			((TextView)findViewById(R.id.TextView02)).setText(number1);
			((TextView)findViewById(R.id.TextView04)).setText(number2);
			((TextView)findViewById(R.id.TextView05)).setText("Collect! PRESS BACK to take a break");
			sw.restart();
			((EditText)findViewById(R.id.EditText01)).setText("");
			((HorizontalScrollView)findViewById(R.id.HorizontalScrollView01)).fullScroll(HorizontalScrollView.FOCUS_RIGHT);
			logger();
			((EditText)findViewById(R.id.EditText01)).requestFocus();
			if(n>=number){
				((TextView)findViewById(R.id.TextView05)).setText("Finish! Your time : "+time/1000+"."+time%1000+" sec.");
				if(fibo.getLong("best", 9999999)>time){
			        e=fibo.edit();
					e.putLong("best", time);
					e.commit();
				}
				reset();
			}
		} else {
			((TextView)findViewById(R.id.TextView05)).setText("Wrong... PRESS BACK to take a break");
		}
	}
	
	public void startGame(){
		((EditText)findViewById(R.id.EditText01)).setText("");
        number1=fibo.getString("number1", "0");
       	((TextView)findViewById(R.id.TextView02)).setText(number1);
        number2=fibo.getString("number2", "1");
       	((TextView)findViewById(R.id.TextView04)).setText(number2);
       	n=fibo.getInt("fn",1);
		((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 1) + ")=");;
		((TextView)findViewById(R.id.TextView03)).setText("F(" + n + ")=");
		if (fibo.getLong("lap", 0)==0){
			sw=new StopWatch();
		} else {
			sw=new StopWatch(fibo.getLong("lap", 0));
		}
		((Button)findViewById(R.id.Button01)).setText("check");
		((TextView)findViewById(R.id.TextView05)).setText("PRESS BACK to take a break");
		start=true;
	}
	
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	super.onCreateOptionsMenu(menu);
    	if(start){
    		MenuItem item0=menu.add(0, 0, 0, "surrender");
    		item0.setIcon(android.R.drawable.ic_menu_close_clear_cancel);
    		return true;
    	}
    	return false;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	AlertDialog.Builder ad;
    	switch(item.getItemId()){
    	case 0:
    		ad=new AlertDialog.Builder(this);
    		ad.setTitle("Warning");
    		ad.setMessage("Surrender?");
    		ad.setPositiveButton("Yes",
    				new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							reset();
						}
					});
    		ad.setNegativeButton("No", null);
    		ad.create();
    		ad.show();
			return true;
    	}
    	return true;
    }
    
	protected void logger(){
		e.putInt("fn", n);
		e.putString("number1", number1);
		e.putString("number2", number2);
		e.commit();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		if(start)
			resumeLogger();
	}
	
	protected void resumeLogger(){
		e.putLong("lap", sw.lap());
		e.commit();
	}
    
    private void reset(){
    	((Button)findViewById(R.id.Button01)).setText("Start");
    	long tmp=fibo.getLong("best",99999999);
        e=fibo.edit();
		e.clear();
		e.putLong("best", tmp);
		e.commit();
		((TextView)findViewById(R.id.TextView05)).setText("PRESS START");
		start=false;
    }
}
