package jp.ac.osaka_u.ist.sel.tetra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.database.MatrixCursor;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.SimpleCursorAdapter;

public class logView extends Activity {
	private ListView loglist=null;
	private SharedPreferences numbers=null;
	private String ff="";
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.log);
        
        loglist=(ListView)findViewById(R.id.ListView01);
        
        Bundle extras=getIntent().getExtras();
        if (extras!=null) ff=extras.getString("mode"); 
        
        makeLogView();
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	super.onCreateOptionsMenu(menu);
    	
    	MenuItem item0=menu.add(0, 0, 0, "Delete Log");
    	item0.setIcon(android.R.drawable.ic_menu_delete);
    	return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	if(item.getItemId()==0){
    		AlertDialog.Builder ad=new AlertDialog.Builder(this);
    		ad.setTitle("Warning");
    		ad.setMessage("Are you sure you want to delete this DATA?");
    		ad.setPositiveButton("Yes",
    				new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							Editor e=numbers.edit();
							e.clear();
							e.commit();
							loglist.removeAllViewsInLayout();
							makeLogView();
						}
					});
    		ad.setNegativeButton("No", null);
    		ad.create();
    		ad.show();
			return true;
    	}
    	return true;
    }
    
    private void makeLogView(){
    	int i=0;
    	Map<String, String> data;
    	
        List<Map<String, String>> dataList = new ArrayList<Map<String,String>>();
        data = new HashMap<String, String>();
        data.put("fn",ff+"(0)=0");
        dataList.add(data);
        
        if (ff.equals("F")){
        	numbers = getSharedPreferences("fibo",MODE_PRIVATE);
        	data = new HashMap<String, String>();
        	data.put("fn",ff+"(1)=1");
        	dataList.add(data);
        	i=2;
        } else {
        	numbers = getSharedPreferences("tri",MODE_PRIVATE);
        	data = new HashMap<String, String>();
        	data.put("fn",ff+"(1)=0");
        	dataList.add(data);
        	data = new HashMap<String, String>();
        	data.put("fn",ff+"(2)=1");
        	dataList.add(data);
        	i=3;
        }
        int fn=numbers.getInt("fn", 0);

        for(;i<=fn;i++){
        	data = new HashMap<String, String>();
        	data.put("fn",ff+"("+i+")="+(numbers.getString("fn"+(Integer.toString(i)),"NA")));
        	data.put("tm",
        			numbers.getLong("lap"+(Integer.toString(i)),0)/1000+"."+numbers.getLong("lap"+(Integer.toString(i)),0)%1000+" sec, "
        			+numbers.getInt("miss"+(Integer.toString(i)),0)+" mistake(s)");

        	dataList.add(data);
		}

        SimpleAdapter adapter = new SimpleAdapter(
            this, dataList, android.R.layout.simple_list_item_2,
            new String[] { "fn", "tm" }, new int[] { android.R.id.text1, android.R.id.text2 }
        );
        loglist.setAdapter(adapter);
        
        //ԉփXN[
        loglist.setSelection(loglist.getCount());
    	
    }
}
