package jp.ac.osaka_u.ist.sel.tetra;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.*;
import android.widget.*;

public class myFibonacci extends Activity implements View.OnClickListener{
	
	private Button btnFE, btnFL, btnTE, btnTL, btnFT1,btnFT2;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        btnFE=(Button)findViewById(R.id.Button01);
        btnFE.setOnClickListener(this);
        btnFL=(Button)findViewById(R.id.Button02);
        btnFL.setOnClickListener(this);
        btnTE=(Button)findViewById(R.id.Button03);
        btnTE.setOnClickListener(this);
        btnTL=(Button)findViewById(R.id.Button04);
        btnTL.setOnClickListener(this);
        btnFT1=(Button)findViewById(R.id.Button05);
        btnFT1.setOnClickListener(this);
		SharedPreferences tt = getSharedPreferences("tt50",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView02)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+"sec");
        btnFT2=(Button)findViewById(R.id.Button06);
        btnFT2.setOnClickListener(this);
        tt = getSharedPreferences("tt100",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView03)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+" sec");
    }

	@Override
	public void onClick(View v) {
		if(v==btnFE){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.fibonacciEdit.class);
			startActivity(intent);
		} else if(v==btnFL){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.logView.class);
			intent.putExtra("mode", "F");
			startActivity(intent);
		} else if(v==btnTE){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.tribonacciEdit.class);
			startActivity(intent);
		} else if(v==btnTL){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.logView.class);
			intent.putExtra("mode", "T");
			startActivity(intent);
		} else if(v==btnFT1){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.fibonacciTime.class);
			intent.putExtra("number", 50);
			startActivity(intent);
		} else if(v==btnFT2){
			Intent intent=new Intent(this,jp.ac.osaka_u.ist.sel.tetra.fibonacciTime.class);
			intent.putExtra("number", 100);
			startActivity(intent);
		}
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		SharedPreferences tt = getSharedPreferences("tt50",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView02)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+"sec");
        tt = getSharedPreferences("tt100",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView03)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+" sec");
	}
	
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	super.onCreateOptionsMenu(menu);
    	
    	MenuItem item0=menu.add(0, 0, 1, "Delete Best Time 50");
    	item0.setIcon(android.R.drawable.ic_menu_edit);
    	MenuItem item4=menu.add(0, 1, 1, "Delete Best Time 100");
    	item4.setIcon(android.R.drawable.ic_menu_edit);
    	MenuItem item3=menu.add(1, 2, 0, "Delete ALL Record");
    	item3.setIcon(android.R.drawable.ic_menu_close_clear_cancel);
    	return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	AlertDialog.Builder ad;
    	switch(item.getItemId()){
    	case 0:
    		ad=new AlertDialog.Builder(this);
    		ad.setTitle("Warning");
    		ad.setMessage("Are you sure you want to delete BEST TIME 50?");
    		ad.setPositiveButton("Yes",
    				new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							deleteBestTime(50);
						}
					});
    		ad.setNegativeButton("No", null);
    		ad.create();
    		ad.show();
			return true;
    	case 1:
    		ad=new AlertDialog.Builder(this);
    		ad.setTitle("Warning");
    		ad.setMessage("Are you sure you want to delete BEST TIME 100?");
    		ad.setPositiveButton("Yes",
    				new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							deleteBestTime(100);
						}
					});
    		ad.setNegativeButton("No", null);
    		ad.create();
    		ad.show();
			return true;
    	case  2:
    		ad=new AlertDialog.Builder(this);
    		ad.setTitle("Warning");
    		ad.setMessage("Are you sure you want to delete ALL Records?");
    		ad.setPositiveButton("Yes",
    				new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							deleteBestTime(50);
							deleteBestTime(100);
							deleteF();
							deleteT();
						}
					});
    		ad.setNegativeButton("No", null);
    		ad.create();
    		ad.show();
			return true;
    	}
    	return true;
    }
    
    private void deleteBestTime(int number){
    	SharedPreferences tt = getSharedPreferences("tt"+number,MODE_PRIVATE);
        Editor e=tt.edit();
        e.putLong("best", 99999999);
		e.commit();
		tt = getSharedPreferences("tt50",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView02)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+"sec");
        tt = getSharedPreferences("tt100",MODE_PRIVATE);
        ((TextView)findViewById(R.id.TextView03)).setText("BEST:\n"
        		+tt.getLong("best", 99999999)/1000+"."+tt.getLong("best", 99999999)%1000+" sec");
    }
    
    private void deleteF(){
    	SharedPreferences f = getSharedPreferences("fibo",MODE_PRIVATE);
        Editor e=f.edit();
		e.clear();
		e.commit();
    }
    
    private void deleteT(){
    	SharedPreferences t = getSharedPreferences("tri",MODE_PRIVATE);
        Editor e=t.edit();
		e.clear();
		e.commit();
    }
}