package jp.ac.osaka_u.ist.sel.tetra;

import java.math.BigInteger;

import android.app.Activity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.*;
import android.view.View.OnKeyListener;
import android.widget.*;

public class tribonacciEdit extends Activity implements View.OnClickListener, OnKeyListener{
	String number1="0",number2="0", number3="1";
	int n = 2;
	Editor e;
	StopWatch sw;
	int miss=0;
	long lap;
	boolean start=false;
	//
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tri);
        
        ((Button)findViewById(R.id.Button01)).setOnClickListener(this);
		((EditText)findViewById(R.id.EditText01)).setOnKeyListener(this);
    }

	@Override
	public void onClick(View v) {
		EditText input=(EditText)findViewById(R.id.EditText01);
		if (input != null) {
			if(start && input.length() != 0){
				calc();
			}
			if(!start){
				startGame();
			}
		}
	}


	@Override
	public boolean onKey(View v, int keyCode, KeyEvent event) {
		EditText input=(EditText)findViewById(R.id.EditText01);
         if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_ENTER) {
     		if (input != null) {
    			if(start && input.length() != 0){
    				calc();
    			}else if(!start){
    				startGame();
    			}
    		}
            return true;
        }
		return false;
	}
	
	public void calc(){
		BigInteger a=new BigInteger(number1);
		BigInteger b=new BigInteger(number2);
		BigInteger c=new BigInteger(number3);
		BigInteger d=new BigInteger(((EditText)findViewById(R.id.EditText01)).getText().toString());
		if (a.add(b).add(c).equals(d)) {
			number1=number2.toString();
			number2=number3.toString();
			number3=d.toString();
			n++;
			((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 2) + ")=");
			((TextView)findViewById(R.id.TextView03)).setText("F(" + (n - 1) + ")=");
			((TextView)findViewById(R.id.TextView05)).setText("F(" + n + ")=");
			((TextView)findViewById(R.id.TextView02)).setText(number1);
			((TextView)findViewById(R.id.TextView04)).setText(number2);
			((TextView)findViewById(R.id.TextView06)).setText(number3);
			lap=sw.lap();
			((TextView)findViewById(R.id.TextView07)).setText("Collect! lap: "+lap/1000+"."+lap%1000+" sec");
			((EditText)findViewById(R.id.EditText01)).setText("");
			((EditText)findViewById(R.id.EditText01)).requestFocus();
			logger();
			miss=0;
		} else {
			((TextView)findViewById(R.id.TextView07)).setText("Wrong");
			miss++;
		}	
	}
	
	public void startGame(){
		((EditText)findViewById(R.id.EditText01)).setText("");
        SharedPreferences tri = getSharedPreferences("tri",MODE_PRIVATE);
        e=tri.edit();
        number1=tri.getString("number1", "0");
        ((TextView)findViewById(R.id.TextView02)).setText(number1);
        number2=tri.getString("number2", "0");
        ((TextView)findViewById(R.id.TextView04)).setText(number2);
        number3=tri.getString("number3", "1");
        ((TextView)findViewById(R.id.TextView06)).setText(number3);
        n=tri.getInt("fn",2);
		((TextView)findViewById(R.id.TextView01)).setText("F(" + (n - 2) + ")=");
		((TextView)findViewById(R.id.TextView03)).setText("F(" + (n - 1) + ")=");
		((TextView)findViewById(R.id.TextView05)).setText("F(" + n + ")=");
        
        if (tri.getLong("lap", 0)==0){
			sw=new StopWatch();
		} else {
			sw=new StopWatch(tri.getLong("lap", 0));
		}
        ((Button)findViewById(R.id.Button01)).setText("check");
		start=true;
	}
	
	protected void logger(){
        e.putInt("fn", n);
		e.putString("number1", number1);
		e.putString("number2", number2);
		e.putString("number3", number3);
		e.putString("fn"+(Integer.toString(n)),number3 );
		e.putLong("lap"+(Integer.toString(n)), lap);
		e.putInt("miss"+(Integer.toString(n)), miss);
		e.commit();
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		if(start)
			resumeLogger();
	}
	
	protected void resumeLogger(){
		e.putLong("lap", sw.lap());
		e.commit();
	}
}
