package jp.ac.osaka_u.ist.sel.sairi;

import java.io.*;
import java.net.URL;
import java.util.Calendar;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.location.*;
import android.os.Bundle;
import android.view.*;
import android.view.View.OnClickListener;
import android.widget.*;

/* BusStops 0:豊中CP(付属図書館前),1:吹田CP(コンベンションセンター前),2:吹田CP(人間科学部前),3:吹田CP(工学部前),4:箕面CP(外国語学部前)
 * BusRoute ou1 0 -> 1 -> 2, 0 -> 1 -> 4
 * BusRoute ou2 3 -> 2 -> 0, 4 -> 2 -> 0
 */

public class OsakaUniversityBusGuide extends Activity implements LocationListener,OnClickListener{
    
	private double latitude, longitude;
	private LocationManager lm;
	TimeAndDateManager td;
	private int time,from=0;
	private Button btn01,btn02;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        btn01=(Button)findViewById(R.id.Button01);
        btn01.setOnClickListener(this);
        btn02=(Button)findViewById(R.id.Button02);
        btn02.setOnClickListener(this);
		
		//座標を取得する
		lm = (LocationManager)getSystemService(LOCATION_SERVICE);
		if(lm.isProviderEnabled(LocationManager.GPS_PROVIDER))
			lm.requestLocationUpdates(LocationManager.GPS_PROVIDER,0,0,this);
		if(lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER))
			lm.requestLocationUpdates(LocationManager.NETWORK_PROVIDER,0,0,this);
		if(!lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER) && !lm.isProviderEnabled(LocationManager.GPS_PROVIDER))
			((TextView)findViewById(R.id.TextView06)).setText("出発地："+getResources().getStringArray(R.array.busStop)[0]);
		
		//latitude= 34.823856;
		//longitude = 135.52383;
		
        // 日付・現在時刻取得　yyyymmdd, hhmm
		// 日付は運休日の判定に使おう
		
		td=new TimeAndDateManager();
		time=td.getTime();
        ((TextView)findViewById(R.id.TextView01)).setText("検索時刻："+td.getYMD()+" "+formatTime(time));
        if(td.isSuspension())
        	((TextView)findViewById(R.id.TextView02)).setText("スクールバス運休日");
        
        //とりあえず豊中
        //busSearcher(td.getTime(),from);
        //やっぱやめ。
    }
    
    /**
     * バス検索
     * @param time 出発時間を指定します。 hhmm
     * @param from 出発するバス停番号です
     * @param to 	到着するバス停番号です
     * @return バスの出発時刻と到着時刻を格納した配列を返します
     */
    private int[] bus(int time, int from, int to){
    	
    	int[] i;
    	i = new int[2];
    	InputStream is;
    	
    	/* 時刻表読み込み！
    	 * 通らないバス停は0が格納されているはず。
    	 */
        try {
        	if (from<to){
        		is = this.getResources().openRawResource(R.raw.ou1);
        	}else{
        		is = this.getResources().openRawResource(R.raw.ou2);
        	}
        	BufferedReader br = new BufferedReader(new InputStreamReader(is)); 
            String line;
            while ((line = br.readLine()) != null) {
            	String[] t=line.split(";");
            	if(Integer.valueOf(t[from]) >= time && Integer.valueOf(t[to]) != 0){
            		i[0]=Integer.valueOf(t[from]);
            		i[1]=Integer.valueOf(t[to]);
            		return i;
            	}
            }
            br.close();
            is.close();
        } catch (IOException e) {
            System.out.println(e);
        }

    	return i;
    }
    
    
    /**
     * バス検索結果表示
     * @param time 出発時間を指定します。 hhmm
     * @param from 出発するバス停番号です
     */
    private void busSearcher(int time, int from){
    	int[] buses= new int[2];
    	switch(from){
    	case 0: //豊中CP(付属図書館前)
    		buses=bus(time,from,1);
    		((TextView)findViewById(R.id.BusStop11)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop12)).setText(" >> "+getResources().getStringArray(R.array.busStop)[1]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime1),buses,isLastBus(buses[0],from,1));
            buses=bus(time,from,3);
            ((TextView)findViewById(R.id.BusStop21)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop22)).setText(" >> "+getResources().getStringArray(R.array.busStop)[3]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime2),buses,isLastBus(buses[0],from,3));
            buses=bus(time,from,4);
            ((TextView)findViewById(R.id.BusStop31)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop32)).setText(" >> "+getResources().getStringArray(R.array.busStop)[4]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime3),buses,isLastBus(buses[0],from,4));
            break;
    	case 2: //吹田CP(人間科学部前)
    		buses=bus(time,from,0);
    		((TextView)findViewById(R.id.BusStop11)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop12)).setText(" >> "+getResources().getStringArray(R.array.busStop)[0]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime1),buses,isLastBus(buses[0],from,0));
    		buses=bus(time,3,0);
            ((TextView)findViewById(R.id.BusStop21)).setText(getResources().getStringArray(R.array.busStop)[3]);
    		((TextView)findViewById(R.id.BusStop22)).setText(" >> "+getResources().getStringArray(R.array.busStop)[0]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime2),buses,isLastBus(buses[0],3,0));
            buses=bus(time,1,4);
            ((TextView)findViewById(R.id.BusStop31)).setText(getResources().getStringArray(R.array.busStop)[1]);
    		((TextView)findViewById(R.id.BusStop32)).setText(" >> "+getResources().getStringArray(R.array.busStop)[4]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime3),buses,isLastBus(buses[0],1,4));
            break;
    	case 3: //吹田CP(工学部前)
    		buses=bus(time,from,0);
    		((TextView)findViewById(R.id.BusStop11)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop12)).setText(" >> "+getResources().getStringArray(R.array.busStop)[0]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime1),buses,isLastBus(buses[0],from,0));
    		buses=bus(time,2,0);
            ((TextView)findViewById(R.id.BusStop21)).setText(getResources().getStringArray(R.array.busStop)[2]);
    		((TextView)findViewById(R.id.BusStop22)).setText(" >> "+getResources().getStringArray(R.array.busStop)[0]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime2),buses,isLastBus(buses[0],2,0));
            buses=bus(time,1,4);
            ((TextView)findViewById(R.id.BusStop31)).setText(getResources().getStringArray(R.array.busStop)[1]);
    		((TextView)findViewById(R.id.BusStop32)).setText(" >> "+getResources().getStringArray(R.array.busStop)[4]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime3),buses,isLastBus(buses[0],1,4));
            break;
    	case 4: //箕面CP(外国語学部前)
    		buses=bus(time,from,2);
    		((TextView)findViewById(R.id.BusStop11)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop12)).setText(" >> "+getResources().getStringArray(R.array.busStop)[2]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime1),buses,isLastBus(buses[0],from,2));
            buses=bus(time,from,0);
            ((TextView)findViewById(R.id.BusStop21)).setText(getResources().getStringArray(R.array.busStop)[from]);
    		((TextView)findViewById(R.id.BusStop22)).setText(" >> "+getResources().getStringArray(R.array.busStop)[0]);
    		busTimeViewer((TextView)findViewById(R.id.BusTime2),buses,isLastBus(buses[0],from,0));
    		((TextView)findViewById(R.id.BusStop31)).setText("");
            ((TextView)findViewById(R.id.BusStop32)).setText("");
    		((TextView)findViewById(R.id.BusTime3)).setText("");
            break;
    	}
    }
    
    /**
     * バス時刻表示
     * @param v 表示先
     * @param buses バスの時刻
     */
    private void busTimeViewer(TextView v,int[] buses,boolean last){
    	if(buses[0]==0){
    		v.setText("終了");
    	} else {
    		v.setText(formatTime(buses[0])+" >> "+formatTime(buses[1]));
    		if(last)
    			v.setText(v.getText().toString()+" ▲最終");
    	}
    }
    
    /**
     * 終バス
     * @param time
     * @param from
     * @param to
     * @return
     */
    private boolean isLastBus(int time,int from, int to){
    	if(bus(time+1,from,to)[0]==0)
    		return true;
    	else return false;
    }
    
    /**
     * 今いるキャンパスの判定
     * @param latitude
     * @param longitude
     * @return 最寄りのバス停番号（0,2,3,4）
     */
    private int whereAmI(double latitude, double longitude){
    	if (latitude > 34.836 && longitude+latitude > 170.325) return 4;
    	else if (longitude < 135.489 && longitude+latitude < 170.325) return 0;
    	else if (longitude-latitude < 100.703) return 3;
    	else return 2;
    }

	@Override
	public void onLocationChanged(Location location) {
		latitude = location.getLatitude();
		longitude = location.getLongitude();
		//((TextView)findViewById(R.id.TextView03)).setText(location.getProvider());
		//((TextView)findViewById(R.id.TextView04)).setText(""+latitude);
		//((TextView)findViewById(R.id.TextView05)).setText(""+longitude);
		from=whereAmI(latitude, longitude);
		((TextView)findViewById(R.id.TextView06)).setText("現在地："+getResources().getStringArray(R.array.busStop)[from]);
        busSearcher(time, from);
       	//GPSにしろネットワークにしろ、場所が特定できたらおしまい
        stopLM();
	}

	@Override
	public void onProviderDisabled(String provider) {
		// Do nothing.
	}

	@Override
	public void onProviderEnabled(String provider) {
		// Do nothing.
	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) {
		// Do nothing.
	}
	
	private void stopLM(){
		lm.removeUpdates(this);
	}
	
	/**
	 * 日付と現在時刻の取得および運休日を管理するクラス
	 */
	private class TimeAndDateManager {
		private int ymd,time;
		private Calendar cal;
		
		private TimeAndDateManager(){
			cal = Calendar.getInstance();
	        time=cal.get(Calendar.HOUR_OF_DAY)*100 + cal.get(Calendar.MINUTE);
	 	}
		
		/**
		 * 今日はいつだっけ
		 * @return YY/MM/DD
		 */
		public String getYMD(){
			return (cal.get(Calendar.YEAR)+"/"+String.format("%1$02d", cal.get(Calendar.MONTH)+1)+"/"+(String.format("%1$02d", cal.get(Calendar.DAY_OF_MONTH))));
		}
		
		/**
		 * オブジェクトを作った時間はいつだっけ
		 * @return HHMM
		 */
		public int getTime(){
			return time;
		}
		
		/**
		 * 今日ってバス走ってたっけ（2010-2011）
		 * @return 再利バス運休日か否か
		 */
		public boolean isSuspension(){
			int date=(cal.get(Calendar.MONTH)+1)*100 + cal.get(Calendar.DAY_OF_MONTH);
			if(isHoliday(date)) return true;
			
			//2010-2011
			date=ymd-20100000;
			//臨時休業期間
			int[] sp=getResources().getIntArray(R.array.sp);
			for(int i=0;i<sp.length;i+=2){
				if(date>=sp[i] && date<=sp[i+1])
					return true;
			}
			//長期休暇
			if(isInVacation(date, getResources().getIntArray(R.array.spring)))
				return true;
			if(isInVacation(date, getResources().getIntArray(R.array.summer)))
				return true;
			if(isInVacation(date, getResources().getIntArray(R.array.winter)))
				return true;
			return false;
		}
		
		private boolean isHoliday(int date){

			int day=cal.get(Calendar.DAY_OF_WEEK);
			int year=cal.get(Calendar.YEAR);
			
			//土日
			if (day==Calendar.SATURDAY || day==Calendar.SUNDAY)
				return true;
			//祝
			if(isHolidayDate(date))return true; //決まっている祝日
			if(isSp(year,date))return true; //春分-2025
			if(isAu(year,date))return true; //秋分-2044
			if((isHolidayDate(date-1) || isSp(year,date-1) || isAu(year,date-1)) && day==Calendar.MONDAY) return true; //月曜の振替休日
			
			if(date==0506 && (day==Calendar.TUESDAY || day==Calendar.WEDNESDAY))return true;//5月6日処理
			if(isAu(year,date+1) && year==2015)return true;//シルバーウィーク-2025
			
			if(isHappyMonday(day, date/100))return true;//ハッピーマンデー
			
			return false;
		}
		
		private boolean isHolidayDate(int date){
			if (date==101 			//元日 
					|| date==211	//建国記念の日
					|| date==429	//昭和の日
					|| date==503 	//憲法記念日
					|| date==504 	//みどりの日
					|| date==505 	//子供の日
					|| date==1103	//文化の日
					|| date==1123	//勤労感謝の日
					|| date==1223	//天皇誕生日
					) return true;
			return false;
		}
		
		/**
		 * 2025までの春分判定
		 */
		private boolean isSp(int year,int date){
			if(year%4 == 0 && year%100 != 0 || year%400 == 0)
				return (date==320);
			else if((year-1)%4 == 0 && (year-1)%100 != 0 || (year-1)%400 == 0)
				return (date==320);
			else return (date==321);
		}
		
		/**
		 * 2044までの秋分判定
		 */
		private boolean isAu(int year,int date){
			if(year%4 == 0 && year%100 != 0 || year%400 == 0)
				return (date==922);
			else return (date==923);
		}
		
		/**
		 * ハッピーマンデー判定
		 */
		private boolean isHappyMonday(int day,int month){
			int dow=cal.get(Calendar.DAY_OF_WEEK_IN_MONTH);
			if (day==Calendar.MONDAY ) {
				if(month==1&&dow==2)return true;//成人の日
				if(month==7&&dow==3)return true;//海の日
				if(month==9&&dow==3)return true;//敬老の日
				if(month==10&&dow==2)return true;//体育の日
			}
			return false;
		}
		
		private boolean isInVacation(int date,int[] vacation){
			for(int i=0;i<vacation.length;i+=2){
				if(date>=vacation[i] && date<=vacation[i+1])
					return true;
			}
			return false;
		}

	}

	@Override
	public void onClick(View v) {
		if(v==btn01){
			new AlertDialog.Builder(this).setTitle(R.string.button01).setItems(R.array.campus,
	           new DialogInterface.OnClickListener() {
	              public void onClick(DialogInterface dialoginterface, int i) {
	            	  from=i*2;
	            	  //現在地取得中止
	            	  stopLM();
	            	  ((TextView)findViewById(R.id.TextView06)).setText("出発地："+getResources().getStringArray(R.array.campus)[i]);
	            	  busSearcher(time, from);     	  
	              }
	           })
	          .show();
			
		}else if(v==btn02){
			new TimePickerDialog(OsakaUniversityBusGuide.this, new TimePickerDialog.OnTimeSetListener() {
				public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
					time=hourOfDay*100+minute;
					busSearcher(time, from);
			        ((TextView)findViewById(R.id.TextView01)).setText("検索時刻："+td.getYMD()+" "+formatTime(time));
				}
			} , time/100, time%100, true)
			.show();
		}
	}
	
	public String formatTime(int time){
		return (String.format("%1$02d", time/100)+":"+String.format("%1$02d", time%100));
	}
}