package jp.ac.osaka_u.ist.sel.WordPuzzle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;


public class Board {

	private static final int MAX_WORD_SIZE = 10;
	private Item[][] _board;
	private int _boardSize;
	private LinkedList<Item> _word = new LinkedList<Item>();
	private LinkedList<CompleteWord> _completeList = new LinkedList<CompleteWord>();
	private Context _context;
	private ArrayList<String> _deleteWords = new ArrayList<String>();
	StringComparator _stComparator = new StringComparator();
	WordArrayList _arrayList;
	int debug = 0;



	/**
	 * The constructor
	 */
	public Board(Context context,int size){

		_boardSize = size;
		_board = new Item[_boardSize][_boardSize];
		_context = context;
		_arrayList = new WordArrayList();
		initialBoard();

	}

	/**
	 * Initialize the game board
	 */
	private void initialBoard() {
		LinkedList<CompleteWord> completeWords;
		Item item;
		int x,y;
		fillBoard();
		completeWords = findCompleteWords(_board);

		while(!completeWords.isEmpty()){

		/*	System.out.println(completeWords.size());
			item = completeWords.get(0).getWordList().get(2);
			x = item.getRow();
			y = item.getColumn();
			_board[x][y].setAlphabet(makeMinorChar());

			completeWords = findCompleteWords(_board);*/


			for(int i = 0 ; (i < 20) && (i < completeWords.size()) ; i++){
				item = completeWords.get(i).getWordList().get(0);
				x = item.getRow();
				y = item.getColumn();
				_board[x][y].setAlphabet(makeRandomChar());
			}

			completeWords = findCompleteWords(_board);

		}
		//System.out.println(debug);
	}

	/**
	 *
	 * @return A random alphabet
	 */
	private char makeRandomChar(){
		Random rnd = new Random();
		int key;
		/*
		key = rnd.nextInt(100) + 1;
		if(key <= 11) return 'E';
		else if(key <= 20) return 'A';
		else if(key <= 28) return 'T';
		else if(key <= 35) return 'I';
		else if(key <= 42) return 'O';
		else if(key <= 49) return 'S';
		else if(key <= 56) return 'N';
		else if(key <= 62) return 'R';
		else if(key <= 66) return 'H';
		else if(key <= 70) return 'L';
		else if(key <= 74) return 'D';
		else if(key <= 77) return 'C';
		else if(key <= 80) return 'U';
		else if(key <= 83) return 'M';
		else if(key <= 85) return 'P';
		else if(key <= 87) return 'F';
		else if(key <= 89) return 'G';
		else if(key <= 91) return 'Y';
		else if(key <= 93) return 'W';
		else if(key <= 94) return 'B';
		else if(key <= 95) return 'V';
		else if(key <= 96) return 'K';
		else if(key <= 97) return 'J';
		else if(key <= 98) return 'X';
		else if(key <= 99) return 'Q';
		else return 'Z';*/



		return (char)(rnd.nextInt(26) + 65);
	}

	private char makeFallChar(){
		Random rnd = new Random();
		int key;

		key = rnd.nextInt(60) + 1;
		if(key <= 4) return 'E';
		else if(key <= 8) return 'A';
		else if(key <= 12) return 'T';
		else if(key <= 16) return 'I';
		else if(key <= 20) return 'O';
		else if(key <= 24) return 'S';
		else if(key <= 26) return 'N';
		else if(key <= 28) return 'R';
		else if(key <= 30) return 'H';
		else if(key <= 32) return 'L';
		else if(key <= 34) return 'D';
		else if(key <= 36) return 'C';
		else if(key <= 38) return 'U';
		else if(key <= 40) return 'M';
		else if(key <= 42) return 'P';
		else if(key <= 44) return 'F';
		else if(key <= 46) return 'G';
		else if(key <= 48) return 'Y';
		else if(key <= 50) return 'W';
		else if(key <= 52) return 'B';
		else if(key <= 54) return 'V';
		else if(key <= 56) return 'K';
		else if(key <= 57) return 'J';
		else if(key <= 58) return 'X';
		else if(key <= 59) return 'Q';
		else return 'Z';
	}
	private char makeMinorChar(){
		Random rnd = new Random();
		int key = rnd.nextInt(14);
		//debug++;
		if(key == 0) return 'U';
		else if(key == 1) return 'M';
		else if(key == 2) return 'P';
		else if(key == 3) return 'F';
		else if(key == 4) return 'G';
		else if(key == 5) return 'Y';
		else if(key == 6) return 'W';
		else if(key == 7) return 'B';
		else if(key == 8) return 'V';
		else if(key == 9) return 'K';
		else if(key == 10) return 'J';
		else if(key == 11) return 'X';
		else if(key == 12) return 'Q';
		else return 'Z';
	}

	/**
	 * Add the location to search location , if the location is not passed
	 * @param passed
	 * @param x
	 * @param y
	 * @param result
	 * @param index
	 * @return
	 */
	private int addLocation(int[][] passed, int x, int y,int[][] result, int index){

		if(checkPassed(passed, x, y)){
			result[0][index] = x;
			result[1][index] = y;
			index++;
		}


		return index;
	}

	/**
	 * check the location is passed ,or not
	 * @param passed
	 * @param x
	 * @param y
	 * @return
	 */
	private boolean checkPassed(int[][] passed ,int x ,int y){

		if(x < 0 || x >= _boardSize || y < 0 || y >= _boardSize ) return false;

		for(int i = 0 ; i <= (MAX_WORD_SIZE - 1) ; i++){
			if((passed[0][i] == x) && (passed[1][i] == y)) return false;
			if((passed[0][i] == -1) && (passed[1][i] == -1)) return true;
		}

		return true;
	}

	/**
	 * make String from linked list that is stored item
	 * @param list
	 * @return
	 */
	private String listToString(LinkedList<Item> list){
		String str = "";

		for(Item item : list){
			str = str + item.getAlphabet();
		}
		return str;
	}

	public Item[][] getBoard(){
		return _board;
	}

	public int[] findAndDeleteWords(){
		int [] result = {0,0};

		for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				if(_board[i][j] == null){
					return result;
				}

			}
		}

		_completeList = findCompleteWords(_board);
		result = deleteWords();

		return result;
	}

	/**
	 * check the board contains the complete words after moving the panel
	 * if found the complete word,that is stored "_completeList"
	 * @param x
	 * @param y
	 * @param toX
	 * @param toY
	 * @return if panel can move ,return true
	 */
	public boolean checkWordIfSwap(int x ,int y, int toX, int toY){
		Item[][] swappedBoard;
		Item temp;

		for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				if(_board[i][j] == null){
					return false;
				}

			}
		}

		swappedBoard  = makeCopyBoard();

		_completeList.clear();
		temp = swappedBoard[x][y];
		swappedBoard[x][y] = swappedBoard[toX][toY];
		swappedBoard[toX][toY] = temp;

		swappedBoard[x][y].setRow(x);
		swappedBoard[x][y].setColumn(y);
		swappedBoard[toX][toY].setRow(toX);
		swappedBoard[toX][toY].setColumn(toY);

		_completeList = findCompleteWords(swappedBoard);
		return !_completeList.isEmpty();
	}

	/**
	 * search the complete words in the board
	 * @param board
	 * @return
	 */
	public LinkedList<CompleteWord> findCompleteWords(Item[][] board) {

		int[][] passed = new int[2][MAX_WORD_SIZE];
		LinkedList<CompleteWord> result = new LinkedList<CompleteWord>();
		LinkedList<Item> wordList = new LinkedList<Item>();



		for(int i = 0 ; i < MAX_WORD_SIZE ; i++){
			passed[0][i] = -1;
			passed[1][i] = -1;
		}

		for(int i = 0; i < _boardSize ; i++){
			for(int j = 0; j < _boardSize ; j++){
				wordList.add(board[i][j]);
				passed[0][0] = i;
				passed[1][0] = j;

				searchCompleteWord(wordList,board,passed,result,_arrayList.getArrayList(board[i][j].getAlphabet()));

				for(int k = 0 ; k < MAX_WORD_SIZE ; k++){
					passed[0][k] = -1;
					passed[1][k] = -1;
				}
				wordList.clear();
			}
		}

		return result;
	}

	/**
	 * search the complete words in the board
	 * @param wordList
	 * @param passed
	 * @param result
	 */
	private void searchCompleteWord(LinkedList<Item> wordList, Item[][] board, int[][] passed,LinkedList<CompleteWord> result,String[] array) {
		int[][] searchLocation = {{-1,-1,-1,-1},{-1,-1,-1,-1}};
		int index = 0 ,row ,column;
		String word;
		int searchResult;

		row = wordList.getLast().getRow();
		column = wordList.getLast().getColumn();

		index = addLocation(passed, row - 1,column,searchLocation,index);
		index = addLocation(passed, row + 1,column,searchLocation,index);
		index = addLocation(passed, row,column - 1,searchLocation,index);
		index = addLocation(passed, row,column + 1,searchLocation,index);

		if(wordList.size() == 10) return ;

		for(int i = 0 ; ( i < 4) && (searchLocation[0][i] != -1) ; i++){
			word = listToString(wordList) + board[searchLocation[0][i]][searchLocation[1][i]].getAlphabet();


			_stComparator.setFlag(false);
			searchResult = Arrays.binarySearch(array, word,_stComparator);

			//if get result
			if(_stComparator.continueSearch() || (searchResult >= 0) ){
				wordList.add(board[searchLocation[0][i]][searchLocation[1][i]]);

				for(int j = 0 ; j < MAX_WORD_SIZE ; j++){
					if(passed[0][j] == -1) {
						passed[0][j] = searchLocation[0][i];
						passed[1][j] = searchLocation[1][i];
						break;
					}
				}

				//if find complete word
				if(searchResult >= 0){
					result.add(new CompleteWord(wordList));

					/*System.out.println(word);

					for(int j = 0; j < wordList.size() ; j++){
						Item item = wordList.get(j);
						System.out.println("i = " + item.getRow() + ", j =" + item.getColumn());
					}*/

					/*for(int j = 0 ; j < MAX_WORD_SIZE ; j++){
						System.out.println("passed :" + passed[0][j] +"," + passed[1][j]);
						if(passed[0][j] == -1) break;
					}*/

					if(!_stComparator.continueSearch()) continue;
				}

				searchCompleteWord(wordList,board,passed,result,array);
				wordList.removeLast();
				passed[0][wordList.size()] = -1;
				passed[1][wordList.size()] = -1;
			}

		}
	}

	/**
	 * swap panel on the board
	 * @param x
	 * @param y
	 * @param toX
	 * @param toY
	 */
	public void swapBoard(int x ,int y, int toX, int toY){
		Item temp;
		boolean noNull = true;

		for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				if(_board[i][j] == null){
					noNull = false;
					break;
				}
			}
			if(!noNull) break;
		}

		if(noNull){

			temp = _board[x][y];
			_board[x][y] = _board[toX][toY];
			_board[toX][toY] = temp;

			_board[x][y].setRow(x);
			_board[x][y].setColumn(y);
			_board[toX][toY].setRow(toX);
			_board[toX][toY].setColumn(toY);

		}

		/*for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				System.out.print(_board[j][i].getAlphabet());
			}
			System.out.println("");
		}
		System.out.println("end");*/
	}

	/**
	 * delete words from the board (word is stored "_completeList")
	 * @return
	 */
	public int[] deleteWords(){
		Item[][] copyBoard;
		int[] score = {0,0};

		for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				if(_board[i][j] == null){
					return score;
				}

			}
		}

		copyBoard  = makeCopyBoard();

		Collections.sort(_completeList,new MyComparator());

		_deleteWords.clear();

		for(int i = 0; i < _completeList.size() ; i++){
			//if(checkDeletable(_completeList.get(i), copyBoard)){
				deleteWord(_completeList.get(i), copyBoard);
				score[0] += _completeList.get(i).getSize();
				score[1]++;
			//}
		}

		_board = copyBoard;

		return score;
	}

	/**
	 * check the word is able to delete
	 * @param word
	 * @param board
	 * @return
	 */
	private boolean checkDeletable(CompleteWord word, Item[][] board){
		LinkedList<Item> wordList = word.getWordList();
		Item item;

		for(int i = 0; i < wordList.size() ; i++){
			item = wordList.get(i);
			if(board[item.getRow()][item.getColumn()] == null) return false;
		}

		return true;

	}

	/**
	 * delete word from the board
	 * @param word
	 * @param board
	 */
	private void deleteWord(CompleteWord word, Item[][] board){
		LinkedList<Item> wordList = word.getWordList();
		Item item;

		//System.out.println(listToString(wordList));
		for(int i = 0; i < wordList.size() ; i++){
			item = wordList.get(i);
			board[item.getRow()][item.getColumn()] = null;
		}

		if(_deleteWords.size() != 0){
			if(!_deleteWords.contains(listToString(wordList))){
				for(int i = 0;i < _deleteWords.size() ; i++){
					if(_deleteWords.get(i).indexOf(listToString(wordList)) == -1){
						//System.out.println(_deleteWords.get(i) + ":" + listToString(wordList));
						_deleteWords.add(listToString(wordList));
						break;
					}
				}
			}
		} else _deleteWords.add(listToString(wordList));


	}

	/**
	 * fill the blank in the board
	 */
	public void fillBoard(){
		boolean flag;

		for(int i = 0 ; i < _boardSize ; i++){
			flag = true;
			for(int j = _boardSize - 1 ; j >= 0 ; j--){
				if(_board[i][j] == null){
					if(flag){
						for(int k = j ; k >= 0 ; k--){
							if(_board[i][k] != null){
								_board[i][j] = _board[i][k];
								_board[i][j].setRow(i);
								_board[i][j].setColumn(j);
								_board[i][k] = null;
								break;
							}

							if(k == 0){
								_board[i][j] = new Item(makeFallChar(),i,j);
								flag = false;
							}
						}
					} else{
						_board[i][j] = new Item(makeFallChar(),i,j);
					}
				}
			}
		}

		/*for(int i = 0; i< _boardSize ; i++){
			for(int j = 0; j< _boardSize ; j++){
				System.out.print(_board[i][j].getRow());
				System.out.print(_board[i][j].getColumn() + " ");
			}
			System.out.println("");
		}*/
	}

	private Item[][] makeCopyBoard(){
		Item[][] copyBoard = new Item[_boardSize][_boardSize];

		for(int i = 0 ; i < _boardSize ; i++){
			for(int j = 0 ; j < _boardSize ; j++){
				copyBoard[i][j] = new Item(_board[i][j].getAlphabet(),_board[i][j].getRow(),_board[i][j].getColumn());
			}
		}

		return copyBoard;
	}

	public ArrayList<String> getDeleteWords(){
		return _deleteWords;
	}
}
