package jp.ac.osaka_u.ist.sel.WordPuzzle;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.WordPuzzle.R;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class GameWindow extends Activity {

	//Define
	private static final int MAX_SCORE = 999999;
	private static final int FUND_SCORE = 1000;
	private static final int MAX_LEVEL = 9;
	private static final int BOARD_SIZE = 8;
	private static final int TIME_ANIMATION = 8; //msec
	private static final int UP = 0;
	private static final int DOWN = 1;
	private static final int LEFT = 2;
	private static final int RIGHT = 3;

	//View Object
	TextView _scoreView;
	TextView _levelView;
	TextView _hintView;
	RelativeLayout _boardView;
	ProgressBar _timebarView;
	AlertDialog.Builder _gameoverDialog;
	AlertDialog.Builder _highScoreDialog;
	AlertDialog.Builder _levelUpDialog;
	BlockView[][] _blockView = new BlockView[BOARD_SIZE][BOARD_SIZE];

	//Instance
	private final Handler _handler   = new Handler();
	private Thread _timeBarThread;
	private DisplayMetrics metrics;
	private Level _level;
	private Score _score;
	private Board _board;
	private TimeBar _timebar;
	private int _blockSize = 0;
	private boolean _stopTimeFlag = false;
	private boolean _canAnimate = true;
	private boolean _endGame = false;
	private boolean _highScore = false;
	private boolean _killThread = false;


	/**
	 * On Create
	 */

	public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.gamewindow);

        //Get Block Size
    	metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		_blockSize = metrics.widthPixels / BOARD_SIZE;

        //Create View
		_scoreView = (TextView)findViewById(R.id.ScoreView);
		_levelView = (TextView)findViewById(R.id.LevelView);
		_hintView =  (TextView)findViewById(R.id.HintBox);
		_timebarView = (ProgressBar)findViewById(R.id.TimeBar);
		_boardView = (RelativeLayout)findViewById(R.id.Board);
		_gameoverDialog = new AlertDialog.Builder(this);
		_levelUpDialog = new AlertDialog.Builder(this);
		_highScoreDialog = new AlertDialog.Builder(this);

		//Detect Touch Event

		final OnTouchListener moving = new OnTouchListener() {
			//@Override
	        public boolean onTouch(View v, MotionEvent event) {
	           	if(event.getAction() == MotionEvent.ACTION_DOWN ){
	                return true;
	            }else if( event.getAction() == MotionEvent.ACTION_MOVE){
	            	if(event.getX()<=0){
	                   	swap(v,LEFT);
	                }else if(event.getY()<=0){
	                   	swap(v,UP);
	                }else if(event.getX()>=_blockSize){
	                   	swap(v,RIGHT);
	                }else if(event.getY()>=_blockSize){
	                   	swap(v,DOWN);
	                }
	             }
	             return false;
	         }
	     };

	    //Create Board
    	int id = 0;
		for(int j=0; j<BOARD_SIZE; j++){
			for(int i=0; i<BOARD_SIZE; i++){
				_blockView[i][j] = new BlockView(this);
				_blockView[i][j].setOnTouchListener(moving);
				_blockView[i][j].setOperateFlag(false);
				_blockView[i][j].setId(++id);
				RelativeLayout.LayoutParams param = new RelativeLayout.LayoutParams(_blockSize,_blockSize);
				if(i>0 && j==0){
					param.addRule(RelativeLayout.RIGHT_OF,id-1);
				}else if( i==0 && j>0 ){
					param.addRule(RelativeLayout.BELOW,id-BOARD_SIZE);
				}else if( i>0 && j>0 ){
					param.addRule(RelativeLayout.BELOW,id-BOARD_SIZE);
					param.addRule(RelativeLayout.RIGHT_OF,id-1);
				}
				_boardView.addView(_blockView[i][j],param);

			}
		}

		//Start Game:
		startGame();

    }


	/**
	 * Start Game
	 */
	private void startGame(){

		_level = new Level(MAX_LEVEL);
	 	_score = new Score(MAX_SCORE);

		displayScoreView();
		displayLevelView();

	 	_board = new Board(this,BOARD_SIZE);
    	_timebar = new TimeBar(_level.getLevel());
    	_timebarView.setMax(_timebar.getMaxTime());

    	_timeBarThread = new Thread(new Runnable(){
			public void run() {
				manageTime();
			}
		});

		displayBoard();
		_timeBarThread.start();
	}

	/**
	 * Update Score;
	 */
	private void updateScore(int panelNum, int wordNum, int chain){
		if (_endGame == false) {
			_score.calcScore(panelNum, wordNum, chain);
			_timebar.updateTime(panelNum);
			displayScoreView();
			_handler.post(new Runnable() {
				public void run(){
					_timebarView.setProgress(_timebar.getTime());
				}
			});
		}
	}

	/**
	 * Check Level;
	 */
	private boolean checkLevelUp(){

		boolean f = false;
		int score = _score.getScore();
		for(int i=_level.getLevel(); i<=MAX_LEVEL; i++){
			if(score >= FUND_SCORE*i*i){
				_level.levelUp();
				f = true;
			}
		}
		return f;

	}


	/**
	 * Update Level;
	 */
	private void updateLevel(){
		displayLevelView();
		_stopTimeFlag = true;
		_handler.post(new Runnable() {
			public void run(){
				_levelUpDialog.setTitle("LEVEL UP");
				_levelUpDialog.setCancelable(false);
				_levelUpDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						_timebar = new TimeBar(_level.getLevel());
						_timebarView.setMax(_timebar.getMaxTime());
						_stopTimeFlag = false;
						_canAnimate = true;
						displayBoard();
						dialog.cancel();
					}
				});
				_levelUpDialog.create().show();
			}
		});
	}

	/**
	 * Game Over
	 */
	private void endGame(){
		_endGame = true;
		final EditText edit = new EditText(this);
        edit.setWidth(50);

        try {
        	FileInputStream inf = openFileInput("log.txt");
        	byte[] buffer = new byte[1000];
        	try {
				inf.read(buffer);
			} catch (IOException e) {
				e.printStackTrace();
			}
        	String str = new String(buffer).trim();

        	if(!str.matches("")){
        		String[] tmp = str.split(",");
        		System.out.println(tmp[1]);

        		if(Integer.parseInt(tmp[1])<_score.getScore()){
        			_highScore = true;
        		}else{
        			_highScore = false;
        		}
        	} else _highScore = true;
        } catch (FileNotFoundException e1) {
        	_highScore = true;
        }

		_gameoverDialog.setTitle("GAME OVER");
		_gameoverDialog.setMessage("SCORE:"+_score.getScore());


		if(_highScore){
			_highScoreDialog.setTitle("HIGHSCORE");
			_highScoreDialog.setMessage("Input Name");
			_highScoreDialog.setView(edit);
			_highScoreDialog.setCancelable(false);
			_highScoreDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
				//@Override
				public void onClick(DialogInterface dialog, int which) {
					FileOutputStream fileOutputStream;
					try {
						fileOutputStream = openFileOutput("log.txt", MODE_PRIVATE);
						int maxLength = 10;
						if(edit.getText().length() < 10) maxLength = edit.getText().length();
						String str = edit.getText().toString().substring(0,maxLength)+','+Integer.toString(_score.getScore())+','+Integer.toString(_level.getLevel());
						fileOutputStream.write(str.getBytes());
						setResult(RESULT_CANCELED);
					} catch (IOException e) {
						e.printStackTrace();
					}
		            finish();
				}
			});
		}
		_gameoverDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				if(_highScore){
					_highScoreDialog.create().show();
				}else{
					finish();
				}
			}
		});
		_gameoverDialog.setCancelable(false);
		_gameoverDialog.create().show();
	}
	/**
	 * swap Block
	 *  @param v - image
	 *  @param direction
	 */

	private void swap(View v,final int direction){

		final int X = (v.getId()-1)%BOARD_SIZE;
		final int Y = (v.getId()-1)/BOARD_SIZE;
		int toX=0,toY=0,oppositeDirection=0;
		boolean canSwap = false;

		if(_canAnimate){
			switch(direction){
				case LEFT:
					toX = X-1; toY = Y;
					oppositeDirection = RIGHT;
					canSwap = (X>0) && !_blockView[X][Y].getOperateFlag() &&!_blockView[toX][toY].getOperateFlag();
					break;
				case RIGHT:
					toX = X+1; toY = Y;
					oppositeDirection = LEFT;
					canSwap = (X<(BOARD_SIZE-1))&& !_blockView[X][Y].getOperateFlag() &&!_blockView[toX][toY].getOperateFlag();
					break;
				case UP:
					toX = X; toY = Y-1;
					oppositeDirection = DOWN;
					canSwap = (Y>0)&& !_blockView[X][Y].getOperateFlag() &&!_blockView[toX][toY].getOperateFlag();
					break;
				case DOWN:
					toX = X; toY = Y+1;
					oppositeDirection = UP;
					canSwap = (Y<(BOARD_SIZE-1))&&!_blockView[X][Y].getOperateFlag() &&!_blockView[toX][toY].getOperateFlag();
					break;
				default:
			}

			if(canSwap){

				_canAnimate = false;


				_blockView[X][Y].setOperateFlag(true);
				_blockView[toX][toY].setOperateFlag(true);
				final int toX_ = toX;
				final int toY_ = toY;
				final int oppositeDirection_ = oppositeDirection;

				if(_board.checkWordIfSwap(X,Y,toX,toY)){

					_stopTimeFlag = true;

					final Thread th1 = new Thread(new Runnable(){
						public void run() {
							moveAnimation(X,Y,direction);
						}
					});
					final Thread th2 = new Thread(new Runnable(){
						public void run() {
							moveAnimation(toX_,toY_,oppositeDirection_);
						}
					});
					th1.start(); th2.start();

					final Thread th3 = new Thread(new Runnable(){
						public void run() {
							try {
								th1.join();	th2.join();
								_board.swapBoard(X,Y,toX_,toY_);
								displayBoard();

								int chain = 0;
								int[] score = _board.deleteWords();
								displayWord();
								deleteAnimation();

								_board.fillBoard();
								displayBoard();

								boolean f = true;
								updateScore(score[0],score[1],chain);

								while(f){
									score = _board.findAndDeleteWords();
									if(score[0]==0){
										f=false;
									}else{
										displayWord();
										deleteAnimation();
										_board.fillBoard();
										displayBoard();
										updateScore(score[0],score[1],++chain);
									}
								}

								_canAnimate = true;
								_stopTimeFlag = false;
								if(checkLevelUp())
									updateLevel();

							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
					});
					th3.start();

				}else{

					final Thread th1 = new Thread(new Runnable(){
						public void run() {
							moveAnimation(X,Y,direction);
						}
					});
					final Thread th2 = new Thread(new Runnable(){
						public void run() {
							moveAnimation(toX_,toY_,oppositeDirection_);
						}
					});
					th1.start(); th2.start();

					final Thread th = new Thread(new Runnable(){
						public void run() {
							try {
								th1.join();	th2.join();
								_board.swapBoard(X,Y,toX_,toY_);
								displayBoard();
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
					});
					th.start();

					final Thread th3 = new Thread(new Runnable(){
						public void run() {
							try {
								th.join();
								moveAnimation(X,Y,direction);
							} catch (InterruptedException e) {
								e.printStackTrace();
							}

						}
					});

					final Thread th4 = new Thread(new Runnable(){
						public void run() {
							try {
								th.join();
								moveAnimation(toX_,toY_,oppositeDirection_);
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
					});
					th3.start(); th4.start();

					final Thread th_ = new Thread(new Runnable(){
						public void run() {
							try {
								th3.join();	th4.join();
								_board.swapBoard(X,Y,toX_,toY_);
								displayBoard();
								_canAnimate = true;
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
					});
					th_.start();
				}
			}
		}

	}

	/**
	 * Move Block Animation
	 * @param x - move block x
	 * @param y - move block y
	 * @param direction
	 */
	private void moveAnimation(final int x, final int y, final int direction){
		int diff=0;
		final BlockView v = _blockView[x][y];
		while(diff<=_blockSize){
			try {
				final int tmp = diff++;
				Thread.sleep(TIME_ANIMATION);
				_handler.post(new Runnable() {
					public void run(){
						switch(direction){
						case LEFT:
							v.layout(x*_blockSize-tmp,y*_blockSize,(x+1)*_blockSize-tmp,(y+1)*_blockSize);
							break;
						case RIGHT:
							v.layout(x*_blockSize+tmp,y*_blockSize,(x+1)*_blockSize+tmp,(y+1)*_blockSize);
							break;
						case UP:
							v.layout(x*_blockSize,y*_blockSize-tmp,(x+1)*_blockSize,(y+1)*_blockSize-tmp);
							break;
						case DOWN:
							v.layout(x*_blockSize,y*_blockSize+tmp,(x+1)*_blockSize,(y+1)*_blockSize+tmp);
							break;
						}
						v.forceLayout();
					}
				});
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Delete Block Animation
	 * @param x - delete block x
	 * @param y - delete block y
	 */
	private void deleteAnimation(){

		final BlockView[][] v = _blockView;
		final Item[][] item = _board.getBoard();
		final int time = TIME_ANIMATION*20;

		try {
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete1);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete2);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete3);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete4);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete5);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(R.drawable.delete6);
						}
					}
				}
			});
			Thread.sleep(time);
			_handler.post(new Runnable() {
				public void run(){
					for(int x=0; x<BOARD_SIZE; x++){
						for(int y=0; y<BOARD_SIZE; y++){
							if(item[x][y] ==null)
								v[x][y].setImageResource(0);
						}
					}
				}
			});
			Thread.sleep(time);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Display Board
	 */
	private void displayBoard(){

		Item[][] item = new Item[BOARD_SIZE][BOARD_SIZE];

		item = _board.getBoard();

		for(int j=0; j<BOARD_SIZE; j++){
			for(int i=0; i<BOARD_SIZE; i++){
				final int x=i,y=j;
				if(item[i][j]!=null){
					final char alphabet = item[i][j].getAlphabet();
					_handler.post(new Runnable() {
						public void run(){
							switch(alphabet){
								case 'A': _blockView[x][y].setImageResource(R.drawable.block_a); break;
								case 'B': _blockView[x][y].setImageResource(R.drawable.block_b); break;
								case 'C': _blockView[x][y].setImageResource(R.drawable.block_c); break;
								case 'D': _blockView[x][y].setImageResource(R.drawable.block_d); break;
								case 'E': _blockView[x][y].setImageResource(R.drawable.block_e); break;
								case 'F': _blockView[x][y].setImageResource(R.drawable.block_f); break;
								case 'G': _blockView[x][y].setImageResource(R.drawable.block_g); break;
								case 'H': _blockView[x][y].setImageResource(R.drawable.block_h); break;
								case 'I': _blockView[x][y].setImageResource(R.drawable.block_i); break;
								case 'J': _blockView[x][y].setImageResource(R.drawable.block_j); break;
								case 'K': _blockView[x][y].setImageResource(R.drawable.block_k); break;
								case 'L': _blockView[x][y].setImageResource(R.drawable.block_l); break;
								case 'M': _blockView[x][y].setImageResource(R.drawable.block_m); break;
								case 'N': _blockView[x][y].setImageResource(R.drawable.block_n); break;
								case 'O': _blockView[x][y].setImageResource(R.drawable.block_o); break;
								case 'P': _blockView[x][y].setImageResource(R.drawable.block_p); break;
								case 'Q': _blockView[x][y].setImageResource(R.drawable.block_q); break;
								case 'R': _blockView[x][y].setImageResource(R.drawable.block_r); break;
								case 'S': _blockView[x][y].setImageResource(R.drawable.block_s); break;
								case 'T': _blockView[x][y].setImageResource(R.drawable.block_t); break;
								case 'U': _blockView[x][y].setImageResource(R.drawable.block_u); break;
								case 'V': _blockView[x][y].setImageResource(R.drawable.block_v); break;
								case 'W': _blockView[x][y].setImageResource(R.drawable.block_w); break;
								case 'X': _blockView[x][y].setImageResource(R.drawable.block_x); break;
								case 'Y': _blockView[x][y].setImageResource(R.drawable.block_y); break;
								case 'Z': _blockView[x][y].setImageResource(R.drawable.block_z); break;
								default : _blockView[x][y].setImageResource(R.drawable.block); break;
							}
						}
					});
				}
				_handler.post(new Runnable(){
					public void run() {
						_blockView[x][y].setOperateFlag(false);
						_blockView[x][y].layout(x*_blockSize,y*_blockSize,(x+1)*_blockSize,(y+1)*_blockSize);
					}
				});
			}
		}
	}

	/**
	 * Score Level
	 */
	private void displayScoreView(){
		_handler.post(new Runnable() {
			public void run(){
					_scoreView.setText("SCORE:"+_score.getScore());
			}
		});
	}

	/**
	 * Display Word
	 */
	private void displayWord(){
		ArrayList<String> str = _board.getDeleteWords();
		String word = str.get(0);
		for(int i=1; i<str.size(); i++){
			word = word + '/' + str.get(i);
		}

		final String  tmp = word;
		_handler.post(new Runnable() {
			public void run(){
				_hintView.setText("DELETE:"+ tmp.toLowerCase());
			}
		});
	}

	/**
	 * Display Level
	 */
	private void displayLevelView(){
		_handler.post(new Runnable() {
			public void run(){
					_levelView.setText("Lv."+_level.getLevel());
			}
		});
	}

	/**
	 * Manage Time & Display TimeBar
	 */
	private void manageTime(){

		boolean gameOverFlag = false;

		while(!gameOverFlag && !_killThread){
			if(!_stopTimeFlag){
				gameOverFlag = !_timebar.timeDecrement();
				try {
					Thread.sleep(1);
					final int time = _timebar.getTime();
					_handler.post(new Runnable() {
						public void run(){
							_timebarView.setProgress(time);
						}
					});
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}

		if(!_killThread){
			_handler.post(new Runnable() {
				public void run(){
					endGame();
				}
			});
		}
	}


	public boolean onKeyDown(int keyCode, KeyEvent event) {
	    if(keyCode == KeyEvent.KEYCODE_BACK){
	    	_killThread = true;
	    	finish();
	    }
		return true;
	}
}
