package jp.ac.osaka_u.ist.sel.WordPuzzle;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import jp.ac.osaka_u.ist.sel.WordPuzzle.R;
import jp.ac.osaka_u.ist.sel.WordPuzzle.WordPuzzleActivity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class WordPuzzleActivity extends Activity {

	final static int END_GAME = 0;
	TextView highScoreView;
	TextView nameView;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        highScoreView = (TextView)findViewById(R.id.highscoreview);
        nameView = (TextView)findViewById(R.id.nameview);

        //Display HighScore
        try {
        	FileInputStream inf = openFileInput("log.txt");
        	byte[] buffer = new byte[1000];

        	try {
				inf.read(buffer);
				String str = new String(buffer).trim();
				if(!str.matches("")){
	        		String[] tmp = str.split(",");
	        		if(tmp[0]==null){
	        			tmp[0] = "unknown";
	        		}else{
	        			tmp[0] = tmp[0].replace("\n"," ");
	        		}
	        		highScoreView.setText("HIGHSCORE:"+tmp[1]);
  	        		int maxLength = 10;
	        		if(tmp[0].length() < 10 ) maxLength = tmp[0].length();
	        		nameView.setText("(NAME:"+tmp[0].substring(0,maxLength)+")");

	        	} else {
	        		highScoreView.setText("HIGHSCORE: none");
	        		nameView.setText("(NAME: none)");
	        	}
			} catch (IOException e) {
				e.printStackTrace();
			}
        } catch (FileNotFoundException e1) {
        	highScoreView.setText("NO DATA");
        }

        //Create StartGame Button
        ImageView startButton = (ImageView)findViewById(R.id.start);
        startButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				Intent game = new Intent(WordPuzzleActivity.this,jp.ac.osaka_u.ist.sel.WordPuzzle.GameWindow.class);
		   		startActivityForResult(game,END_GAME);

			}
		});

        //Create Exit Button
        ImageView exitButton = (ImageView)findViewById(R.id.exit);
        exitButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				finish();
			}
		});

    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == END_GAME) {
            try {
            	FileInputStream inf = openFileInput("log.txt");
            	byte[] buffer = new byte[1000];

            	try {
    				inf.read(buffer);
    				String str = new String(buffer).trim();
    				if(str!=null){
    					String[] tmp = str.split(",");
    	        		if(tmp[0]==null){
    	        			tmp[0] = "unknown";
    	        		}else{
    	        			tmp[0] = tmp[0].replace("\n"," ");
    	        		}
    	        		highScoreView.setText("HIGHSCORE:"+tmp[1]);
    	        		int maxLength = 10;
    	        		if(tmp[0].length() < 10 ) maxLength = tmp[0].length();
    	        		nameView.setText("(NAME:"+tmp[0].substring(0,maxLength)+")");
    	        	}
    			} catch (IOException e) {
    				e.printStackTrace();
    			}
            } catch (FileNotFoundException e1) {
            	highScoreView.setText("NO DATA");
            }
        }
    }



}