package jp.ac.osaka_u.ist.sel.picturepuzzle;

import java.io.FileInputStream;
import java.io.ObjectInputStream;

import jp.ac.osaka_u.ist.sel.picturepuzzle.R;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class AndroidProject1Activity extends Activity implements OnClickListener{

	private final int WC = ViewGroup.LayoutParams.WRAP_CONTENT;
	private final int FP = ViewGroup.LayoutParams.FILL_PARENT;
	private final int UPPER_LIMIT = 9999;

	Button newgame;
	Button exit;
	RankingData rd;
	TextView tv[];


	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		rd=null;


		String name[];
		int	chan[];
		int tim[];


// Open Serializable Ranking Data
		RankingData rd;


		try {
			FileInputStream rankfile = openFileInput("ranking");
			ObjectInputStream rank = new ObjectInputStream(rankfile);
			rd = (RankingData) rank.readObject();
			rank.close();
		} catch (Exception e) {
			rd = new RankingData();
			System.out.println(e);
		}



// Write Ranking Data
		name= new String[16];
		chan=new int[16];
		tim=new int[16];
		if(rd!=null){
			name=rd.getName();
			chan=rd.getChange();
			tim=rd.getTime();
		}else{
			for(int j=0;j<16;j++){name[j]=null;}
		}

		TableLayout tl = (TableLayout) findViewById(R.id.TableLayout);
		createTableLayout(tl,name,chan,tim);

// Button
		Button newgame =  (Button)findViewById(R.id.button1);
		Button exit =  (Button)findViewById(R.id.button2);

		newgame.setOnClickListener(this);
		exit.setOnClickListener(this);

		LinearLayout.LayoutParams l = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT,60);
		l.gravity = Gravity.CENTER_HORIZONTAL;
		newgame.setLayoutParams(l);
		exit.setLayoutParams(l);

	}


	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
	super.onWindowFocusChanged(hasFocus);
	if(hasFocus) {
		// Write Title

		RelativeLayout r=(RelativeLayout)findViewById(R.id.main);
		int height=r.getHeight();

		ScrollView s=(ScrollView)findViewById(R.id.scrollView1);
		height=height-s.getHeight();
		LinearLayout l = (LinearLayout)findViewById(R.id.under);
		height=height-l.getHeight();
		TextView t = (TextView) findViewById(R.id.textView1);
		if(height>t.getHeight()){t.setHeight(height);}
	}
	}


//create Ranking table
	private void createTableLayout(TableLayout tl,String name[],int change[],int time[]) {

		tv=new TextView[64];
		TableRow tableRow;

		TextView t = (TextView)findViewById(R.id.textView11);
		t.setText("Best Records");

		TableRow.LayoutParams layoutParams = new TableRow.LayoutParams();
		layoutParams.span=3;
		tableRow = new TableRow(this);

		t = new TextView(this);
		t.setText("Move Records");
		t.setTextColor(Color.WHITE);
		t.setGravity( Gravity.CENTER );
		tableRow.addView(t,layoutParams);

		t = new TextView(this);
		t.setText(" ");
		tableRow.addView(t);

		t = new TextView(this);
		t.setText("Time Records");
		t.setTextColor(Color.WHITE);
		t.setGravity( Gravity.CENTER );
		tableRow.addView(t,layoutParams);

		tl.addView(tableRow, new TableLayout.LayoutParams(FP, WC));

		for(int j=0;j<64;j++){
			tv[j]=new TextView(this);
			tv[j].setGravity( Gravity.CENTER );
			tv[j].setTextColor(Color.WHITE);
		}

		tv[0].setText("  Name  ");
		tv[1].setText("  Move ");
		tv[2].setText("  Time  ");
		tv[3].setText("     ");
		tv[4].setText("  Name  ");
		tv[5].setText("  Move  ");
		tv[6].setText("  Time  ");

		for(int j=1;j<9;j++){
			int k=7*j;
			int chan,tim;
			if(name[j-1]!=null){
				tv[k].setText(name[j-1]);
				tv[k+4].setText(name[j+7]);

				if(change[j-1]>=UPPER_LIMIT){chan=UPPER_LIMIT;}else{chan=change[j-1];}
				if(time[j-1]>=UPPER_LIMIT){tim=UPPER_LIMIT;}else{tim=time[j-1];}

				tv[k+1].setText(String.valueOf(chan));
				tv[k+2].setText(String.valueOf(tim));

				if(change[j+7]>=UPPER_LIMIT){chan=UPPER_LIMIT;}else{chan=change[j+7];}
				if(time[j+7]>=UPPER_LIMIT){tim=UPPER_LIMIT;}else{tim=time[j+7];}

				tv[k+5].setText(String.valueOf(chan));
				tv[k+6].setText(String.valueOf(tim));

			}else{
				tv[k].setText("---");tv[k+1].setText("----");tv[k+2].setText("----");
				tv[k+4].setText("---");tv[k+5].setText("----");tv[k+6].setText("----");
			}
			tv[k+3].setText((j+1)+"*"+(j+1));
		}


		for(int i=0;i<9;i++){
			tableRow = new TableRow(this);
			for(int k=0;k<7;k++){tableRow.addView(tv[i*7+k]);}
			tl.addView(tableRow, new TableLayout.LayoutParams(FP, WC));

		}

	}

//Button Click
	public void onClick(View v) {

		switch(v.getId()){
		case R.id.button1:
			Intent intent = new Intent();
			intent.setClassName("jp.ac.osaka_u.ist.sel.picturepuzzle", "jp.ac.osaka_u.ist.sel.picturepuzzle.SecondActivity2");
			startActivity(intent);
			break;
		case R.id.button2:
			finish();
		default:	break;
		}

	}


}