package jp.ac.osaka_u.ist.sel.picturepuzzle;

import java.io.Serializable;

import android.util.Log;

public class RankingData implements Serializable {

	private String name[];
	private int time[];
	private int change[];
	
	public RankingData() {
		name = new String[16];
		time = new int[16];
		change = new int[16];
		for (int i = 0; i < 16; i++) {
			time[i] = Integer.MAX_VALUE;
			change[i] = Integer.MAX_VALUE;
		}
	}
	
	public void setRecord(String name, int time, int change, int n) {
		if (change < this.change[n-2]) {
			this.change[n-2] = change;
			this.time[n-2] = time;
			this.name[n-2] = name.toString();
			Log.d("Rec", "name[" + (n-2) + "] = " + this.name[n-2]);
		}
		if (time < this.time[n+6]) {
			this.time[n+6] = time;
			this.change[n+6] = change;
			this.name[n+6] = name.toString();
		}
	}
	
	public boolean isNewRecord(int time, int change, int n) {
		if (change < this.change[n-2]) return true;
		if (time < this.time[n+6]) return true;
		return false;
	}
	
	public String[] getName() {
		return name;
	}
	
	public String getName(int i) {
		return name[i];
	}
	
	public int[] getTime() {
		return time;
	}
	
	public int getTime(int i) {
		return time[i];
	}
	
	public int[] getChange() {
		return change;
	}
	
	public int getChange(int i) {
		return change[i];
	}
}
