package jp.ac.osaka_u.ist.sel.picturepuzzle;

import java.io.File;
import java.util.List;

import jp.ac.osaka_u.ist.sel.picturepuzzle.R;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;

@SuppressLint("DrawAllocation")
public class GameView extends View implements SensorEventListener {

	private final ThirdActivity game;
	private Paint paint = new Paint();
	private Paint paint1 = new Paint();
	private int width,height;
	private boolean victory=false;
	private boolean hint = false;
	private int shuffle=0;
	private int sensorCount = 0;
	private int changeCount = 0;
	private long start;
	private long end;

	private int n;
	private int empty;
	private int table[][];

	private int pic_width;
	private int pic_height;
	private int pic_xunit;
	private int pic_yunit;
	private float pointX = 0.0f, pointY = 0.0f;
	private float downX = 0.0f, downY = 0.0f;
	private int selectX = 0, selectY = 0;
	private boolean showHint = true;
	private boolean finish = false;
	private Paint p;
	private int textSize;

	// instance for shuffle
	private SensorManager manager;
	private float[] currentOrientationValues = {0.0f, 0.0f};
	private float[] currentAccelerationValues = {0.0f, 0.0f};
	private final float limit = 4.0f;
	private final int shakeMin;
	private float[] speed = {0.0f, 0.0f};
	private long time;

	private Resources res = this.getContext().getResources();
	private Bitmap pic;

	public GameView(Context context,int source,String str,int bunkatsu, SensorManager manager) {
		super(context);
		this.game=(ThirdActivity) context;		
		setFocusable(true);
		setFocusableInTouchMode(true);

		switch(source){
		case 0:
			File imgfile = new File(str);
			if(imgfile.exists()){
				// 摜ǂݍ݂ɂ郁ӂ΍
				BitmapFactory.Options options = new BitmapFactory.Options();
				options.inJustDecodeBounds = true;
				BitmapFactory.decodeFile(imgfile.getAbsolutePath(), options);
				int scaleW = options.outWidth/380;
				int scaleH = options.outHeight/420;
				// scale1ɐݒ
				int scale = Math.max(scaleW, scaleH);
				if (scale <= 0) scale = 1;
				options.inJustDecodeBounds = false;
				options.inSampleSize = scale;
				
				// 摜kēǂݍ
				pic = BitmapFactory.decodeFile(imgfile.getAbsolutePath(), options);
			}
			break;
		case 1:
			pic = BitmapFactory.decodeResource(res, R.drawable.sampleimage1small);
			break;
		case 2:
			pic = BitmapFactory.decodeResource(res, R.drawable.sampleimage2small);
			break;
		}

		n=bunkatsu;
		empty = n*n - 1;
		shakeMin = (n == 9) ? 10000 : n*n*10 + 30;

		width = game.width;
		height = game.height;

		textSize = (width < height) ? width : height;
		
		table=new int[n][n];

		pic_width=pic.getWidth();
		pic_height=pic.getHeight();
		pic_xunit=pic_width/n;
		pic_yunit=pic_height/n;

		setColor();
		
		init();
		this.manager = manager;
	}

	private void setColor() {
		int width = pic_width / 5;
		int height = pic_height / 5;
		Log.d("Pic", "width = " + width + "  height = " + height);
		int count = 0;
		int white = 0;
		
		p = new Paint();

		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				int pixel = pic.getPixel(x*5, y*5);
				int red = (pixel & 0x00FF0000) >> 16;
				int green = (pixel & 0x0000FF00) >> 8;
				int blue = (pixel & 0x000000FF);
				//Log.d("Color", "red = " + red + " green = " + green + " blue = " + blue);
				//if (red >= 154 && (green <= 51 || blue <= 76))
				if ((red >= green*3 && green >= 13) || (red >= blue*3 && blue >= 13))
				//if ((red >= green*3 && red > blue) || (red >= blue*3 && red > green))
					count++;
				else if (red >= 250 && green >= 250 && blue >= 250)
					white++;
			}
		}
		
		Log.d("Count", "count = " + count + " white = " + white + " all = " + width*height);
		if (count > width*height/5 || count > width*height/3-white)
			p.setARGB(255, 0, 255, 0);
		else
			p.setARGB(255, 255, 0, 0);
	}
	
	public void setEmptyValue(int empty) {
		this.empty = empty;
	}
	
	public void setShuffle(int shuffle) {
		this.shuffle = shuffle;
	}
	
	public void setTable(int[] val, int i) {
		table[i] = val;
	}
	
	public void setSensorCount(int sc) {
		sensorCount = sc;
	}
	
	public void setChangeCount(int cc) {
		changeCount = cc;
	}
	
	public void setHint(boolean hint) {
		this.hint = hint;
	}
	
	public void setVictory(boolean victory) {
		this.victory = victory;
	}
	
	public void setStartTime(long st) {
		start = st;
	}
	
	public void setEndTime(long et) {
		end = et;
	}
	
	public void setFinish(boolean finish) {
		this.finish = finish;
	}
	
	public void refresh() {
		invalidate();
	}
	
	public int getEmptyValue() {
		return empty;
	}
	
	public int getShuffle() {
		return shuffle;
	}
	
	public int[] getTable(int i) {
		return table[i];
	}
	
	public int getN() {
		return n;
	}
	
	public int getSensorCount() {
		return sensorCount;
	}
	
	public int getChangeCount() {
		return changeCount;
	}
	
	public boolean getHint() {
		return hint;
	}
	
	public boolean getVictory() {
		return victory;
	}
	
	public long getStartTime() {
		return start;
	}
	
	public long getEndTime() {
		return end;
	}
	
	public boolean getFinish() {
		return finish;
	}
	
	private void init(){
		for(int a=0;a<n;a++)
			for(int b=0;b<n;b++)
				table[a][b]=n*a+b;        		
		table[n-1][n-1]=-1;
	}

	public int getTime() {
		return (int) ((end-start) / 1000);
	}
	
	public int getChange() {
		return changeCount;
	}
	
	public void onDraw(Canvas c){
		int ts = textSize/(10+n) - 5;
		p.setTextSize(ts);
		p.setAntiAlias(true);

		int xunit=width/n;
		int yunit=height/n;

		int diffX = (int)(pointX-downX);
		if (diffX > xunit)
			diffX = xunit;
		else if (-diffX > xunit) 
			diffX = -xunit;
		
		int diffY = (int)(pointY-downY);
		if (diffY > yunit)
			diffY = yunit;
		else if (-diffY > yunit) 
			diffY = -yunit;

		int x;
		for(int a=0;a<n;a++){
			for(int b=0;b<n;b++){
				x=table[a][b];
				if (x != -1) {
					Rect dst;
					if (a == selectY && b == selectX) {
						switch (getEmpty(a, b)) {
						case 'U':
							if (diffY > 0) diffY = 0;
							dst = new Rect(b*xunit, a*yunit+diffY, b*xunit+xunit, a*yunit+yunit+diffY);
							c.drawRect(b*xunit, a*yunit-yunit, b*xunit+xunit, a*yunit+yunit+diffY, paint1);
							c.drawRect(b*xunit, a*yunit+yunit+diffY, b*xunit+xunit, a*yunit+yunit, paint1);
							diffX = 0;
							break;
						case 'D':
							if (diffY < 0) diffY = 0;
							dst = new Rect(b*xunit, a*yunit+diffY, b*xunit+xunit, a*yunit+yunit+diffY);
							c.drawRect(b*xunit, a*yunit, b*xunit+xunit, a*yunit+diffY, paint1);
							c.drawRect(b*xunit, a*yunit+yunit+diffY, b*xunit+xunit, (a+2)*yunit, paint1);
							diffX = 0;
							break;
						case 'L':
							if (diffX > 0) diffX = 0;
							dst = new Rect(b*xunit+diffX, a*yunit, b*xunit+xunit+diffX, a*yunit+yunit);
							c.drawRect(b*xunit, a*yunit, b*xunit+(xunit+diffX), a*yunit+yunit, paint1);
							c.drawRect(b*xunit+(xunit+diffX)+xunit, a*yunit, (b+2)*xunit, a*yunit+yunit, paint1);
							diffY = 0;
							break;
						case 'R':
							if (diffX < 0) diffX = 0;
							dst = new Rect(b*xunit+diffX, a*yunit, b*xunit+xunit+diffX, a*yunit+yunit);
							c.drawRect(b*xunit, a*yunit, b*xunit+diffX, a*yunit+yunit, paint1);
							c.drawRect(b*xunit+(xunit+diffX)+xunit, a*yunit, (b+2)*xunit, a*yunit+yunit, paint1);
							diffY = 0;
							break;
						default:
							dst=new Rect((b*xunit),(a*yunit),(b*xunit+xunit),(a*yunit+yunit));
						}
					}
					else {
						dst=new Rect((b*xunit),(a*yunit),(b*xunit+xunit),(a*yunit+yunit));
					}

					Rect src=new Rect((x%n*pic_xunit),(x/n*pic_yunit),(x%n*pic_xunit+pic_xunit),(x/n*pic_yunit+pic_yunit));

					c.drawBitmap(pic,src, dst, paint);
					
					// 摜̔ԍyCg
					if (!victory && hint) {
						if (x+1 < 10)
							if (a == selectY && b == selectX)
								c.drawText(Integer.toString(x+1), b*xunit+xunit/2-xunit/20+diffX, a*yunit+yunit/2+ts/6+diffY, p);
							else
								c.drawText(Integer.toString(x+1), b*xunit+xunit/2-xunit/20, a*yunit+yunit/2+ts/6, p);
						else
							if (a == selectY && b == selectX)
								c.drawText(Integer.toString(x+1), b*xunit+xunit/2-xunit/20+diffX, a*yunit+yunit/2+ts/6+diffY, p);
							else
								c.drawText(Integer.toString(x+1), b*xunit+xunit/2-xunit/10, a*yunit+yunit/2+ts/6, p);
					}
					
				} else {
					switch (shuffle) {
					case 0:
						c.drawText("OK", b*xunit+xunit/3, a*yunit+yunit/2+ts/4, p);
						break;
					case 2:
						if (showHint) {
							if (hint)
								c.drawText("HIDE", b*xunit+xunit/2-ts, a*yunit+yunit/2+ts/4, p);
							else
								c.drawText("HINT", b*xunit+xunit/2-ts, a*yunit+yunit/2+ts/4, p);
						}
						break;
					}
				}
			}
		}

		if (shuffle == 0) {
			for (int i = 0; i <= n; i++)
				c.drawLine(0, i*yunit, width, i*yunit, p);
			for (int i = 0; i <= n; i++)
				c.drawLine(i*xunit, 0, i*xunit, height, p);
		}

		if (shuffle == 1) {
			p.setTextSize(textSize/10);
			if (sensorCount >= shakeMin)
				c.drawText("Touch to Start!", width/5, height/2, p);
			else
				c.drawText("Shake! " + Integer.toString(shakeMin-sensorCount), width/5, height/2, p);
		}

		if (victory && !finish) {
			Toast toast = Toast.makeText(game, "Touch the Screen!", Toast.LENGTH_SHORT);
			toast.show();
		}

	}	

	private char getEmpty(int y, int x) {
		if (x == empty%n) {
			if (y-1 == empty/n) return 'U';
			if (y+1 == empty/n) return 'D';
			return 'E';
		}
		if (y == empty/n) {
			if (x-1 == empty%n) return 'L';
			if (x+1 == empty%n) return 'R';
		}
		return 'E';
	}
	
	public boolean onTouchEvent(MotionEvent event){
		float x=event.getX();
		float y=event.getY();
		int xunit=width/n;
		int yunit=height/n;
		int i=(int)x/xunit; if(i>=n)i=n-1;
		int j=(int)y/yunit; if(j>=n)j=n-1;

		switch (event.getAction()) {
		case MotionEvent.ACTION_DOWN:
			if (shuffle == 2 && victory) {
				finish = true;
				game.showDialog();
				break;
			}
			if(shuffle!=0){
				if (shuffle==1) {
					// VFCNɃ^b`I[gVbtɐ؂ւ
					while (sensorCount < shakeMin) {
						changeRandom(limit, limit);
					}
					// end accelerometer sensor
					manager.unregisterListener(this);

					while (table[empty/n][empty%n] == -1) {
						victory = true;
						check:for (int a = 0; a < n; a++)
							for (int b = 0; b < n; b++)
								if (table[a][b] != a*n+b && table[a][b] != -1) {
									victory = false;
									break check;
								}
						if (victory)
							changeRandom(limit, limit);
						else
							break;
					}
					
					start = System.currentTimeMillis();
					shuffle = 2;
				}

				downX = x;
				downY = y;
				pointX = x;
				pointY = y;
				selectX = i;
				selectY = j;
				showHint = false;

				if (i == empty%n && j == empty/n)
					hint = !hint;
			}
			else{
				if (empty/n == j && empty%n == i) {
					Toast toast = Toast.makeText(game, "SHAKE!", Toast.LENGTH_LONG);
					toast.show();

					shuffle=1;
					sensorCount = 0;
					// start accelerometer sensor
					List<Sensor> sensors = manager.getSensorList(Sensor.TYPE_ACCELEROMETER);
					if (sensors.size() > 0) {
						Sensor s = sensors.get(0);
						manager.registerListener(this, s, SensorManager.SENSOR_DELAY_UI);
					}
					time = System.currentTimeMillis();	
				} else {
					table[empty/n][empty%n]=empty;
					empty=j*n+i;
					table[j][i]=-1;
				}
			}
			break;
		case MotionEvent.ACTION_UP:
			if (victory) break;
			if (shuffle != 2) break;
			showHint = true;
			boolean swap = false;
			switch (getEmpty(selectY, selectX)) {
			case 'U':
				if (downY-pointY >= yunit/3) {
					table[selectY-1][selectX] = table[selectY][selectX];
					swap = true;
				}
				break;
			case 'D':
				if (pointY-downY >= yunit/3) {
					table[selectY+1][selectX] = table[selectY][selectX];
					swap = true;
				}
				break;
			case 'L':
				if (downX-pointX >= xunit/3) {
					table[selectY][selectX-1] = table[selectY][selectX];
					swap = true;
				}
				break;
			case 'R':
				if (pointX-downX >= xunit/3) {
					table[selectY][selectX+1] = table[selectY][selectX];
					swap = true;
				}
				break;
			}
			if (swap) {
				table[selectY][selectX] = -1;
				empty = selectY*n + selectX;
				changeCount++;
			}
			selectX = selectY = -1;
			
			//if done the puzzle
			if (table[empty/n][empty%n] == -1) {
				victory = true;
				check:for (int a = 0; a < n; a++)
					for (int b = 0; b < n; b++)
						if (table[a][b] != a*n+b && table[a][b] != -1) {
							victory = false;
							break check;
						}
				if (victory) {
					table[empty/n][empty%n] = empty;
					end = System.currentTimeMillis();
				}
			} else
				victory = false;
			break;
		case MotionEvent.ACTION_MOVE:
			if (shuffle == 2) {
				pointX = x;
				pointY = y;
			}
			break;
		case MotionEvent.ACTION_CANCEL:
			break;
		}

		invalidate();

		return true;
	}

	public void reshake() {
		if (shuffle != 1) return;
		List<Sensor> sensors = manager.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors.size() > 0) {
			Sensor s = sensors.get(0);
			manager.registerListener(this, s, SensorManager.SENSOR_DELAY_UI);
		}
	}
	
	public void onAccuracyChanged(Sensor sensor, int accuracy) {

	}

	public void onSensorChanged(SensorEvent event) {
		if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
			currentOrientationValues[0] = event.values[0] * 0.1f + currentOrientationValues[0] * (1.0f - 0.1f);
			currentOrientationValues[1] = event.values[1] * 0.1f + currentOrientationValues[1] * (1.0f - 0.1f);

			currentAccelerationValues[0] = event.values[0] - currentOrientationValues[0];
			currentAccelerationValues[1] = event.values[1] - currentOrientationValues[1];

			long now = System.currentTimeMillis();
			float t = (float)(now - time);
			t /= 1000.0f;
			time = now;

			speed[0] += currentAccelerationValues[0]*t;
			speed[1] += currentAccelerationValues[1]*t;

			if (sensorCount < 10) {
				sensorCount++;
			} else {
				//changePiece(speed[0], speed[1]);
				changeRandom(currentAccelerationValues[0], currentAccelerationValues[1]);
				if (sensorCount >= shakeMin)
					manager.unregisterListener(this);
			}
		}
	}

	//method for shuffle
	private void changePiece(float x, float y) { 	
		float absX = Math.abs(x);
		float absY = Math.abs(y);
		if (absX >= absY) {
			if (absX < limit) return;
			
			if (x > 0) {
				if (moveLeft()) return;
			} else {
				if (moveRight()) return;
			}

			if (absY < limit) return;
			if (y > 0) {
				moveDown();
			} else {
				moveUp();
			}
		} else {
			if (absY < limit) return;
			
			if (y > 0) {
				if (moveDown()) return;
			} else {
				if (moveUp()) return;
			}

			if (absX < limit) return;
			if (x > 0) {
				moveLeft();
			} else {
				moveRight();
			}
		}
	}

	private void changeRandom(float x, float y) {
		if (Math.abs(x) + Math.abs(y) < limit) return;
		sensorCount++;
		invalidate();
		
		int rand = (int)(Math.random()*4);
		switch (rand) {
		case 0:
			if (moveLeft()) return;
			rand = (int)(Math.random()*3);
			switch (rand) {
			case 0:
				moveRight();
				break;
			case 1:
				moveUp();
				break;
			case 2:
				moveDown();
				break;
			}
			break;
		case 1:
			if (moveRight()) return;
			rand = (int)(Math.random()*3);
			switch (rand) {
			case 0:
				moveLeft();
				break;
			case 1:
				moveUp();
				break;
			case 2:
				moveDown();
				break;
			}
			break;
		case 2:
			if (moveUp()) return;
			rand = (int)(Math.random()*3);
			switch (rand) {
			case 0:
				moveLeft();
				break;
			case 1:
				moveRight();
				break;
			case 2:
				moveDown();
				break;
			}
			break;
		case 3:
			if (moveDown()) return;
			rand = (int)(Math.random()*3);
			switch (rand) {
			case 0:
				moveLeft();
				break;
			case 1:
				moveRight();
				break;
			case 2:
				moveUp();
				break;
			}
			break;
		}
	}

	private boolean moveLeft() {
		int j = empty % n;
		if (j == 0)
			return false;
		int i = empty / n;
		int tmp = table[i][j];
		table[i][j] = table[i][j-1];
		table[i][j-1] = tmp;
		empty--;
		return true;
	}

	private boolean moveRight() {
		int j = empty % n;
		if (j == n-1)
			return false;
		int i = empty / n;
		int tmp = table[i][j];
		table[i][j] = table[i][j+1];
		table[i][j+1] = tmp;
		empty++;
		return true;
	}

	private boolean moveUp() {
		int i = empty / n;
		if (i == 0)
			return false;
		int j = empty % n;
		int tmp = table[i][j];
		table[i][j] = table[i-1][j];
		table[i-1][j] = tmp;
		empty -= n;
		return true;
	}

	private boolean moveDown() {
		int i = empty / n;
		if (i == n-1)
			return false;
		int j = empty % n;
		int tmp = table[i][j];
		table[i][j] = table[i+1][j];
		table[i+1][j] = tmp;
		empty += n;
		return true;
	}

}
