package jp.ac.osaka_u.ist.sel.picturepuzzle;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.Spanned;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;

public class ThirdActivity extends Activity {


	ImageView image;
	int width;
	int height;

	private GameView gameview;
	private SensorManager manager;

	private long pauseStart = 0;
	private long pauseEnd = 0;
	private long pauseTime = 0;

	private GameData gd;

	private RankingData rd;

	class MyFilter implements InputFilter {
		public CharSequence filter(CharSequence source, int start, int end,
				Spanned dest, int dstart, int dend) {
			if( source.toString().matches("^[a-zA-Z]+$") ){
				return source;
			}else{
				String tmp = source.toString();
				source = (CharSequence) tmp.replaceAll("[^a-zA-Z]", "");
				return source;
			}
		}
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Intent intent = getIntent();
		StoreData data = (StoreData)intent.getSerializableExtra("StoreData");

		WindowManager wm = (WindowManager)getSystemService(WINDOW_SERVICE);
		Display disp = wm.getDefaultDisplay();

		width = disp.getWidth();
		height = disp.getHeight();

		//delete status bar, title
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);

		int sourcenum = (int) data.getSource();

		manager = (SensorManager)getSystemService(SENSOR_SERVICE);
		gd = (GameData)getLastNonConfigurationInstance();
		if (gd == null) {
			gameview= new GameView(this,sourcenum,data.getAdder(),data.getNumber(), manager);
			Toast toast = Toast.makeText(this, "Select Piece", Toast.LENGTH_LONG);
			toast.show();
		} else {
			// GameView̏ԕ
			gameview = new GameView(this,sourcenum,data.getAdder(),data.getNumber(), manager);
			gameview.setEmptyValue(gd.empty);
			gameview.setShuffle(gd.shuffle);
			for (int i = 0; i < gameview.getN(); i++)
				gameview.setTable(gd.table[i], i);
			gameview.setSensorCount(gd.sensorCount);
			gameview.setChangeCount(gd.changeCount);
			gameview.setHint(gd.hint);
			gameview.setVictory(gd.victory);
			gameview.setStartTime(gd.start);
			gameview.setEndTime(gd.end);
			gameview.setFinish(gd.finish);
			pauseTime = gd.pauseTime;
			if (gd.finish) showDialog();
			gameview.refresh();
		}
		setContentView(gameview);
		gameview.requestFocus();
	}

	@Override
	public GameData onRetainNonConfigurationInstance() {
		// GameView̏ԕۑ
		gd = new GameData(gameview.getN());
		gd.empty = gameview.getEmptyValue();
		gd.shuffle = gameview.getShuffle();
		for (int i = 0; i < gameview.getN(); i++)
			gd.table[i] = gameview.getTable(i);
		gd.sensorCount = gameview.getSensorCount();
		gd.changeCount = gameview.getChangeCount();
		gd.hint = gameview.getHint();
		gd.victory = gameview.getVictory();
		gd.start = gameview.getStartTime();
		gd.end = gameview.getEndTime();
		pauseStart = System.currentTimeMillis();
		gd.finish = gameview.getFinish();
		gd.pauseTime = pauseTime;
		return gd;
	}

	public void onResume() {
		super.onResume();
		pauseEnd = System.currentTimeMillis();
		if (pauseStart != 0 && !gameview.getFinish())
			pauseTime += pauseEnd - pauseStart;
		gameview.reshake();
	}

	public void onStop() {
		super.onStop();
		pauseStart = System.currentTimeMillis();
		manager.unregisterListener(gameview);
	}


	public void showDialog(){
		int pause = (int)(pauseTime/1000);
		AlertDialog alertdialog;
		final int total = gameview.getTime() - pause;

		// t@C烉LOǂݍ
		try {
			FileInputStream rankfile = openFileInput("ranking");
			ObjectInputStream rank = new ObjectInputStream(rankfile);
			rd = (RankingData) rank.readObject();
			rank.close();
		} catch (Exception e) {
			rd = new RankingData();
		}

		if (rd.isNewRecord(total, gameview.getChange(), gameview.getN())) {
			//O_CAOłsetRecord
			//O͉p̂݁ARȓ
			final EditText txt=new EditText(this);

			InputFilter[] filters = { new MyFilter(), new InputFilter.LengthFilter(3) };
			txt.setFilters(filters);

			alertdialog=new AlertDialog.Builder(ThirdActivity.this)
			.setTitle("New record! Input your name!")
			.setMessage(Integer.toString(total) + " seconds  " + 
					Integer.toString(gameview.getChange()) + " move")
					.setView(txt)
					.setPositiveButton("Register",new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int which) {
							String tmp = txt.getText().toString();
							if (tmp.equals(""))
								tmp = "***";
							if (tmp.length() > 3)
								tmp = tmp.substring(0, 3);
							rd.setRecord(tmp, total, gameview.getChange(), gameview.getN());

							// VȃLOt@Cɏo͂
							try {
								FileOutputStream r = openFileOutput("ranking", Context.MODE_PRIVATE);
								ObjectOutputStream rankout = new ObjectOutputStream(r);
								rankout.writeObject(rd);
								rankout.close();
							} catch (Exception e) {

							}
							end();
						}
					}) 
					.create();
		}
		else{
			alertdialog=new AlertDialog.Builder(ThirdActivity.this)
			.setTitle("Congratulations! You won.")
			.setMessage(Integer.toString(gameview.getTime()-pause) + " seconds  " + 
					Integer.toString(gameview.getChange()) + " move\n" + 
					"Click OK to return. ")
					.setPositiveButton("OK",new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int which) {
							end();
						}
					}) 
					.create();
		}
		alertdialog.show();
	}

	public void end(){
		Intent intent = new Intent();
		intent.setClassName("jp.ac.osaka_u.ist.sel.picturepuzzle", "jp.ac.osaka_u.ist.sel.picturepuzzle.AndroidProject1Activity");
		intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		startActivity(intent);
	}

}
