package jp.ac.osaka_u.ist.sel.android.prefectures;

import java.util.ArrayList;


import android.media.MediaPlayer;
import android.os.Bundle;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.speech.RecognizerIntent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.ImageView;
import android.widget.Toast;

public class Game extends Activity {

	public TextView AnsTxt,countryTxt,seikaiTxt,restTxt;
	public Button btn,btn2,backButton;
	public Show show;//県の形を表示するクラス
	public Judge judge;//問いに対する正しい答えかどうかを判別する

	public ArrayList<Bitmap> QuestionBmp = new ArrayList<Bitmap> ();//県のビットマップ

	public ArrayList<Integer> mondaibango = new ArrayList<Integer>();//問題を出す順番
	public Bitmap bitmap,kenBmp;
	public ImageView imageView;

	public Ran ran;//問題を出す順番を決める乱数

	private int counter=0;
	public Resources r;

	private View v2;

	//問題数(MONDAISU+1)が質題される
	public  int MONDAISU = 4;

	//正解数
	public int seikaisu = 0;

	private static final int REQUEST=0;

	//47の県名にあてはまるかどうか
	public Prefectures prefectures;

	//音楽再生用変数
	public MediaPlayer _mp = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        /*描画クラスを設定*/


        Intent intent = getIntent();
        Bundle extras = intent.getExtras();
        MONDAISU=Integer.parseInt(extras.getString("Question_number")) - 1;



        /*
        //レイアウト作成
        LinearLayout layout = new LinearLayout(this);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setGravity(Gravity.CENTER );
        setContentView(layout);
		*/
        setContentView(R.layout.activity_game);

        //画像
        show = new Show(this);
        QuestionBmp = show.AllPrefectureBpm();

        //乱数設定、問題を出す順番
        ran = new Ran();
        mondaibango = ran.list;

        //回答があっているかどうかを判定する
        judge = new Judge();

        prefectures = new Prefectures();

        imageView = (ImageView)findViewById(R.id.pref_view);
        imageView.setImageBitmap(QuestionBmp.get(mondaibango.get(counter)));


        AnsTxt = (TextView)findViewById(R.id.ans_text);
        countryTxt = (TextView)findViewById(R.id.country_text);
        seikaiTxt = (TextView)findViewById(R.id.seikai_text);
        restTxt = (TextView)findViewById(R.id.rest_text);
        restTxt.setText(String.valueOf(MONDAISU+1));
        seikaiTxt.setText(String.valueOf(seikaisu));


        /*
        //ボタン
        btn = new Button(this);
        btn.setText("回答する");
        layout.addView(btn,new LinearLayout.LayoutParams(WC,WC));
		*/
        btn = (Button)findViewById(R.id.ans_button);

        /*
        btn2 = new Button(this);
        btn2.setText("音声入力");
        layout.addView(btn2,new LinearLayout.LayoutParams(WC,WC));
        */
        btn2 = (Button)findViewById(R.id.voice_button);

        backButton = (Button)findViewById(R.id.back_button);
        //backButton=(Button)findViewById(R.id.voice_button);



        /*
        //回答テキスト
        AnsTxt = new TextView(this);
        AnsTxt.setText("回答");
        layout.addView(AnsTxt,new LinearLayout.LayoutParams(WC,WC));
        */
        //AnsTxt = (TextView)findViewById(R.id.ans_text);

        //ボタンのイベント設定
        btn.setOnClickListener(new OnClickListener(){
        	public void onClick(View v){
        		dialog(v);
        	}
        });

        //ボタン2のイベント設定
        btn2.setOnClickListener( new View.OnClickListener(){
        	public void onClick(View v){
        		try{

        			Intent intent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);

        			intent.putExtra(RecognizerIntent.EXTRA_PROMPT, "音声を文字で出力します");

        			startActivityForResult(intent, REQUEST);

        		}catch (ActivityNotFoundException e){

        			Toast.makeText(Game.this, "アクティビティが見つかりません", Toast.LENGTH_LONG).show();

        		}
        	}
        });


        backButton.setOnClickListener(new OnClickListener(){
        	public void onClick(View v){
        		finish();
        	}
        });


    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
       // 自分が投げたインテントであれば応答する
       if (requestCode == REQUEST && resultCode == RESULT_OK) {
           String speakedString = "";

           // 結果文字列リスト
           // 複数の文字を認識した場合，結合して出力
           ArrayList<String> speechToChar = data.getStringArrayListExtra(
                   RecognizerIntent.EXTRA_RESULTS);

           for (int i = 0; i< speechToChar.size(); i++) {
               speakedString += speechToChar.get(i);
           }

           //　文字が短かった場合空白文字でパディング
           for (int i = (20-speakedString.length()); i>0; i--)
              speakedString += " ";


           AnsTxt.setText(prefectures.hosei(speakedString) );
       }
       super.onActivityResult(requestCode, resultCode, data);
   }

/*
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_game, menu);
        return true;
    }
*/
    //入力した文字列が正しいかどうかを問うダイアログ
    public void dialog(View v){
    	v2 =v;
		AlertDialog.Builder dlg;
		dlg = new AlertDialog.Builder(v.getContext());
		dlg.setTitle("回答チェック");

		//正解、不正解判定
		dlg.setMessage(AnsTxt.getText());
		dlg.setPositiveButton("OK", new DialogInterface.OnClickListener(){
			public void onClick(DialogInterface dialog, int which){
				kaitouDialog(v2);
			}});
		dlg.setNegativeButton("再入力",new DialogInterface.OnClickListener(){
			public void onClick(DialogInterface dialog, int which){
			}});
		dlg.show();
    }

    //次の問題に遷移
    public void showNext(){
    	if (counter<MONDAISU){
    		counter++;
    		imageView.setImageBitmap(QuestionBmp.get(mondaibango.get(counter)));
    		//AnsTxt.setText("　　");
            restTxt.setText( String.valueOf(MONDAISU+1-counter) );
            seikaiTxt.setText(String.valueOf(seikaisu) );
    	};
    }

    //正解、不正解を表示するダイアログ
    public void kaitouDialog(View v){
    	v2=v;
    	AlertDialog.Builder kaitouDlg;
    	kaitouDlg = new AlertDialog.Builder(v.getContext());

    	//判定する
    	if(judge.Hantei(mondaibango.get(counter),AnsTxt.getText().toString())==true){
    		kaitouDlg.setTitle("判定");
    		kaitouDlg.setMessage("正解");
    		seikaisu++;
    		//正解音出力
    		_mp = MediaPlayer.create(this, R.raw.maru);//res/raw/maru.mp3を再生
    		_mp.start();
    		//_mp.release();
    	}else{
    		kaitouDlg.setTitle("不正解です。正解は↓↓↓");
    		kaitouDlg.setMessage(judge.ansPrefecture);
    		//不正解音出力
   		 	_mp = MediaPlayer.create(this, R.raw.batsu);//res/raw/batsu.mp3を再生
   		 	_mp.start();
   		 	//_mp.release();
    	}

    	if(counter<MONDAISU){
			showNext();
    		kaitouDlg.setPositiveButton("次の問題",new DialogInterface.OnClickListener(){
    			public void onClick(DialogInterface dialog, int which){
    			}});
    		kaitouDlg.show();
    	}else{
    		Reset();
    		kaitouDlg.setPositiveButton("終了",new DialogInterface.OnClickListener(){
    			public void onClick(DialogInterface dialog, int which){
    				//Reset();
    				ResultDialog(v2);
    			}});
    		kaitouDlg.show();
    	}

    }

    //正解数を表示するダイアログ
    public void ResultDialog(View v){
    	AlertDialog.Builder resultDlg;
    	resultDlg = new AlertDialog.Builder(v.getContext());
    	resultDlg.setTitle("正解数");
    	resultDlg.setMessage(String.valueOf(seikaisu)+" / "+String.valueOf(MONDAISU+1));
    	resultDlg.setPositiveButton("もう一度",new DialogInterface.OnClickListener(){
			public void onClick(DialogInterface dialog, int which){
				//Reset();
			}});
    	resultDlg.setNegativeButton("戻る",new DialogInterface.OnClickListener(){
    		public void onClick(DialogInterface dialog, int which){
    			finish();
    		}});
		resultDlg.show();
    }

    public void Reset(){
    	counter = 0;
    	seikaisu = 0;
		AnsTxt.setText("　　");
		restTxt.setText(String.valueOf(MONDAISU+1));
		seikaiTxt.setText(String.valueOf(seikaisu));
        ran = new Ran();
        mondaibango = ran.list;
        imageView.setImageBitmap(QuestionBmp.get(mondaibango.get(counter)));
    }
}