package jp.ac.osaka_u.ist.sel.android.prefectures;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;

public class MainActivity extends Activity {

	private int num = 10;
	private static final int OPTION = 1;
	private static final int GAME = 2;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // ボタン設定
        Button start_button = (Button)findViewById(R.id.start_button);
        start_button.setOnClickListener(new View.OnClickListener(){
        	@Override
            public void onClick(View v) {
                start_button_OnClickListener(v);
            }
        });
        Button howto_button = (Button)findViewById(R.id.howto_button);
        howto_button.setOnClickListener(new View.OnClickListener(){
        	@Override
            public void onClick(View v) {
                howto_button_OnClickListener(v);
            }
        });
        Button option_button = (Button)findViewById(R.id.option_button);
        option_button.setOnClickListener(new View.OnClickListener(){
        	@Override
            public void onClick(View v) {
                option_button_OnClickListener(v);
            }
        });

    }

    // STARTボタンクリック処理
    private void start_button_OnClickListener(View v) {
        Intent intent = new Intent(this,Game.class);
    	intent.putExtra("Question_number",String.valueOf(num));
        startActivity(intent);
    	Log.v("STARTBUTTON","Click");
    }

    // HOW TOボタンクリック処理
    private void howto_button_OnClickListener(View v) {
    	Intent intent = new Intent(this,Howto.class);
        startActivity(intent);
    }
    // OPTIONボタンクリック処理
    private void option_button_OnClickListener(View v) {
        Intent intent = new Intent(this,Option.class);
        intent.putExtra("Question_number", String.valueOf(num));
        startActivityForResult(intent, OPTION);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (requestCode == OPTION){
        	Log.v("ABC","TEST");
        	if(resultCode == RESULT_OK){
        		Bundle extras = intent.getExtras();
        		if (extras != null){
        			num = Integer.parseInt(extras.getString("Option_num"));
        		}else{

        		}

        	}
        }else if (requestCode == GAME){
            //結果出力
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}
