package jp.ac.osaka_u.ist.sel.android.prefectures;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;

public class Option extends Activity {
	
    private RadioGroup radioGroup;

	@Override
    public void onCreate(Bundle savedInstanceState) {
    	Log.v("Option", "CALLED");
    	super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_option);
        
        // ボタン設定
        Button back_button = (Button)findViewById(R.id.back_button);  
        back_button.setOnClickListener(new View.OnClickListener(){  
        	@Override  
            public void onClick(View v) {  
                back_button_OnClickListener(v);      
            }
        });
        
        // ラジオボタンの初期化処理
        Intent intent = getIntent();
        Bundle extras = intent.getExtras();
        radioGroup = (RadioGroup) findViewById(R.id.radiogroup);
        // 指定したIDのラジオボタンをチェック
        switch(Integer.parseInt(extras.getString("Question_number"))){
        case 5:
        	radioGroup.check(R.id.radio_5);
        	break;
        case 10:
        	radioGroup.check(R.id.radio_10);
        	break;
        case 20:
        	radioGroup.check(R.id.radio_20);
        	break;
        case 30:
        	radioGroup.check(R.id.radio_30);
        	break;
        case 47:
        	radioGroup.check(R.id.radio_47);
        	break;
        }
     }
     
    // BACKボタンクリック処理
    private void back_button_OnClickListener(View v) {  
    	// チェックされているラジオボタンの ID を取得
        RadioButton radioButton = (RadioButton) findViewById(radioGroup.getCheckedRadioButtonId());

    	Intent intent = new Intent();  
        intent.putExtra("Option_num", radioButton.getText());  
        setResult(RESULT_OK,intent);  
    	finish(); //Activityの終了
    }
}
