package jp.ac.osaka_u.ist.sel.crossword;

import jp.ac.osaka_u.ist.sel.crossword.board.KeywordData;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class InputManager {
	public enum Method{VOICE,KEYPAD};
	private Method method;
	private PuzzleActivity activity;
	public InputManager(PuzzleActivity activity,Method method) {
		// TODO Auto-generated constructor stub
		this.method=method;
		this.activity=activity;
		System.out.println("IM:"+method);
	}
	public InputManager(PuzzleActivity activity) {
		// TODO Auto-generated constructor stub
		this(activity,Method.KEYPAD);
		System.out.println("IM:default");
	}
	public void changeMethod(){
		if(method.equals(Method.KEYPAD)){
			method=Method.VOICE;
		}else{
			method=Method.KEYPAD;
		}
	}
	public Method getMethod(){
		return method;
	}
	public void startInput(final KeywordData k){
		if(method.equals(Method.VOICE)){
			Intent intent=new Intent(activity,InputManagerActivity.class);
			intent.putExtra(InputManagerActivity.KEYWORD_DATA, k);
			activity.startActivityForResult(intent, InputManagerActivity.REQUEST_CODE);
		}else{
			final EditText editText=new EditText(activity);
			AlertDialog.Builder builder=new AlertDialog.Builder(activity);
			builder.setView(editText);
			builder.setMessage(k.toHintString());
			builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
				
				@Override
				public void onClick(DialogInterface dialog, int which) {
					// TODO Auto-generated method stub
					activity.sendInput(editText.getText().toString(),k);
				}
			});
			builder.setNegativeButton("LZ",new DialogInterface.OnClickListener() {
				
				@Override
				public void onClick(DialogInterface dialog, int which) {
					// TODO Auto-generated method stub
					
				}
			});
			final Dialog dialog=builder.create();
			editText.addTextChangedListener(new TextWatcher() {
				
				@Override
				public void onTextChanged(CharSequence s, int start, int before, int count) {
					// TODO Auto-generated method stub
					if(s.toString().contains("\n")){
						String line=s.toString().replace("\n", "");
						activity.sendInput(line,k);
						dialog.dismiss();
					}
				}
				
				@Override
				public void beforeTextChanged(CharSequence s, int start, int count,
						int after) {
					// TODO Auto-generated method stub
				}
				
				@Override
				public void afterTextChanged(Editable s) {
					// TODO Auto-generated method stub
					
				}
			});
			dialog.show();
		}
	}
	public void configureButton(Button b,final KeywordData k){
		System.out.println("CB");
		if(method.equals(Method.VOICE)){
			b.setText("");
		}else{
			b.setText("L[");
		}
		b.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				startInput(k);
			}
		});
	}
}
