package jp.ac.osaka_u.ist.sel.crossword;


import jp.ac.osaka_u.ist.sel.crossword.board.KeywordData;
import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.ChoiceNotFoundException;
import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.VoiceRecognitionActivity;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;

public class InputManagerActivity extends Activity {
	public static final String KEYWORD_DATA="INPUT_MANAGER_ACTIVITY_KEYWORD_DATA";
	public static final String RESULT="INPUT_MANAGER_ACTIVITY_RESULT";
	public static final int REQUEST_CODE=27466;
	private KeywordData keywordData;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		keywordData=(KeywordData)getIntent().getExtras().getSerializable(KEYWORD_DATA);
		Intent intent=new Intent(this,VoiceRecognitionActivity.class);
//		intent.putExtra(VoiceRecognitionActivity.WORD_LENGTH, keywordData.getKeyword().length());
		intent.putExtra(VoiceRecognitionActivity.KEYWORD_DATA, keywordData);
		startActivityForResult(intent, VoiceRecognitionActivity.REQUEST_CODE);
	}
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		// TODO Auto-generated method stub
		super.onActivityResult(requestCode, resultCode, data);
		if(requestCode==VoiceRecognitionActivity.REQUEST_CODE){
			//Fp̏
			if(resultCode==RESULT_OK){
				String result=data.getStringExtra(VoiceRecognitionActivity.RECOGNITION_RESULT);
				if(result==null){
					if(data.getSerializableExtra(VoiceRecognitionActivity.RECOGNITION_RESULT)instanceof ChoiceNotFoundException){
						Toast.makeText(this, "͂̌₪܂ł", Toast.LENGTH_LONG).show();
					}
				}else{
					Intent intent=new Intent();
					intent.putExtra(KEYWORD_DATA, keywordData);
					intent.putExtra(RESULT, result);
					setResult(Activity.RESULT_OK, intent);
				}
				finish();
			}
		}
	}
}
