package jp.ac.osaka_u.ist.sel.crossword;

import java.io.Serializable;

import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.ChoiceNotFoundException;
import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.RecognitionCanceledException;
import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.VoiceRecognitionActivity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Point;
import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

	private final int MENU_ID1 = Menu.FIRST;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		sizeAdjustment();
	}
	
	private void sizeAdjustment(){
		//[̉ʃTCY̎擾
		Point size = new Point();
		WindowManager wm = (WindowManager)getSystemService(WINDOW_SERVICE);
		Display disp = wm.getDefaultDisplay();
		disp.getSize(size);
			Log.d("width", "width:"+ size.x);
			Log.d("height", "height:"+ size.y);

			float scale = Math.min(size.x, size.y);
			
			TextView title = (TextView)findViewById(R.id.title);
			title.setTextSize(TypedValue.COMPLEX_UNIT_PX, scale / 10.0f);
			//title.setTextSize(scale / 10.0f);
			Button startButton = (Button)findViewById(R.id.start_button);
			startButton.setTextSize(TypedValue.COMPLEX_UNIT_PX,scale / 20.0f);
			Button finishButton = (Button)findViewById(R.id.finish_button);
			finishButton.setTextSize(TypedValue.COMPLEX_UNIT_PX,scale / 20.0f);
	}	
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
	    super.onCreateOptionsMenu(menu);

	    menu.add(0,MENU_ID1,1,"AvI"); 
        return true;
	}

	/**
     * j[{^̏
     */
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }
    /**
     * j[Ȉ
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        case MENU_ID1:
            //AvI
        	appli_finish();
            return true;
        default:
            break;
        }
        return super.onOptionsItemSelected(item);
    }

    /**
     * AvI
     */
    private void appli_finish(){
		// _CAO̍쐬
    	AlertDialog.Builder alertDialog=new AlertDialog.Builder(this);
        alertDialog.setTitle("Av̏I̊mF");
        alertDialog.setMessage("AvI܂H");
        alertDialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // OK{^̏
                moveTaskToBack(true);
            }
        });
        alertDialog.setNegativeButton("", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // NG{^̏
            }
        });
        alertDialog.show();
    }
    


	public void onClick_start_selection_button(View v){        
        Intent intent_start_button = new Intent();
        intent_start_button.setClassName(
        		"jp.ac.osaka_u.ist.sel.crossword",
        		"jp.ac.osaka_u.ist.sel.crossword.SelectionActivity");
        startActivity(intent_start_button);
        
	}
	

	public void onClick_finish_button(View v){        
    	appli_finish();
        
	}
}
