package jp.ac.osaka_u.ist.sel.crossword;

import java.io.IOException;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.crossword.R.id;
import jp.ac.osaka_u.ist.sel.crossword.board.CrossWordBoardView;
import jp.ac.osaka_u.ist.sel.crossword.board.KeywordData;
import jp.ac.osaka_u.ist.sel.crossword.board.QuestionDataException;
import jp.ac.osaka_u.ist.sel.crossword.board.QuestionReader;
import jp.ac.osaka_u.ist.sel.crossword.voice.recognizer.ToKana;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Point;
import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ToggleButton;

public class PuzzleActivity extends Activity {

	private final int MENU_ID1 = Menu.FIRST;
	private final int MENU_ID2 = Menu.FIRST + 1;
	private final int MENU_ID3 = Menu.FIRST + 2;
	private final int MENU_ID4 = Menu.FIRST + 3;

	private final String SAVED_STATE_KEY="SAVED_STATE_KEY";

	private InputManager inputManager;
	private ArrayList<KeywordData> keywordDatas;
	private int[][] hintsPotision;

	CrossWordBoardView view;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_puzzle);

		inputManager=new InputManager(this);
		sizeAdjustment();

		//CegpỸt@C擾
        Intent intent = getIntent();
        String filename = intent.getStringExtra("FILENAME");
		Log.d("intent", "filename:"+ filename);

		/* Ֆʂ̍쐬 */
		try {
//			QuestionReader reader = new QuestionReader("question_sample.dat", getResources());
			//QuestionReader reader = new QuestionReader("nk1.dat", getResources());
			QuestionReader reader = new QuestionReader(filename, getResources());

			keywordDatas=reader.getKeywordList();
			hintsPotision=reader.getNumbers();

			Log.d("board", "TextView Create");

			LinearLayout layout = (LinearLayout) findViewById(R.id.layout_board);

			view = new CrossWordBoardView(this, reader);
			layout.addView(view);

//			view.setCurrentWord(1, KeywordData.ORIENT_HEIGHT, "Ђ͂");
//    		view.setCurrentWord(24, KeywordData.ORIENT_WIDTH, "Ԃ킵");
//    		view.setCurrentWord(21, KeywordData.ORIENT_HEIGHT, "", true);
//    		view.setCurrentWord(19, KeywordData.ORIENT_HEIGHT, "ꂿ", false);
//    		view.setCurrentWord(19, KeywordData.ORIENT_WIDTH, "", true);
//    		view.clearCurrentWord(19, KeywordData.ORIENT_WIDTH);


		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (QuestionDataException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}

		createImageView();

		createKeyView();
	}


	private void sizeAdjustment(){
		//[̉ʃTCY̎擾
		Point size = new Point();
		WindowManager wm = (WindowManager)getSystemService(WINDOW_SERVICE);
		Display disp = wm.getDefaultDisplay();
		disp.getSize(size);
			Log.d("width", "width:"+ size.x);
			Log.d("height", "height:"+ size.y);

			float scale = Math.min(size.x, size.y);

			TextView title = (TextView)findViewById(R.id.button_delete);
			title.setTextSize(TypedValue.COMPLEX_UNIT_PX, scale / 30);
	}

	private void createImageView(){
		//TextView擾
        WebView creditview = (WebView) findViewById(id.CreditView);
        creditview.loadUrl("file:///android_asset/credit.html");

	}

	private void createKeyView(){
		((LinearLayout) findViewById(R.id.layout_key_across)).removeAllViews();
		((LinearLayout) findViewById(R.id.layout_key_down)).removeAllViews();
		for(KeywordData k:keywordDatas){
			if(k.getOrient()==KeywordData.ORIENT_HEIGHT){
				add_key_down(k.getNumber(),k.getHint(),k);
			}else{
				add_key_across(k.getNumber(),k.getHint(),k);
			}
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
	    super.onCreateOptionsMenu(menu);

        menu.add(0,MENU_ID1, 0,"͐ؑ");
        menu.add(0,MENU_ID2,0,"MuAbv");
        menu.add(0,MENU_ID3,0,"Iɖ߂");
	    menu.add(0,MENU_ID4,1,"AvI");
	    return true;
	}

	/**
     * j[{^̏
     */
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }

    /**
     * j[Ȉ
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        case MENU_ID1:
        	inputManager.changeMethod();
        	createKeyView();
        	return true;
        case MENU_ID2:
        	//MuAbv
        	giveUp();
        	return true;
        case MENU_ID3:
            //ANeBreBI
        	activity_finish();
            return true;
        case MENU_ID4:
            //AvI
        	appli_finish();
            return true;
        default:
            break;
        }
        return super.onOptionsItemSelected(item);
    }

    private void giveUp(){
		// _CAO̍쐬
    	AlertDialog.Builder alertDialog=new AlertDialog.Builder(this);
        alertDialog.setTitle("MuAbv̊mF");
        alertDialog.setMessage("MuAbv܂H");
        alertDialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // OK{^̏
            	view.setCheckFlag(true);
            	view.setShowAnswer(true);
            }
        });
        alertDialog.setNegativeButton("", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // NG{^̏
            }
        });
        alertDialog.show();
    }
    /**
     * I֖߂
     * ANeBreB̏I
     */
    private void activity_finish(){
		// _CAO̍쐬
    	AlertDialog.Builder alertDialog=new AlertDialog.Builder(this);
        alertDialog.setTitle("pYI̊mF");
        alertDialog.setMessage("Iʂɖ߂܂H");
        alertDialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // OK{^̏
                finish();
            }
        });
        alertDialog.setNegativeButton("", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // NG{^̏
            }
        });
        alertDialog.show();
    }

    /**
     * AvI
     */
    private void appli_finish(){
		// _CAO̍쐬
    	AlertDialog.Builder alertDialog=new AlertDialog.Builder(this);
        alertDialog.setTitle("Av̏I̊mF");
        alertDialog.setMessage("AvI܂H");
        alertDialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // OK{^̏
                moveTaskToBack(true);
            }
        });
        alertDialog.setNegativeButton("", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // NG{^̏
            }
        });
        alertDialog.show();
    }

	/**
	 * R̃JMɑΉCAEg쐬郁\bh
	 */
	public void add_key_across(int number, String text,KeywordData keywordData){
		LinearLayout layout = (LinearLayout) findViewById(R.id.layout_key_across);
		add_key(layout,number,text,keywordData);
	}

	/**
	 * ^ẽJMɑΉCAEg쐬郁\bh
	 */
	public void add_key_down(int number, String text,KeywordData keywordData){
		LinearLayout layout = (LinearLayout) findViewById(R.id.layout_key_down);
		add_key(layout,number,text,keywordData);
	}

	/**
	 * ^eR̃JMɑΉ郌CAEg쐬郁\bhĂ΂
	 */
	private void add_key(LinearLayout layout, int number, String text,KeywordData keywordData){
		LinearLayout layout1 = new LinearLayout(this);
		layout1.setLayoutParams(new LinearLayout.LayoutParams(
		        ViewGroup.LayoutParams.MATCH_PARENT,
		        ViewGroup.LayoutParams.WRAP_CONTENT));

		Button button1 = new Button(this);
		button1.setLayoutParams(new LinearLayout.LayoutParams(
		        ViewGroup.LayoutParams.WRAP_CONTENT,
		        ViewGroup.LayoutParams.WRAP_CONTENT));
		inputManager.configureButton(button1, keywordData);	//ɃJMɑΉKeyWordData
		layout1.addView(button1);

		TextView textView1 = new TextView(this);
		textView1.setText(number+":"+text+"\n");
		textView1.setLayoutParams(new LinearLayout.LayoutParams(
		        ViewGroup.LayoutParams.WRAP_CONTENT,
		        ViewGroup.LayoutParams.WRAP_CONTENT));
		layout1.addView(textView1);

		layout.addView(layout1);
	}

	/**
	 *  폜{^ONȂtrueAOFFȂfalse
	 */
	public boolean delete_button_isChecked(){
		ToggleButton delete_button = (ToggleButton) findViewById(R.id.button_delete);
		return delete_button.isChecked();
	}

	public ArrayList<KeywordData> getKeywordDatas(){
		return keywordDatas;
	}
	public int[][] getHintsPotision(){
		return hintsPotision;
	}
	public InputManager getInputManager(){
		return inputManager;
	}

	public void sendInput(String string,KeywordData keywordData){
		//Ֆʂɓ͓e𑗂
		view.setCurrentWord(keywordData.getNumber(), keywordData.getOrient(), ToKana.toKatakana(string), this);
	}

	public void sendDelete(int boxY,int boxX){
		view.clearCurrentWord(boxY, boxX);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		// TODO Auto-generated method stub
		super.onActivityResult(requestCode, resultCode, data);
		if(requestCode==InputManagerActivity.REQUEST_CODE){
			//͂̌
			if(resultCode==RESULT_OK){
				String result=data.getStringExtra(InputManagerActivity.RESULT);
				if(result!=null){
					sendInput(result, (KeywordData)data.getSerializableExtra(InputManagerActivity.KEYWORD_DATA));
				}
			}
		}
	}

	public CrossWordBoardView getView(){
		return view;
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		// TODO Auto-generated method stub
		super.onSaveInstanceState(outState);
		if(view.getIsGiveUpForSave()) {
			Log.d("board", "AAA");
		}
		outState.putSerializable(SAVED_STATE_KEY, new SavedState(getInputManager(), view.getCurrentWordForSave(), view.getIsGiveUpForSave()));
	}
	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onRestoreInstanceState(savedInstanceState);
		SavedState savedState=(SavedState)savedInstanceState.getSerializable(SAVED_STATE_KEY);
		inputManager=new InputManager(this, savedState.method);
		view.setCurrentWordForRestore(savedState.boardBoxes, savedState.giveUp);

		if(savedState.giveUp) {
			Log.d("board", "savedState: OK");
		}
		createKeyView();
	}
}
